/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         //tipo de actividad
         sym.setVariable("tipoactividad", "input");
         //Variables de colores
         sym.setVariable("border", "1px double #cccccc");
         sym.setVariable("fondo", "rgba(220,220,220,0.50)");
         sym.setVariable("colorini", "#333333");
         sym.setVariable("colorok", "#333333");
         sym.setVariable("fondook", "#d3e3c3");
         sym.setVariable("colorbad", "#ffffff");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("fontsize", "18px");
         sym.setVariable("fontFamily", "Cabin");
         sym.setVariable("fontStyle", "bold");
         sym.setVariable("height", "auto");
         sym.setVariable("webkit-border-radius", "5px");
         sym.setVariable("moz-border-radius", "5px");
         sym.setVariable("border-radius", "5px");

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         var vColor = "";
         	var correctos = 0;
         	var incorrectos = 0;
         	for(var i=1; i<=18; i++){		
         		var colorLetra = 	sym.$("#Stage_letra_"+i).css("color");
         		if (colorLetra == "rgb(255, 29, 37)"){
         			correctos++;  	
         		}		
         	}
         	for(var i=1; i<=12; i++){		
         		var colorLetrai = sym.$("#Stage_na_"+i).css("color");
         		if (colorLetrai == "rgb(255, 255, 255)"){
         			incorrectos++;  	
         		}		
         	}
         	if(correctos == 18 && incorrectos == 12){
         		//console.log("Muy bien!!");
         		//mensaje respuesta correcta
         		sym.$("resp_correcta").show();
         		//audio correcto
         		sym.$("success")[0].play();
         		//botones
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("down");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").hide();
         		sym.$("hotspot_reiniciar").show();
         	}	
         	else{
         		//console.log("NOO!");
         		sym.$("resp_incorrecta").show();
         		//audio incorrecto
         		sym.$("error")[0].play();
         		//botones
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").show();
         		sym.$("hotspot_reiniciar").show();
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("normal");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         	}
         
         sym.$(".letras").css("pointer-events","none");
         sym.$(".colorSelect").css("pointer-events","none");
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         	
         	sym.$(".letras").css("pointer-events","none");
         	sym.$(".colorSelect").css("pointer-events","none");
         	
         	sym.$(".combinacion").css("color","#FF1D25");
         	sym.$(".na").css("color","white");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         
         sym.$(".combinacion").css("color","white");
         sym.$(".na").css("color","white");
         
         sym.$(".letras").css("pointer-events","auto");
         sym.$(".colorSelect").css("pointer-events","auto");
         

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         $("<link/>", {"rel": "stylesheet", "type": "text/css", "href": "css/fuentes.css" }).appendTo("head");
         
         $("#Stage").css({
         	"-webkit-user-select": "none",  /* Chrome all / Safari all */
           "-moz-user-select": "none",     /* Firefox all */
           "-ms-user-select": "none",      /* IE 10+ */
           /* No support for these yet, use at own risk */
           "-o-user-select": "none",
           "user-select": "none"
         });   
         
         //sym.$(".letras").css("text-shadow","-1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000, 1px 1px 0 #000");
         //sym.$(".letras").css("text-shadow","2px 0 0 #fff, -2px 0 0 #fff, 0 2px 0 #fff, 0 -2px 0 #fff, 1px 1px #fff, -1px -1px 0 #fff, 1px -1px 0 #fff, -1px 1px 0 #fff");
         sym.$(".letras").css("text-shadow","2px 2px 4px #000000, 1px -1px 0 #000, -1px 1px 0 #000, 1px 1px 0 #000, -1px -1px 0 #000");
         
         sym.$(".letras").css({
         	"cursor":"pointer",
         	"display":"inline-block",
           	"line-height":"none",
           	"overflow":"hidden"
         });
         
         var colorLetra="white";
         
         sym.$(".colorSelect").click(function(){
         	//idColorSelect = this.id;
         	switch (this.id){
         		case "Stage_color_rojo": colorLetra="#FF1D25";
         				sym.$("#Stage_color_rojo").css("border-color","blue");
         				sym.$("#Stage_color_blanco").css("border-color","gray");						 	
         		break;		
         		case "Stage_color_blanco": colorLetra="#FFFFFF";
         				sym.$("#Stage_color_blanco").css("border-color","blue");
         				sym.$("#Stage_color_rojo").css("border-color","gray");	
         		break;	
         	}	
         });
         
         sym.$(".letras").click(function(){
         	$(this).css("color",colorLetra);
         	var colorLetra = 	$(this).css("color");
         		if (colorLetra == "rgb(255, 29, 37)"){
         			$(this).css("color","rgb(255, 255, 255)");
         		}		
         		else{
         			$(this).css("color","rgb(255, 29, 37)");
         		}	
         });
         
         sym.$(".ejemplo").unbind("click");
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-94063035");