/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         //tipo de actividad
         sym.setVariable("tipoactividad", "input");
         //Variables de colores
         sym.setVariable("border", "0px double #cccccc");
         sym.setVariable("fondo", "rgba(255,255,255,0.00)");
         sym.setVariable("colorini", "#666666");
         sym.setVariable("colorok", "#666666");
         sym.setVariable("fondook","rgba(100,220,120,0.50)");
         sym.setVariable("colorbad", "#ffffff");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("fontsize", "50px");
         sym.setVariable("fontFamily", "Cabin");
         sym.setVariable("fontStyle", "normal");
         sym.setVariable("fontweight", "bold");
         sym.setVariable("height", "auto");
         sym.setVariable("border-radius", "5px");

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         //Definición de variables
         var Total=0;
         
         var tipoactividad = sym.getVariable("tipoactividad");
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         var wrong = '';
         
         for(i=1; i<=TotalInput; i++){
         	var y = (parseInt(sym.$("Input_"+i).css("top")) +0)+"px";
         	var x = (parseInt(sym.$("Input_"+i).css("left")) -25)+"px";
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){		
         		if(transformarTexto == true){
         			var ValorInput = $(this).val().toUpperCase();
         			var ValorTemp = sym.getVariable("Respuesta_"+i).toUpperCase(); 
         			//console.log('Input: '+ValorInput+'  -  Resp: '+ValorTemp);
         		}
         		else{
         			var ValorInput = $(this).val();
         			var ValorTemp = sym.getVariable("Respuesta_"+i);
         			//console.log('Input: '+ValorInput+'  -  Resp: '+ValorTemp);
         		}
         
         		if(ValorInput==ValorTemp){
         			$(this).css({color: colorok ,background: fondook});
         			//sym.$("ok"+i).css({top: y, left: x});
         			//sym.$("ok"+i).show();
         		}
         		else{
         			wrong = 1;
         			$(this).css({color: colorbad,background: fondobad});
         			//sym.$("bad"+i).css({top: y, left: x});
         			//sym.$("bad"+i).show();
         		}
         		$(this).attr('disabled','disabled');
         	}
         });
         }
         
         if (wrong == 1){
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("resp_incorrecta").show();
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         
         }
         else{
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	//mensaje respuesta correcta
         	sym.$("resp_correcta").show();
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         sym.$("comprobarRespuesta").hide();
         sym.$("Punteo").hide();
         
         for (var i=1; i<TotalInput; i++) {
               sym.$('ok'+i).hide();
         		sym.$('bad'+i).hide();
         }
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(i=1; i<=TotalInput; i++){
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){
         		var Resp = sym.getVariable("Respuesta_"+i);
         		$(this).val(Resp);
         		$(this).val().toUpperCase();
         		$(this).css({color: colorok ,background: fondook}
         		);
         	}
         	});
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         
         for (var i=1; i<=TotalInput; i++) {
               sym.$('ok'+i).hide();
         		sym.$('bad'+i).hide();
         }
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondo");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(i=0; i<=TotalInput; i++){
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){
         		$(this).val("");
         		$(this).css({color: colorini,background: fondoini});
         		$(this).removeAttr('disabled');
         	}
         });
         }

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         //Llammar variables creation Complete
         var tipoactividad = sym.getVariable("tipoactividad");
         var color = sym.getVariable("colorini");
         var border = sym.getVariable("border");
         var tamano = sym.getVariable("fontsize");
         var fontweight = sym.getVariable("fontweight");
         var fondo = sym.getVariable("fondo");
         var borderRadius= sym.getVariable("border-radius");
         
         transformarTexto = true; // Cambiar a false, si la actividad es de lenguaje o requiere validación exacta de las palabras 
         
         TotalInput = 50;
         
         // Agregar los input dinámicamente
         for (i=1 ; i<= TotalInput; i++){
         sym.$("Input_"+i).css("background","rgba(255,255,255,0.00)");
         	var nombreElemento = 'Elemento_'+i;
         	nombreElemento = document.createElement(tipoactividad);
         	nombreElemento.id="seleccion_"+i;
         	var anchoInput = sym.$("Input_"+i).css("width");
         	var altoInput = sym.$("Input_"+i).css("height");
         	nombreElemento.style.width= anchoInput;	 
         	nombreElemento.style.height= altoInput;
         	nombreElemento.style.border= border;
         	nombreElemento.style.color= color;
         	nombreElemento.style.background= fondo;
         	nombreElemento.style.fontSize= tamano;
         	nombreElemento.style.fontWeight= fontweight;
         	nombreElemento.style.textAlign="center";
         	nombreElemento.style.webkitBorderRadius=borderRadius;
         	nombreElemento.style.mozBorderRadius=borderRadius;
         	nombreElemento.style.borderRadius=borderRadius;
         	sym.$("Input_"+i).append(nombreElemento);
         }
         
         //RESPUESTAS -- CAMBIAR VALORES
         sym.setVariable("Respuesta_1", ".");
         sym.setVariable("Respuesta_2", ",");
         sym.setVariable("Respuesta_3", ".");
         sym.setVariable("Respuesta_4", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_5", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_6", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_7", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_8", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_9", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_10", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_11", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_12", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_13", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_14", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_15", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_16", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_17", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_18", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_19", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_20", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_21", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_22", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_23", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_24", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_25", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_26", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_27", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_28", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_29", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_30", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_31", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_32", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_33", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_34", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_35", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_36", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_37", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_38", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_39", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_40", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_41", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_42", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_43", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_44", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_45", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_46", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_47", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_48", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_49", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_50", "REEMPLAZAR POR VALOR");
         
         /*	
         	Modifique el valor en pixels para el ancho de cada input según lo requiera
         */
         //seleccion_1.style.textTransform="uppercase";
         //seleccion_1.style.fontStyle="italic";

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_input").is(":visible")) {
         	sym.$("help_input").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_input").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-94063035");