/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         (function($) {
            var $fortune = function(args) {
         
             if (args === undefined) {
               throw(new Error("You must define the options.prices"));
             }
         
             var options = $.extend({}, {
               prices: args,
               duration: 1000,
               separation: 2,
               min_spins: 10,
               max_spins: 15,
               onSpinBounce: function() {}
             }, args);
         
             var fortune = this;
             var prices_amount = Array.isArray(options.prices)?options.prices.length:options.prices;
             var prices_delta = 360 / prices_amount;
             var is_spinning = false;
         
             fortune.spin = function(price) {
               price = typeof price === "number"?price:Math.floor(Math.random() * prices_amount);
               var deferred = $.Deferred();
               var position = Math.floor(prices_delta * (price - 1/2) + randomBetween(options.separation, prices_delta - options.separation));
               var spins = randomBetween(options.min_spins, options.max_spins);
               var final_position = 360 * spins + position;
               var prev_position = 0;
               var is_bouncing = false;
         
               is_spinning = true;
         
               fortune
               .css({
                 "transform": "rotate(" + final_position + "deg)",
                 "-webkit-transform": "rotate(" + final_position + "deg)",
                 "transition": "transform " + options.duration + "ms cubic-bezier(.17,.67,.12,.99)",
                 "-webkit-transition": "-webkit-transform " + options.duration + "ms cubic-bezier(.17,.67,.12,.99)"
               })
               .siblings('.spin').removeClass('bounce');
         
               var bounceSpin = function() {
                 var curPosition = Math.floor(getRotationDegrees(fortune)),
                 mod = Math.floor((curPosition + prices_delta*0.5) % prices_delta),
                 diff_position,
                 position_threshold = prices_delta/5,
                 distance_threshold = prices_delta/10;
         
                 prev_position = Math.floor(curPosition < prev_position ? prev_position - 360 : prev_position);
                 diff_position = curPosition - prev_position;
         
                 if ((mod < position_threshold && diff_position < distance_threshold) ||
                     (mod < position_threshold*3 && diff_position >= distance_threshold)) {
                   if (!is_bouncing) {
                     fortune.siblings('.spin').addClass('bounce');
                     options.onSpinBounce(fortune.siblings('.spin'));
                     is_bouncing = true;
                   }
                 } else {
                   fortune.siblings('.spin').removeClass('bounce');
                   is_bouncing = false;
                 }
         
                 if (is_spinning) {
                   prev_position = curPosition;
                   requestAnimationFrame(bounceSpin);
                 }
               };
         
               //var animSpin = requestAnimationFrame(bounceSpin);
         
               setTimeout(function() {
                 fortune
                 .css({
                   "transform": "rotate(" + position + "deg)",
                   "-webkit-transform": "rotate(" + position + "deg)",
                   "transition": "",
                   "-webkit-transition": ""
                 })
                 .siblings('.spin').removeClass('bounce');
         
                 //cancelAnimationFrame(animSpin);
                 deferred.resolve(Array.isArray(options.prices)?options.prices[price]:price);
                 is_spinning = false;
               }, options.duration);
         
               return deferred.promise();
             };
         
             var getRotationDegrees = function(obj) {
               var angle = 0,
               matrix = obj.css("-webkit-transform") ||
                 obj.css("-moz-transform")    ||
                 obj.css("-ms-transform")     ||
                 obj.css("-o-transform")      ||
                 obj.css("transform");
               if (matrix !== 'none') {
                 var values = matrix.split('(')[1].split(')')[0].split(','),
                 a = values[0],
                 b = values[1],
                 radians = Math.atan2(b, a);
         
                 if ( radians < 0 ) {
                   radians += (2 * Math.PI);
                 }
         
                 angle = Math.round( radians * (180/Math.PI));
               }
         
               return angle;
             };
         
             var randomBetween = function(min, max) {
               return Math.floor(Math.random() * (max - min + 1)) + min;
             };
         
             return fortune;
           };
         
           $.extend($.fn, {
             fortune: $fortune
           });
         }) (jQuery);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         // Change the text in an element
         sym.$("Color").html("");
         
         var options = {
           prices: [
             {
               name: 'princesa'
             },
             {
               name: 'bruja'
             },
             {
               name: 'espantapajaros'
             },
             {
               name: 'princesa'
             },
             {
               name: 'espantapajaros'
             },
             {
               name: 'princesa'
             },
             {
               name: 'bruja'
             },
             {
               name: 'espantapajaros'
             },
             {
               name: 'bruja'
             },
             {
               name: 'espantapajaros'
             },
             {
               name: 'princesa'
             },
             {
               name: 'bruja'
             }
           ],
           duration: 4000
         };
         
         var $r = $('.roulette').fortune(options);
         
         
         var clickHandler = function() {
           $('.spinner').off('click');
           $('.girar').hide();
           //var price = Math.floor((Math.random() * 8));
           $r.spin().done(function(price) {
           		var personaje = price.name;
           		//console.log(personaje);
           		$(".personajes").fadeOut();
           		if(personaje == "princesa"){
           			$("#Stage_princesa").fadeIn();
           		}
           		if(personaje == "bruja"){
           			$("#Stage_bruja").fadeIn();
           		}
           		if(personaje == "espantapajaros"){
           			$("#Stage_espantapajaros").fadeIn();
           		}  		
               $('.price ').text('Color: ' + price.name);
               $('.spinner').on('click', clickHandler);
               $('.girar').show();
             });
         };
         
         $('.spinner').on('click', clickHandler);
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
   //Edge symbol: 'bt_back'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

   })("bt_back");
   //Edge symbol end:'bt_back'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'spinner'
   (function(symbolName) {   
   
   })("spinner");
   //Edge symbol end:'spinner'

   //=========================================================
   
   //Edge symbol: 'spinner1'
   (function(symbolName) {   
   
   })("spinner1");
   //Edge symbol end:'spinner1'

})(jQuery, AdobeEdge, "EDGE-5531445");