/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 5;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 5;
         
         // Determino las respuestas correctas para cada drop en la actividad
         var dontTouch = 0;
         var Rd1 = new Array(1,dontTouch); 
         sym.setVariable("RespDrop1", Rd1);
         var Rd2 = new Array(2,dontTouch); 
         sym.setVariable("RespDrop2", Rd2);
         var Rd3 = new Array(3,dontTouch); 
         sym.setVariable("RespDrop3", Rd3);
         var Rd4 = new Array(4,dontTouch); 
         sym.setVariable("RespDrop4", Rd4);
         var Rd5 = new Array(5,dontTouch); 
         sym.setVariable("RespDrop5", Rd5);
         var Rd6 = new Array(6,dontTouch); 
         sym.setVariable("RespDrop6", Rd6);
         var Rd7 = new Array(7,dontTouch); 
         sym.setVariable("RespDrop7", Rd7);
         var Rd8 = new Array(8,dontTouch); 
         sym.setVariable("RespDrop8", Rd8);
         var Rd9 = new Array(9,dontTouch); 
         sym.setVariable("RespDrop9", Rd9);
         var Rd10 = new Array(10,dontTouch); 
         sym.setVariable("RespDrop10", Rd10);
         
         // Funcion para verificar las respuestas de cada drop
         function verificarRespuestas(RespuestaDrop,idActiveDrag){
         	var respDrop=0;
         
         	var idResp = idActiveDrag.slice(11);	
         	var vectorResp = sym.getVariable(RespuestaDrop);	
         	var respTemp = vectorResp.indexOf(parseInt(idResp));
         	if(respTemp != -1){
         		respDrop = 1;
         	}
         	else{
         		respDrop = 0;		
         	}	
         	return respDrop;	
         }
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         for(var i=1; i<=50; i++){
            sym.setVariable("DropVar"+i, 0); 
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
          sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         
         
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 	
         			sym.setVariable("DropVar"+DropId, verificarRespuestas("RespDrop"+DropId,ui.draggable.attr('id')));
               	coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));	
            	}
            });	
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         //	Copiar la siguiente función para las correcciones del material anterior
         //	Esta función permite que los elementos no se solapen
         
         // Se establece el atributo vacio para todos los elementos droppables
         sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
         
         		 $(".ui-droppable").on( "drop", function( event, ui ) {
         		 	// Verifico el estado del drop (ocupado o vacio)
         					var estadoDrop = $(this).attr("dragelement");
         
         					// 
         					if(estadoDrop != "vacio"){										
         						var numDrag = estadoDrop.slice(11);	
         						var posLeftDrag = sym.getVariable("left"+numDrag);
         						var posTopDrag = sym.getVariable("top"+numDrag);
         						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					} else{
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					}
         
         		 } );
         
         		 $(".ui-droppable").droppable({	
         				out: function( event, ui ){ 
         					var estadoDrop = $(this).attr("dragelement");
         					var idDraggable = ui.draggable.attr('id');
         					if(estadoDrop == idDraggable ){	
         						$(this).attr("dragelement","vacio");					
         					}
         					else{						
         					}
         				}
         		 });
         
         
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         var Total = 0;
         
         for(var k=1;k<=TotalDropElements;k++){
         	var DropVar = sym.getVariable("DropVar"+k);
         	Total = Total + DropVar;
         	if(DropVar==1){
         		sym.$("Drop_"+k).css({background: fondook})
         	}
         	else{
         		sym.$("Drop_"+k).css({background: fondobad});
         	}
         }
         
         // Deshabilito todos los drag mientras se validan los datos en la actividad
         sym.$('[id^="Stage_Drag_"]').draggable({
         	disabled:true
         });
         
         //Muestra las leyendas
         if(Total==TotalDropElements){
         	sym.$("resp_correcta").show();
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         
         var leftDrag = [];
         var topDrag = [];
         
         for (var h=1; h<=TotalDragElements; h++){
         	leftDrag[h] = sym.getVariable("left"+h);
         	topDrag[h] = sym.getVariable("top"+h);
         }
         
         var devueltos= TotalDropElements+1;
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.$("Drag_"+i).animate({top: topDrag[i], left: leftDrag[i]},50);
         }
         
         for(var i=1; i<=TotalDropElements; i++){
         	var vectorResp = sym.getVariable("RespDrop"+i);
         	var firstResp = vectorResp[0];
         	sym.$("Drag_"+firstResp).css({top: topDrag[i], left: leftDrag[i]});
         	coordenadas("Drop_"+i, "Drag_"+firstResp);
         	sym.$("Drop_"+i).css({background: fondook});
         }
         
         
         function coordenadas (Drop, simbolo) {
         	varxdrop = sym.$(Drop).css("left");
         	varydrop = sym.$(Drop).css("top");
         	varxdropanch = sym.$(Drop).css("width");
         	varydropalto = sym.$(Drop).css("height");
         	varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
         	varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
         	varxdraganch = sym.$(simbolo).css("width");
         	varydragalto = sym.$(simbolo).css("height");
         	varxdragcentro = parseInt(varxdraganch)/2;
         	varydragcentro = parseInt(varydragalto)/2;
         	sym.$(simbolo).animate({top: varydropcentro-varydragcentro, left: varxdropcentro-varxdragcentro},150);
         };
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(var i=1; i<=TotalDragElements; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         	sym.$("Drag_"+i).draggable ({
         		disabled: false
         	});
         	//sym.$("Drop_"+i).css({color: colorini ,background: fondoini});
         	sym.setVariable("DropVar"+i, 0);
         }
         
         sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${_btn_noticia}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_1").show();
         sym.getSymbol("pop_1").play(1);
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Button_1}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_A").show();
         
         // Reproducir la línea de tiempo en un momento o etiqueta específicos. Por ejemplo:
         // sym.play(500); o sym.play("myLabel");
         sym.getSymbol("pop_A").play(1);
         
         
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Button_2}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_B").show();
         
         // Reproducir la línea de tiempo en un momento o etiqueta específicos. Por ejemplo:
         // sym.play(500); o sym.play("myLabel");
         sym.getSymbol("pop_B").play(1);
         
         
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Button_3}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_C").show();
         
         // Reproducir la línea de tiempo en un momento o etiqueta específicos. Por ejemplo:
         // sym.play(500); o sym.play("myLabel");
         sym.getSymbol("pop_C").play(1);
         
         
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Button_4}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_D").show();
         
         // Reproducir la línea de tiempo en un momento o etiqueta específicos. Por ejemplo:
         // sym.play(500); o sym.play("myLabel");
         sym.getSymbol("pop_D").play(1);
         
         
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();
         
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Button_5}", "click", function(sym, e) {
         // Mostrar un elemento 
         sym.$("pop_E").show();
         
         // Reproducir la línea de tiempo en un momento o etiqueta específicos. Por ejemplo:
         // sym.play(500); o sym.play("myLabel");
         sym.getSymbol("pop_E").play(1);
         
         
         sym.$("descripcion").hide();
         sym.$("Button_1").hide();
         sym.$("Button_2").hide();
         sym.$("Button_3").hide();
         sym.$("Button_4").hide();
         sym.$("Button_5").hide();
         
         
         sym.$("bt_ayuda").hide();
         sym.$("bt_validar").hide();
         sym.$("bt_solucion").hide();
         sym.$("bt_reiniciar").hide();
         
         
         // Ocultar un elemento 
         sym.$("Drag_1").hide();
         sym.$("Drag_2").hide();
         sym.$("Drag_3").hide();
         sym.$("Drag_4").hide();
         sym.$("Drag_5").hide();
         
         
         // Ocultar un elemento 
         sym.$("btn_noticia").hide();
         
         
         
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'pop_1'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$("Text").css("overflow-y","scroll");
         sym.$("Text").css("overflow-x","hidden");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse(250);
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();
         

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

   })("pop_1");
   //Edge symbol end:'pop_1'

   //=========================================================
   
   //Edge symbol: 'bt_cerrar'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_hot_spot_1}", "click", function(sym, e) {
         sym.stop("down");
         
         // Mostrar un elemento 
         sym.getComposition().getStage().getSymbol("slide_2").getSymbol("contenido2").$("pop_info").show();
         sym.getComposition().getStage().getSymbol("slide_2").getSymbol("contenido2").getSymbol("pop_info").play("inicio");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hot_spot_2}", "click", function(sym, e) {
         sym.stop("up");
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_cerrar");
   //Edge symbol end:'bt_cerrar'

   //=========================================================
   
   //Edge symbol: 'pop_A'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse();
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();

      });
      //Edge binding end

   })("pop_A");
   //Edge symbol end:'pop_A'

   //=========================================================
   
   //Edge symbol: 'pop_A_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse();
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();

      });
      //Edge binding end

   })("pop_B");
   //Edge symbol end:'pop_B'

   //=========================================================
   
   //Edge symbol: 'pop_B_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse();
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();

      });
      //Edge binding end

   })("pop_C");
   //Edge symbol end:'pop_C'

   //=========================================================
   
   //Edge symbol: 'pop_C_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse();
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();

      });
      //Edge binding end

   })("pop_D");
   //Edge symbol end:'pop_D'

   //=========================================================
   
   //Edge symbol: 'pop_D_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();
         // Ocultar un elemento 
         sym.getSymbolElement().hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_bt_cerrar}", "click", function(sym, e) {
         sym.playReverse();
         sym.getComposition().getStage().$("Hotspot_1").show();
         sym.getComposition().getStage().$("bt_reiniciar").show();
         sym.getComposition().getStage().$("bt_solucion").show();
         sym.getComposition().getStage().$("bt_validar").show();
         sym.getComposition().getStage().$("bt_ayuda").show();
         sym.getComposition().getStage().$("descripcion").show();
         sym.getComposition().getStage().$("Button_1").show();
         sym.getComposition().getStage().$("Button_2").show();
         sym.getComposition().getStage().$("Button_3").show();
         sym.getComposition().getStage().$("Button_4").show();
         sym.getComposition().getStage().$("Button_5").show();
         
         sym.getComposition().getStage().$("Drag_1").show();
         sym.getComposition().getStage().$("Drag_2").show();
         sym.getComposition().getStage().$("Drag_3").show();
         sym.getComposition().getStage().$("Drag_4").show();
         sym.getComposition().getStage().$("Drag_5").show();
         
         
         // Mostrar un elemento 
         sym.getComposition().getStage().$("btn_noticia").show();

      });
      //Edge binding end

   })("pop_E");
   //Edge symbol end:'pop_E'

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         sym.stop("down");
         
         // Mostrar un elemento 
         sym.getComposition().getStage().getSymbol("pop_1").$("copyright_dialogo").show();
         
         

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot2}", "click", function(sym, e) {
         sym.stop("up");
         sym.getComposition().getStage().getSymbol("pop_1").$("copyright_dialogo").hide();

      });
      //Edge binding end

   })("bt_copyright");
   //Edge symbol end:'bt_copyright'

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'copy_dialogo'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_HotSpot}", "click", function(sym, e) {
         sym.getSymbolElement().hide();
         sym.getComposition().getStage().getSymbol("pop_1").getSymbol("bt_copyright").stop("up");
         

      });
      //Edge binding end

   })("copyright_dialogo");
   //Edge symbol end:'copyright_dialogo'

})(jQuery, AdobeEdge, "EDGE-1010687330");