function init(){
    imgPopUp();
    magicAnimate(1);
    initDragDrop('.drag','.drop');
}

function setMsgClick( msg ){
    msg =  typeof(msg) != 'undefined' ? msg:'para ver la información';
    var htmlMsg =  'Haz <span class="icon click">clic</span> '+msg;
    $(".ggd_text_exp").html( htmlMsg);
}

function setMsgActividad(msgActividad){
    $(".ggd_text_act").html( msgActividad);
}


// Show an element with visibility:hidden after locks are removed
// Locks are stored in tag example:
// <button id="bt1" class="azul sg-hidden"  locklink1 locklink2 sg-click="sg.sound('success-low');">Ejercicios</button>
function controlHiddenButton1(LockToRemove){
    var lockBt1 =  ['lock2', 'lock3'];
    var button = $('#bt1');
    var activeLocks = 0;
    var lockId =  button.attr(LockToRemove);

    if (typeof lockId !== typeof undefined && lockId !== false) {
        button.removeAttr(LockToRemove);
    }

    for(var i=0; i< lockBt1.length; i++ ){
        var lockActive =  button.attr(lockBt1[i]);
        if(typeof lockActive !== typeof undefined && lockActive !== false){
            activeLocks++;
        }
    }

    if(!activeLocks){ // No more locks so...Show element
        button.css('visibility','visible');
    }
}

// Requires  Animate.css
// Author Carlos U
// <tag1 magicGroup="x" ... <tag2 magicGroup="1" magicEffect="zoomInUp"
function magicAnimate(groupSequence){
    var DEFAULT_EFFECT = 'zoomInUp';

    groupSequence  = (typeof groupSequence === "undefined") ? 1 : groupSequence;
    elements = $('[magicGroup="' + groupSequence + '"]');

    elements.each(function(i){
        attrEffect = $(this).attr('magicEffect');
        effect = (typeof attrEffect === "undefined" || attrEffect === '') ? DEFAULT_EFFECT : attrEffect;
        $(this).addClass('animated '+ effect);
        $(this).css('visibility','visible');
    });
}


//  Requires :
//  PopUp and Button PopUp  with id = 100
//  big custom attr on img 
//  apa custom attr on img -> optional 
//  _big   suffix on file image
function imgPopUp(){
    var images = $('img[big]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;
    var divLupa = $('<div class="bgLupa"></div>');

     images.each(function(index){

         var idImg = $(this).prop('id');
         var apa = $(this).attr('apa');
         var containerClass = $(this).attr('containerClass');

         if(typeof idImg  === typeof undefined || idImg == false) {
             idImg='';
         }

         if(typeof apa  === typeof undefined || apa == false) {
             apa=null;
         }
         else{
             MAX_HEIGHT_IMG-= 50;  // reserve 50px for display Apa CC at end of popup
         }

         if(typeof containerClass  === typeof undefined || containerClass == false) {
             containerClass='';
         }

         // Create a imagen container with classes 
         var imgContainer =  $('<div id="contImg'+idImg+'" class="decoImg '+containerClass+'" >');
         var nlupa = divLupa.clone(); // same div for all images 
         imgContainer.after($('</div>'));

         var width = this.width;
         var height = this.height;
         imgContainer.css({'height': height,  'width': width});

         $(this).before(imgContainer);   // Pos container before imagen 
         $(this).appendTo(imgContainer); // Move image in the container 
         nlupa.appendTo(imgContainer);   // Adds Lupa

         var imgOriginal = $(this);

         imgContainer.on('click', function(){
             var content=popUp.find('#imgContainer');
             content.html(''); //Clear any prev content
             var src = $(imgOriginal).attr('src');
             var baseName =  src.substr(0, src.lastIndexOf('.')) || input;
             var fileExt = src.split('.').pop();
             var big = baseName+"_big."+fileExt;
             var popUpImgContainer = $('<img id="imgContainer">'); 
             var heightApa = 0;

             popUpImgContainer.attr("src",big).load(function(){

                 var width = this.width; 
                 var height = this.height;

                 if(width > MAX_WIDTH_IMG){
                     ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                     $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                     $(this).css("height", height * ratio);   // Scale height based on ratio
                     height = height * ratio;                 // Reset height to match scaled image
                     width = width * ratio;                   // Reset width to match scaled image
                 }

                 // Check if current height is larger than max
                 if(height > MAX_HEIGHT_IMG){
                     ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                     $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                     $(this).css("width", width * ratio);    // Scale width based on ratio
                     width = width * ratio;    // Reset width to match scaled image
                 }

                 $(this).css({'display': 'block' , 'margin': 'auto'});

                 popUpImgContainer.appendTo(content);  // ADDS the magic!! 

                 if ( apa != null ){  // Has apa 
                     var  parrafoApa = $('<div class="ccImgPopUp">'+ apa +'</div> ');
                     parrafoApa.appendTo(content);
                 }

                 btPopUp.trigger('click'); // Activate pop up 

             }); // End Load

         });
     });
} // Fin Img Pop Up Carlos U
