

function init(){
    imgPopUp();
    cascade(1);
    initValidarRadios(1);
    initValidarRadios(2);
    initValidarRadios(3);
    initValidarRadios(4);

    initHighLightClickable('.btGroup1');
}

function initHighLightClickable(groupSelector){
    $(groupSelector).click(function(){
        console.log('ok');
        $(groupSelector).removeClass('selected');
        $(this).addClass('selected');
    });
}

//<p ="img1" groupelement="1" ..... />    ->   showElement('img1')
function showElement(idElement){
    var element = $('#'+idElement);
    var groupId = $(element).attr('groupelement');
    var groupElements =  $('[groupelement='+groupId+']');

    groupElements.css('display','none');
    element.toggle('clip');
}

// Validate a radio group
// Requiere style for bgAcierto, bgError and Resultado html tag
function initValidarRadios( groupName ){
    allRadios = $(':radio[name='+groupName+']');
    //console.log(allRadios);
    allRadios.each(function(){
        $(this).change(function(){
            var keyValue= $(this).attr('keyvalue'); // Id of pair elements radio - resultado
            var resultado = $('.resultado[radioname='+groupName+'][keyvalue='+keyValue+']');

            $('.resultado[radioname='+groupName+']').removeClass('bgError'); //Reset previous errors

            if($(this).val() == "1"){
                sg.sound('success-low');
                group = $(':radio[name='+$(this).attr("name")+']');
                group.prop('disabled',true);

                resultado.addClass('bgAcierto');
                resultado.removeClass('bgError');
                $(this).prop('disabled','true');
                switch (keyValue) {
                    case '1':
                        var bt = $('#btNarrador').removeAttr('disabled');
                        bt.removeClass('opacityHalf');
                        bt.removeAttr('disabled');
                        break;
                    case '7':
                        var bt = $('#btTiempo').removeAttr('disabled');
                        bt.removeClass('opacityHalf');
                        bt.removeAttr('disabled');
                        break;
                    case '9':
                        var bt = $('#btAccion').removeAttr('disabled');
                        bt.removeClass('opacityHalf');
                        bt.removeAttr('disabled');
                        break;
                    default:
                }

            }
            else{
                sg.sound('error');
                resultado.addClass('bgError');
                resultado.removeClass('bgAcierto');
            }
        });

    });
}
// Requires position absolute
// Uses  cascadeToggle  attribute to activate childs
// Requires Cascade  to group elements 
// <img id="grap1Part1" cascade="1" parent="0" cascadeToggle="1" class="" src="img/grapSeq1P1.png" alt=""/> 
function cascade(cascadeGroup){
   var elements = $('[cascade='+cascadeGroup+']');
   var firstGroup = $('[cascade='+cascadeGroup+'][parent=0]');
   var restGroup = $('[cascade='+cascadeGroup+'][parent!=0]');
   var toggleElements = $('[cascade='+cascadeGroup+'][cascadeToggle]');

    restGroup.hide(); // Leave only initial show elements  (parent =0)

    toggleElements.each(function(){
        $(this).on('click', function(){
            var keyToggle = $(this).attr('cascadeToggle');
            var childs = $('[cascade='+cascadeGroup+'][parent='+keyToggle+']');
            childs.toggle("fold");
            $(this).unbind('click');
            sg.sound('success-low');
        });

    });
}

// Show an element with visibility:hidden after locks are removed
// Locks are stored in tag example:
// <button id="bt1" class="azul sg-hidden"  locklink1 locklink2 sg-click="sg.sound('success-low');">Ejercicios</button>
function controlHiddenButton1(idLockToRemove){
    var lockBt1 =  ['locklink1', 'locklink2', 'locklink3'];
    var button = $('#bt1');
    var activeLocks = 0;
    var lockId =  button.attr('lock'+idLockToRemove);

    if (typeof lockId !== typeof undefined && lockId !== false) {
        button.removeAttr('lock'+idLockToRemove);
    }

    for(var i=0; i< lockBt1.length; i++ ){
        var lockActive =  button.attr(lockBt1[i]);
        if(typeof lockActive !== typeof undefined && lockActive !== false){
            activeLocks++;
        }
    }

    if(!activeLocks){ // No more locks so...Show element
        button.css('visibility','visible');
    }
}

//  Requires :
//  PopUp and Button PopUp  with id = 100
//  big custom attr on img 
//  _big   suffix on file image
function imgPopUp(){
    images = $('img[big]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var MAX_HEIGHT_POPUP = 765;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;


     images.each(function(){


         $(this).on('click', function(){
             var content=popUp.find('#imgContainer');
             content.html(''); //Clear any prev content
             var src = $(this).attr('src');
             var baseName =  src.substr(0, src.lastIndexOf('.')) || input;
             var fileExt = src.split('.').pop();
             var big = baseName+"_big."+fileExt;
             var imgContainer = $('<img id="imgContainer">'); 

             imgContainer.attr("src",big).load(function(){

                var width = this.width;
                var height = this.height;

                if(width > MAX_WIDTH_IMG){
                    ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                    $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                    $(this).css("height", height * ratio);   // Scale height based on ratio
                    height = height * ratio;                 // Reset height to match scaled image
                    width = width * ratio;                   // Reset width to match scaled image
                }

                // Check if current height is larger than max
                if(height > MAX_HEIGHT_IMG){
                    ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                    $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                    $(this).css("width", width * ratio);    // Scale width based on ratio
                    width = width * ratio;    // Reset width to match scaled image
                }

                $(this).css({'display': 'block' , 'margin': 'auto'});

             imgContainer.appendTo(content);  // ADDS the magic!! 
             btPopUp.trigger('click'); // Activate pop up 

             }); // End Load

         });
     });
} // Fin Img Pop Up Carlos U
