
function soundContent(daClass, stopClass){
    $("."+daClass).each(function(k){

    $button_play = $("<span></span>")
        .addClass("play btn-player playControl");
    
    $audio = $("<audio controls='false'></audio>")
        .addClass("audioElement");

    $audio.appendTo($(this));
    $button_play.appendTo($(this));
 /*si se llama el stop*/
 if ($(this).data("stop")!=undefined || $(this).data("controls")!=undefined) {
     $button_stop = $("<span></span>")
        .addClass("stop btn-player closeControl");
    $button_stop.appendTo($(this));
};
  /*si se llama el controlador del tiempo*/
    if ($(this).data("timecontrol")!=undefined || $(this).data("controls")!=undefined) {
         $contSlider_1 = $("<div></div>")
            .addClass("contSlider");

        $range_seek = $("<input type='range'/>")
            .addClass("seekControl")
            .prop("value","0");

        $range_seek.appendTo($contSlider_1);
        $contSlider_1.appendTo($(this));
    };

     /*si se llama el contador de tiempo*/
    if ($(this).data("time")!=undefined || $(this).data("controls")!=undefined) {
    $timmer = $("<span></span>")
        .addClass("timmer")
        .html("0:00");
    $timmer.appendTo($(this));
    };

    /*si se llama el control de volumen*/
   
    if ($(this).data("vol")!=undefined || $(this).data("controls")!=undefined) {

    $button_mute = $("<span></span>")
    .addClass("mute btn-player muteControl");

    $contSlider_2 = $("<div></div>")
    .addClass("contSlider");

    $range_vol = $("<input type='range'/>")
    .addClass("volControl")
    .prop("value","1")
    .prop("min","0")
    .prop("max","1")
    .prop("step","0.01");

    $range_vol.appendTo($contSlider_2);
    $button_mute.appendTo($(this));
    $contSlider_2.appendTo($(this));
    };
  
    

    var musicSource = $(this).data("src");
    var id = $(this).prop("id");
    startSoundContent(id, musicSource, daClass, stopClass);
});
};


function startSoundContent(id, src, daClass, stopClass ){

    var play = $('#'+id+' .playControl');
    var close = $('#'+id+' .closeControl');
    var song = $('#'+id+' .audioElement').get(0);
    //var song = new Audio();
   
    //song.type= 'audio/mpeg';
    song.src= src;
   

    play.click(function(e) {       
        var actual = $(this);
        $(".audioElement").each(function(index,elem){
            elem.pause();
            //elem.currentTime = 0;
           
         $('.'+daClass+' .playControl').not(actual).each(function(ind, elm){
            $(this).removeClass("pause").addClass("play");   
         });        

        });

        if ($('#'+id).data("stop")!=undefined || $('#'+id).data("controls")!=undefined) {
            console.log("Pause: "+$(this).hasClass("pause")+" - Play: "+$(this).hasClass("play"));
            if ($(this).hasClass("pause")) {
                //if ($('#'+id+' .timmer').html()=="0:00") {
                 if (song.currentTime==0) {
                    song.play();
                }else{                       
                    song.pause();              
                    $(this).removeClass("pause");
                    $(this).addClass("play");
                };         
            }else{      
                $(this).removeClass("play");
                $(this).addClass("pause");
                song.play(); 
            };
        }else{

            if ($(this).hasClass("play")) {
                $(this).removeClass("play");
                $(this).addClass("pause");
                song.play();           
            }else{
                song.pause();
                song.currentTime = 0;
                $(this).removeClass("pause");
                $(this).addClass("play");
            }
        };

        
        $('#'+id+' .seekControl').prop('min',0);
        $('#'+id+' .seekControl').prop('max',song.duration);

        e.preventDefault();


    });

    $('#'+id+' .closeControl').click(function(e) {
        e.preventDefault();
        song.pause();
        song.currentTime = 0;
        $('#'+id+' .playControl').removeClass("pause");
        $('#'+id+' .playControl').addClass("play");
    });

    $('#'+id+' .muteControl').click(function(e) {
        e.preventDefault();
        if ($(this).hasClass("mute")) {
            $('#'+id+' .volControl').prop("value",0);
            song.volume = 0;
            $(this).removeClass("mute");
            $(this).addClass("muted");
            console.log("muted");           
        }else{
            $(this).removeClass("muted");
            $(this).addClass("mute");           
            song.volume = 0.5;
            $('#'+id+' .volControl').prop("value",0.5);
            console.log("un-muted");
        };
    });

    $('#'+id+' .seekControl').bind("change", function() {
        song.currentTime = $(this).val();

        $('#'+id+' .seekControl').prop("max", song.duration);

    });

    $('#'+id+' .volControl').bind("change", function() {
        song.volume = $(this).val();
        if (song.volume==0) {
            if ($('#'+id+' .muteControl').hasClass("mute")) {
                $('#'+id+' .muteControl').removeClass("mute");
                $('#'+id+' .muteControl').addClass("muted");
                console.log("muted");   
            };  
        }
        else
        {
            if ($('#'+id+' .muteControl').hasClass("muted")) {
                $('#'+id+' .muteControl').removeClass("muted");
                $('#'+id+' .muteControl').addClass("mute");
                console.log("un-muted");    
            };
        };
    });

    song.addEventListener('timeupdate',function (){
        var curtime = parseInt(song.currentTime, 10);
        $('#'+id+' .seekControl').prop("value", curtime);
        $('#'+id+' .timmer').html(segToMin(curtime));
        if (song.duration==song.currentTime) {          
            song.pause();
            song.currentTime = 0;
             $('#'+id+' .playControl').removeClass("pause");
            $('#'+id+' .playControl').addClass("play");   

        };
    });

   

    $("."+stopClass).click(function(){
        song.pause();
        $('.playControl').removeClass("pause");
        $('.playControl').addClass("play");
        song.currentTime = 0; 
    });

   
};

 function segToMin(seg){
        var date = new Date(seg * 1000);
        var hh = date.getUTCHours();
        var mm = date.getUTCMinutes();
        var ss = date.getSeconds();
        if (hh < 10) {hh = "0"+hh;}
        if (mm < 10) {mm = "0"+mm;}
        if (ss < 10) {ss = "0"+ss;}
        var t = hh>0 ? hh+":"+mm+":"+ss : +mm+":"+ss;
        return t;
    };