function init(){
    divImgPopUp();
    initConnectLines()
}

var  startPoint = null;

function createLine(x1,y1, x2,y2){
  var length = Math.sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
  var angle  = Math.atan2(y2 - y1, x2 - x1) * 180 / Math.PI;
  var transform = 'rotate('+angle+'deg)';
    var line = $('<div> <div class="endline">')
        .addClass('line')
        .css({
          'position': 'absolute',
          'transform': transform
        })
        .width(length)
        .offset({left: x1, top: y1 + 25 });

        line.appendTo('#contenedorLineas');

        return line;
}


function initConnectLines(){

    var starts = $('div[startpoint]');
    var ends =  $('div[endpoint]');

    starts.css('cursor','pointer');
    ends.css('cursor','pointer');

    starts.each(function (){
        $(this).click(function() {
            starts.removeClass('selected');
            $(this).addClass('selected');
            startPoint = $(this).prop('id');
        });

    });

    ends.click(function(){
        var id = $(this).prop('id');

        if(startPoint == null){
           // console.log('Not start defined');
        }
        else{
            var actualStart = $('#'+startPoint);
            var validEndings = actualStart.attr('dest');
            if(validEndings != '' &&  typeof validEndings != 'undefined')
            {
                validEndings =  validEndings.split(" ");

                if(validEndings.indexOf(id) != -1){

                    var  positionStart = actualStart.position();
                    var  positionEnd = $(this).position();

                    createLine( Math.ceil( (positionStart.left  / sg.scaleX) + actualStart.outerWidth()),
                            Math.ceil( positionStart.top / sg.scaleY),
                            Math.ceil( positionEnd.left / sg.scaleX),
                            Math.ceil( positionEnd.top / sg.scaleY ));

                    starts.removeClass('selected'); // reset all starts

                    actualStart.addClass('inactive');
                    actualStart.unbind("click");
                    actualStart.css('cursor','default');

                    $(this).addClass('inactive');
                    $(this).unbind("click");
                    $(this).css('cursor','default');
                }
                else  // Invalid ending
                {
                    starts.removeClass('selected');
                }
            }
            else {  // has no match attr 

                starts.removeClass('selected');
            } 

        } // end else  start its defined 

        startPoint = null;  //  Clear start 
    });
}


//  Requires:
//  Suffix _big for the popup img  and   PopUp and Button PopUp  with id = 100
//  <div data-img-zoom  data-src="img/image.png"> <div class="stack"> Apa </div> </div>
//  class="no-style" for no decoration  and  for no pop-up use attribute:  data-no-zoom
function divImgPopUp(){
    var divImages = $('div[data-img-zoom]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;

     divImages.each(function(index){

         var divApa = $(this).find('div.stack');
         var imgSrc = $(this).attr("data-src");
         var attrZoom = $(this).attr("data-no-zoom");
         var attrLock = $(this).attr("data-no-lock");

         // Create an image in the container 

         var myImg = $("<img src='" + imgSrc + "' />").appendTo($(this));

         // Lock images 

         if( typeof divApa  !== typeof undefined && divApa !== false) {
             var heightStack = divApa.outerHeight();
             divApa.css({'position': 'absolute', 'height': heightStack,  'bottom': -heightStack })
         }

         if( typeof attrLock  == typeof undefined ) { // Lock images for default
             $(myImg).on('mousedown', function(){return false});
         }

         //End Create Img

         if( typeof attrZoom  === typeof undefined ){ 
             // POP UP 
             var myZoom = $("<div class='zoomImg'></div>").appendTo($(this));
             myZoom.on('click', function(){
                 var content=popUp.find('#imgContainer');
                 content.html(''); //Clear any prev content
                 var baseName =  imgSrc.substr(0, imgSrc.lastIndexOf('.')) || input;
                 var fileExt = imgSrc.split('.').pop();
                 var big = baseName+"_big."+fileExt;
                 var popUpImgContainer = $('<img id="imgContainer">'); 
                 var heightApa = 0;

                 popUpImgContainer.attr("src",big).load(function(){

                     var width = this.width; 
                     var height = this.height;


                     // Lock Img big 
                     $(this).on('mousedown', function(){return false});

                     if(width > MAX_WIDTH_IMG){
                         ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                         $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                         $(this).css("height", height * ratio);   // Scale height based on ratio
                         height = height * ratio;                 // Reset height to match scaled image
                         width = width * ratio;                   // Reset width to match scaled image
                     }

                     // Check if current height is larger than max
                     if(height > MAX_HEIGHT_IMG){
                         ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                         $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                         $(this).css("width", width * ratio);    // Scale width based on ratio
                         width = width * ratio;    // Reset width to match scaled image
                     }

                     $(this).css({'display': 'block' , 'margin': 'auto'});

                     popUpImgContainer.appendTo(content);  // ADDS the magic!! 

                     btPopUp.trigger('click'); // Activate pop up 

                 }); // End Load
             });
         }
     });
} // Fin Img Pop Up 
