function init () {
    divImgPopUp();
    initBtnGroup();

    require(["jquery-selectric"], function(){
        $('.select').selectric();
    });
}


function validate (n) {
    var cap = $('.s'+n).val();

    if (cap != "Escoje una opción"){
        if(cap == 1){
            $('#ok').trigger('click');
        }
        else{
            $('#erro').trigger('click');
        }

    }

    console.log(cap);
}

//  Requires:
//  Suffix _big for the popup img  and   PopUp and Button PopUp  with id = 100
//  <div data-img-zoom  data-src="img/image.png"> <div class="stack"> Apa </div> </div>
//  class="no-style" for no decoration  and  for no pop-up use attribute:  data-no-zoom, 
//  use attribute  data-no-lock for disable lock images  (useful in drag and drop)  
function divImgPopUp(){
    var divImages = $('div[data-img-zoom]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;

     divImages.each(function(index){

         var divApa = $(this).find('div.stack');
         var imgSrc = $(this).attr("data-src");
         var attrZoom = $(this).attr("data-no-zoom");
         var attrLock = $(this).attr("data-no-lock");

         // Create an image in the container 

         var myImg = $("<img src='" + imgSrc + "' />").appendTo($(this));

         // Lock images 

         if( typeof divApa  !== typeof undefined && divApa !== false) {
             var heightStack = divApa.outerHeight();
             divApa.css({'position': 'absolute', 'height': heightStack,  'bottom': -heightStack })
         }

         if( typeof attrLock  == typeof undefined ) { // Lock images for default
             $(myImg).on('mousedown', function(){return false});
         }

         //End Create Img

         if( typeof attrZoom  === typeof undefined ){ 
             // POP UP 
             var myZoom = $("<div class='zoomImg'></div>").appendTo($(this));
             myZoom.on('click', function(){
                 var content=popUp.find('#imgContainer');
                 content.html(''); //Clear any prev content
                 var baseName =  imgSrc.substr(0, imgSrc.lastIndexOf('.')) || input;
                 var fileExt = imgSrc.split('.').pop();
                 var big = baseName+"_big."+fileExt;
                 var popUpImgContainer = $('<img id="imgContainer">'); 
                 var heightApa = 0;

                 popUpImgContainer.attr("src",big).load(function(){

                     var width = this.width; 
                     var height = this.height;


                     // Lock Img big 
                     $(this).on('mousedown', function(){return false});

                     if(width > MAX_WIDTH_IMG){
                         ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                         $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                         $(this).css("height", height * ratio);   // Scale height based on ratio
                         height = height * ratio;                 // Reset height to match scaled image
                         width = width * ratio;                   // Reset width to match scaled image
                     }

                     // Check if current height is larger than max
                     if(height > MAX_HEIGHT_IMG){
                         ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                         $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                         $(this).css("width", width * ratio);    // Scale width based on ratio
                         width = width * ratio;    // Reset width to match scaled image
                     }

                     $(this).css({'display': 'block' , 'margin': 'auto'});

                     popUpImgContainer.appendTo(content);  // ADDS the magic!! 

                     btPopUp.trigger('click'); // Activate pop up 

                 }); // End Load

             });
         }
     });
} // Fin Img Pop Up 

function initBtnGroup(){
    var btn = $('[btn-group]');
    $("[class*='cont-h']").css("display","none");
    $.each(btn,function(){
        $(this).click(function(){
            var idBtnClick = $(this).attr('btn-id');
            $(this).addClass("selected");
            $('.cont-h'+ $(this).attr('btn-id')).effect('slide').css('display','block');sg.sound('success-low');
            var btnGrupo = $('[btn-group ='+$(this).attr('btn-group')+']');
            btnGrupo.each(function() {
                var idBtn = $(this).attr('btn-id');
                if(idBtn!=idBtnClick){
                    $('.cont-h'+idBtn).css("display","none");
                    $(this).removeClass("selected");
                }                       
            });
        });
    });
}

function disparador (n){

    $("[data-sg-key='"+n+"']").trigger('click');
}

function Validar()
{
    var valor;
    var calificador = 0;

    for (var i = 1; i < 10; i++)
    {   
        valor = $('.s'+i).val();
        

        if (valor == 1)
        {
            calificador++;
        }
    }

    console.log(calificador);

    if (calificador == 9) 
    {
        $('#ok').trigger('click');
    }
    else{
         $('#wrong').trigger('click');
    }
}