function init () {
    divImgPopUp();
    initBtnGroup();
    initDragDrop('.drag', '.drop');

       
}

function mostrar () {
    $('.palabras').css('left', '0');

}

function dragF(event, ui){

    // Apply  SG transform scale !!!!!!!
    var offset = ui.position;
    var xPos = offset.left/sg.scaleX;
    var yPos = offset.top/sg.scaleY ;
    ui.position = { 'top': yPos, 'left': xPos};

}

function acceptF(ui){
    var dropKey = $(this).attr('ddKey');
    var dragKey =ui.attr('ddKey');

    if( dropKey == dragKey )
    {
        return true;
    }

    return false;
}

function dropF(event, ui){
    var CUSTOM_CLONE = true; // bool
    var dropKey = $(this).attr('ddkey');
    var dragKey= $(ui.draggable).attr('ddkey');

    if(dragKey == dropKey) {

        ui.draggable.addClass( 'dropped' );      // Css  
        ui.draggable.data('dropkey',dropKey); // Associate the container
        //$(this).droppable('disable');                       // Disable the drop
        ui.draggable.draggable('option', 'disabled', true); // Disable the drag
        ui.draggable.css({'cursor':'default', 'color': 'gray'});  //Reset mouse cursor

        if(CUSTOM_CLONE){
            var clone = $(ui.draggable).clone();
            $(clone).addClass('cloned');
            $(clone).css({'position': 'relative', 'color' : '#fff'});
            $(this).append(clone);
            //snapToMiddle($(clone), $(this));
            ui.draggable.find('img').addClass('grayFilterEnabled');
        }else{
            $(this).append(ui.draggable.css('position','relative'));
            //snapToMiddle($(ui.draggable), $(this));
        }


        sg.sound('success-low');
    }
    else
    { 
        sg.sound('error');
    }
}

function initDragDrop(selectorDrag, selectorDrop) {
    console.log('Init');

    $(selectorDrag).draggable({
        //refreshPositions: true,
        drag: dragF,
        helper: 'clone',
        revertDuration: 400,

        containment: '#contenido',

        // snap: ".drop",   //Adhiere a borde de drop
        snapMode: "fit",
    });

    // Mouse drag cursor
    $(selectorDrag).css('cursor','pointer');

    $(selectorDrop).droppable({
        drop: dropF,
        //accept: acceptF,
        activeClass: 'boxshadow' // BOX SHADOW  CSS STYLE NEEDED 
    });

    // Keeep original drags position for reset
    preserveDragsPosition(selectorDrag);

}

// Funciones de apoyo 

function snapToMiddle(dragObj, target){

    var INCLUDE_MARGIN  = false;  // Include or ignore margin to calculate center 

    var topMove = (target.outerHeight(  INCLUDE_MARGIN  ) - dragObj.outerHeight(  INCLUDE_MARGIN  )) / 2;
    var leftMove= (target.outerWidth(  INCLUDE_MARGIN  ) - dragObj.outerWidth( INCLUDE_MARGIN )) / 2;

    dragObj.animate({top:topMove,left:leftMove},{duration:10,easing:'easeOutBack'});
}

function pause(idVideo){ 
    $('#'+idVideo).trigger('pause'); 
} 

//Preserve position to reset
function preserveDragsPosition(selectorDrag){

    var allDrags = $(selectorDrag);
    var offset;

    allDrags.each(function(){

        offset=$(this).position();

        $(this).data({
            'originalLeft': offset.left/sg.scaleX,
            'origionalTop': offset.top/sg.scaleY,
            'originalPosition': $(this).css('position'),
            'parentDiv': $(this).parent()

        });
    });

}

function resetDragDrop(selectorDrag, selectorDrop){

    var allDrags = $(selectorDrag).not('.cloned');
    var allDrops = $(selectorDrop);
    var dragClones = $(selectorDrag +'.cloned');

    dragClones.remove();

    // Restore postion of all drags needs same container TODO goback to previous parent -> DONE !!!!
    allDrags.each(function(){
        //$(this).appendTo($(this).data('parent')),
        $(this).appendTo($(this).data('parentDiv'));
        $(this).css({
            'left': $(this).data('originalLeft'),
            'top': $(this).data('origionalTop'),
            'position': $(this).data('originalPosition')
        });

        $(this).data('dropkey','');                     // Clear previuous data
        $(this).draggable('option', 'disabled', false); // Enable Drag
    });

    allDrops.droppable('enable');           // Enable drops
    allDrags.css('cursor','pointer');       // Restore Mouse cursor
    allDrags.find('img').removeClass('grayFilterEnabled');

}


//  Requires:
//  Suffix _big for the popup img  and   PopUp and Button PopUp  with id = 100
//  <div data-img-zoom  data-src="img/image.png"> <div class="stack"> Apa </div> </div>
//  class="no-style" for no decoration  and  for no pop-up use attribute:  data-no-zoom, 
//  use attribute  data-no-lock for disable lock images  (useful in drag and drop)  
function divImgPopUp(){
    var divImages = $('div[data-img-zoom]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;

     divImages.each(function(index){

         var divApa = $(this).find('div.stack');
         var imgSrc = $(this).attr("data-src");
         var attrZoom = $(this).attr("data-no-zoom");
         var attrLock = $(this).attr("data-no-lock");

         // Create an image in the container 

         var myImg = $("<img src='" + imgSrc + "' />").appendTo($(this));

         // Lock images 

         if( typeof divApa  !== typeof undefined && divApa !== false) {
             var heightStack = divApa.outerHeight();
             divApa.css({'position': 'absolute', 'height': heightStack,  'bottom': -heightStack })
         }

         if( typeof attrLock  == typeof undefined ) { // Lock images for default
             $(myImg).on('mousedown', function(){return false});
         }

         //End Create Img

         if( typeof attrZoom  === typeof undefined ){ 
             // POP UP 
             var myZoom = $("<div class='zoomImg'></div>").appendTo($(this));
             myZoom.on('click', function(){
                 var content=popUp.find('#imgContainer');
                 content.html(''); //Clear any prev content
                 var baseName =  imgSrc.substr(0, imgSrc.lastIndexOf('.')) || input;
                 var fileExt = imgSrc.split('.').pop();
                 var big = baseName+"_big."+fileExt;
                 var popUpImgContainer = $('<img id="imgContainer">'); 
                 var heightApa = 0;

                 popUpImgContainer.attr("src",big).load(function(){

                     var width = this.width; 
                     var height = this.height;


                     // Lock Img big 
                     $(this).on('mousedown', function(){return false});

                     if(width > MAX_WIDTH_IMG){
                         ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                         $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                         $(this).css("height", height * ratio);   // Scale height based on ratio
                         height = height * ratio;                 // Reset height to match scaled image
                         width = width * ratio;                   // Reset width to match scaled image
                     }

                     // Check if current height is larger than max
                     if(height > MAX_HEIGHT_IMG){
                         ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                         $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                         $(this).css("width", width * ratio);    // Scale width based on ratio
                         width = width * ratio;    // Reset width to match scaled image
                     }

                     $(this).css({'display': 'block' , 'margin': 'auto'});

                     popUpImgContainer.appendTo(content);  // ADDS the magic!! 

                     btPopUp.trigger('click'); // Activate pop up 

                 }); // End Load

             });
         }
     });
} // Fin Img Pop Up 

function initBtnGroup(){
    var btn = $('[btn-group]');
    $("[class*='cont-h']").css("display","none");
    $.each(btn,function(){
        console.log(this);
        $(this).click(function(){
            var idBtnClick = $(this).attr('btn-id');
            $(this).addClass("selected");
            $('.cont-h'+ $(this).attr('btn-id')).effect('slide').css('display','block');sg.sound('success-low');
            var btnGrupo = $('[btn-group ='+$(this).attr('btn-group')+']');
            btnGrupo.each(function() {
                var idBtn = $(this).attr('btn-id');
                if(idBtn!=idBtnClick){
                    $('.cont-h'+idBtn).css("display","none");
                    $(this).removeClass("selected");
                }                       
            });
        });
    });
}

function disparador (n){

    $("[data-sg-key='"+n+"']").trigger('click');
}

