'use strict';

/**
 *@author
 *A module representing the math between the custom param and the real css param
 *@Module sgStylesCss
 */
define(['jquery'], function($) {
	

	var app = {};

	app.init = function() {
		function ccp(className) {
			//끝에 붙은 숫자만 제거하면 key
			var key = className.replace(/-?[0-9]{0,4}%?$/, '');
			var value = className.replace(key, '');
			switch (key) {
				case "sg-font":
					return {
						"font-size": value + "pt"
					};
				case "sg-mg":
				case "sg-margin":
					return {
						"margin": value + "px"
					};
				case "sg-mgL":
				case "sg-marginL":
					return {
						"margin-left": value + "px"
					};
				case "sg-mgT":
				case "sg-marginT":
					return {
						"margin-top": value + "px"
					};
				case "sg-mgR":
				case "sg-marginR":
					return {
						"margin-right": value + "px"
					};
				case "sg-mgB":
				case "sg-marginB":
					return {
						"margin-bottom": value + "px"
					};
				case "sg-pd":
				case "sg-padding":
					return {
						"padding": value + "px"
					};
				case "sg-pdL":
				case "sg-paddingL":
					return {
						"padding-left": value + "px"
					};
				case "sg-pdT":
				case "sg-paddingT":
					return {
						"padding-top": value + "px"
					};
				case "sg-pdR":
				case "sg-paddingR":
					return {
						"padding-right": value + "px"
					};
				case "sg-pdB":
				case "sg-paddingB":
					return {
						"padding-bottom": value + "px"
					};

				case "sg-w":
				case "sg-width":
					return {
						"width": value + ((value.indexOf("%") > -1) ? "" : "px")
					};
				case "sg-h":
				case "sg-height":
					return {
						"height": value + ((value.indexOf("%") > -1) ? "" : "px")
					};
				case "sg-x":
					return {
						"left": value + ((value.indexOf("%") > -1) ? "" : "px")
					};
				case "sg-y":
					return {
						"top": value + ((value.indexOf("%") > -1) ? "" : "px")
					};

				case "sg-scaleX":
					return {
						"transform": "scale(" + (value / 100) + ")"
					};
				case "sg-scaleY":
					return {
						"transform": "scaleX(" + (value / 100) + ")"
					};
				case "sg-scale":
					return {
						"transform": "scale(" + (value / 100) + "," + (value / 100) + ")"
					};

				case "sg-offsetX":
					return {
						"margin-left": value + "px"
					};
				case "sg-offsetY":
					return {
						"margin-right": value + "px"
					};
				case "sg-r":
				case "sg-radius":
					return {
						"border-radius": value + "px"
					};
				case "sg-rLT":
				case "sg-radiusLT":
					return {
						"border-top-left-radius": value + "px"
					};
				case "sg-rLB":
				case "sg-radiusLB":
					return {
						"border-bottom-left-radius": value + "px"
					};
				case "sg-rRT":
				case "sg-radiusRT":
					return {
						"border-top-right-radius": value + "px"
					};
				case "sg-rRB":
				case "sg-radiusRB":
					return {
						"border-bottom-right-radius": value + "px"
					};
				case "sg-b":
				case "sg-bold":
					return value.length ? {
						"font-weight": value
					} : {
						"font-weight": "bold"
					};
				case "sg-alpha":
				case "sg-opacity":
					return {
						"opacity": value / 100
					};

				default:
					return null;
			}
		}

		$("[class]").each(function(i, e) {

			var $me = $(this),
				cns = this.className.split(' '),
				rcns = [],
				cn, cssObj;
			var cns = this.className.split(' ');
			var rcns = [];
			var cn;
			var cssObj;

			while (cns.length) {
				//왼쪽 class부터 실행
				cn = cns.shift();
				cssObj = ccp(cn);
				if (cssObj) {
					$me.css(cssObj);
				} else {
					rcns.push(cn);
				}
			}
			this.className = rcns.join(' ');
		});

	}

	return app;

});