var initList = initList || [];
initList.push(function() {

    var claps = new Audio();
    var soundUrl = "../../common/sounds/claps.mp3";
    claps.src = soundUrl;
    claps.setAttribute("data-relativeSrc", soundUrl);
    claps.load();
    claps.loop = true;
    claps.volume = 1;
    sg.audio = function() {
        claps.play();
    }
    sg.audioStop = function() {
        claps.pause();
    }

    $('.drags').find('.item').each(function(index, value) {
        var dropSelector = $(value).attr('data-sg-drop-selector');
        sg.setDraggable($(value), {
            revert: true,
            dropSelector: dropSelector,
            success: function() {

                var $this = $(this);
                // Visual effect
                var id = '#' + $this.attr('id');
                var orignial = $(id).not(".clones");
                orignial.removeClass('movement');
                $this.removeClass('movement');

                var drop = $this.data("hit").eq(0);

                $this.attr("data-sg-selected", ("#" + drop.attr("id")));
                $this.addClass('clones');
                drop.attr("id", (drop.attr("id") + "_fill"));

                var boton = $(".btnCheck");
                var attempts = parseInt(boton.attr("data-sg-count")) + 1;
                boton.attr("data-sg-count", attempts);
                if (attempts == 5) {
                    boton.bind("click", revisar);
                    boton.addClass("ready shake");
                    boton.css('cursor', 'pointer');
                }
                sg.sound('success');
            },
            start: function(){
                var $this = $(this);
                $this.addClass('movement');
            },
            fail: function() {
                var $this = $(this);
                $this.removeClass('movement');
            }
        });
    });


    function revisar() {
        var boton = $(".btnCheck");
        var num_corrects = 0;

        $('.clones').each(function() {
            $this = $(this);
            var correct = $this.attr("data-sg-correct").split(',');
            var selected = $this.attr("data-sg-selected");

            if (correct.indexOf(selected) != -1) {
                $this.addClass("correct");
                num_corrects++;
            } else {
                var elem_selected = $(selected + "_fill");
                var new_id = selected.replace(/_fill/g, '').replace(/#/g, '');
                elem_selected.text("").attr("id", new_id);

                var id_drag = "#" + $this.attr("id");
                $(id_drag).css("visibility", "visible");
                $this.css("display", "none").remove();
                var attempts = parseInt(boton.attr("data-sg-count")) - 1;
                boton.attr("data-sg-count", attempts).removeClass("ready shake").unbind("click", revisar);
                boton.css('cursor', 'default');
            }
        });

        if (num_corrects == 5) {
            boton.unbind("click", revisar);
            boton.css('cursor', 'default');
            boton.addClass('completed');
            sg.audio();
            $('.btn_popup_tab2').addClass('ready shake');
            $('.block_popup').remove();
        } else {
            sg.sound('error');
        }

    }

    sg.restart = function() {
        sg.resetDraggable($('.content').find("[data-sg-draggable]"));
        sg.audioStop();

        $(".clones").remove();
        $("span[id$='_fill']").each(function(index, value) {
            var $this = $(this);
            var attrId = $this.attr('id').replace(/_fill/g, '').replace(/#/g, '');
            $this.attr("id", attrId);
        });
        $('.btnCheck').attr('data-sg-count', 0).removeClass('completed').removeClass('ready shake');
    }

    var sections1 = $(".content_nav .time_line");
    var stage1 = 1;
    var width_sections1 = 1245;
    var time_factor1 = 1.5 * width_sections1;

    $(".content_nav .controls .btn").click(function() {
        if ($(this).hasClass('active')) return;
        var index = $(this).index();
        var variation = index * width_sections1 * -1;

        stage1 = index + 1;
        $(".content_nav > .controls > .btn").removeClass("active");
        sg.restart();
        sections1.animate({
            marginLeft: variation
        }, time_factor1, function() {
            $(".content_nav > .controls > span:nth-child(" + stage1 + ")").addClass("active");
        });

    });

});