'use strict';

/**
 @author
*A module representing the custom popup functions 
*@Module sgPopUp  
*/

define(['jquery', 'sgButtonsManager', 'sgSound'], function($, buttonsManager, sgSound) {


	var app = {};

	app.$currentPopup;
	var $popupBtns; //= $("[data-sg-id=btn-popup]"); //VAR A NIVEL LOCAL DEL MODULO
	var $popupBg;

	app.popupScaleStyle = function popupScaleStyle() {
		var ww = window.innerWidth;
		var wh = window.innerHeight;

		var hp = app.$currentPopup.height();
		var wp = app.$currentPopup.width();

		var msc = Math.min(ww / sg.sw, wh / sg.sh);

		if (msc > 0.95) msc = 1;

		app.$currentPopup.css({
			"transform": "scale(" + msc + ")",
			"transform-origin": "0 0"
		});


		app.$currentPopup.css({
			left: (ww - app.$currentPopup.width() * msc) / 2,
			top: (wh - app.$currentPopup.height() * msc) / 2,
			position: "fixed"
		})
	}


	
	function popupHandle() {
		var $me = $(this);
		var options = $me.data("options");
		if (options == undefined) return;
		if (!options.enabled) return;


		//var key = this.id.replace(/-?[0-9]{0,4}%?$/, '');
		//var id = this.id.replace(//, '');
		//console.log(this.id.match(/[0-9]{0,4}%?$/));
		//var idx = $me.attr("data-sg-id").match(/[0-9]{0,4}$/);//this.id.match(/[0-9]{0,4}$/);
		//var idx = this.dataset["sgKey"];
		var idx = this.getAttribute("data-sg-key");
		//팝업버튼 id 'popupBtn'에 번호가 안붙은 경우 popupItem에도 번호가 없다.
		var popupAttrID = "[data-sg-id=item-popup]" + (idx == undefined ? "" : "[data-sg-key=" + idx + "]");

		
		var $popupItem =  $(popupAttrID);
		


		if (!app.$currentPopup || app.$currentPopup[0] != this) {

			$body.append($popupBg);

			$popupItem.appendTo($body);
			app.$currentPopup = $popupItem;
			app.popupScaleStyle();
			$popupItem.show();

			sg_call($popupItem[0]);

			//음원속성이 있다면 재생
			sgSound.sg_sound($popupItem[0]);
		}

		//반복실행가능 여부
		if (options.loop == false) $me.unbind("click").css("cursor", "auto");

		//연동스크립트
		sg_call(this);

		//음원속성이 있다면 재생
		sgSound.sg_sound(this);
	}


	//This fuction was associated with window : window.setPopupBtn although using in this way didn't produce 
	//errors, was tested in the html page: Refactor/RecursoInicial/S/S_G04_U01_L01/S_G04_U01_L01_03_01.html 
	//without errors
	function setPopupBtn(elementOrSelector) {
		var $target = $(elementOrSelector);
		if ($target.length) {
			$target.each(function(i, e) {
				//var idx = $target.attr("data-sg-id").match(/[0-9]{0,4}%?$/);//this.id.match(/[0-9]{0,4}%?$/);
				//var idx = this.dataset["sgKey"];
				var idx = this.getAttribute("data-sg-key");
				var popupAttrID = "[data-sg-id=item-popup]" + (idx == undefined ? "" : "[data-sg-key=" + idx + "]");
				var $popupItem = $(popupAttrID);

				//팝업아이템에 음원속성이 있다면 프리로드
				sgSound.sg_sound($popupItem[0], false);
				$popupItem.hide().children("[data-sg-id=btn-popup-close]")
					.click(function() { //close btn
						//console.log($currentPopup);
						if (app.$currentPopup) {
							$popupBg.remove();
							app.$currentPopup.hide();
							app.$currentPopup = null;
						}
					});
			});

			$popupBg = $('<div></div>')
				.attr("data-sg-id", "popupBg")
			//.addClass
			.width("100%")
				.height("100%");

			$target
				.click(popupHandle)
				.each(function(i, e) {
					buttonsManager.btnInit(this);

				});
		}
	}

	app.popupOpen= function ($popupItem){
		$body.append($popupBg);

		$popupItem.appendTo($body);
		app.$currentPopup = $popupItem;
		app.popupScaleStyle();
		$popupItem.show();

		sg_call($popupItem[0]);


		$popupItem.children("[data-sg-id=btn-popup-close]")
					.click(function() { //close btn
						//console.log($currentPopup);
						if (app.$currentPopup) {
							$popupBg.remove();
							app.$currentPopup.hide();
							app.$currentPopup = null;
						}
					});

		//음원속성이 있다면 재생
		sgSound.sg_sound($popupItem[0]);
		app.popupScaleStyle();
	}

	app.init = function() {
		$popupBtns = $("[data-sg-id=btn-popup]"); //VAR A NIVEL LOCAL DEL MODULO
		setPopupBtn($popupBtns)
	}
	return app;
});