var initList = initList || [];
initList.push(function() {
	require(['jquery.countdown'], function(jqCount) {
		var soundUrl = '../../common/sounds/clock-ticking.mp3'
		audio = new Audio(); 
		audio.src = soundUrl;
		audio.setAttribute("data-relativeSrc", soundUrl);
		audio.loop = true;
		audio.load();

		sg.clock = function() {
			initTimer();
			audio.play();
			$('.item').unbind('click').css('cursor','default');
			$('.container-chronometer').show();
		}

		function initTimer() {
			chronometer.countdown360().stop();
			chronometer.countdown360().start();
		}

		function activeItems() {
			$('.item').bind('click',style);
			$('.item').bind('click',sg.clock).css('cursor','pointer');
		}

		function style() {
			var $me = $(this);
			$me.hide();
			$me.next().show();
			$me.next().next().show();
		}

		sg.pause = function(btn){
			var action = $(btn).hasClass('play');
			if(action){
				chronometer.countdown360().pause();
				audio.pause();
			}else{
				chronometer.countdown360().resume();
				audio.play();
			}
		}

		var chronometer = $('<div>').attr('id', 'chronometer');
		$('.container-chronometer').append(chronometer);

		chronometer.countdown360({
				radius: 60,
				seconds: 60,
				fontColor: '#000000',
				strokeStyle: '#00bdd6',
				fillStyle: '#f2f2f2',
				autostart: false,
				onComplete: function() {
					$('.container-chronometer').hide();
					$('.item_topic').next().hide();
					sg.sound('success');
					audio.pause();
					activeItems();
				}
			});
	});                
});