var initList = initList || [];

initList.push(function() {
	$(".content_nav").each(
		function() {
			var content = $(this);
			var flow = content.attr('data-flow');
			var buttons = content.find(".buttons");
			var sections = content.find(" .sections");
			var stage = 1;
			var num_sections = sections.children().length;
			var width_sections = 0;
			if (flow == 'h') {
				width_sections = sections.find('li').outerWidth(true);
			} else { /*v*/
				width_sections = sections.find('li').outerHeight(true);
			}
			var time_factor = 1.5 * width_sections;

			buttons.click(function() {
				content.find(" > .controls > span").removeClass("active");
				var variation;

				if ($(this).is(".last")) {
					variation = "+=";
					stage--;
				} else {
					variation = "-=";
					stage++;
				}

				if (content.parent().hasClass('tab4')) {
					if (stage == 8) {
						content.parent().parent().find('.act_subtitle.s1').hide();
						content.parent().parent().find('.act_subtitle.s2').show();
					} else {
						content.parent().parent().find('.act_subtitle.s2').hide();
						content.parent().parent().find('.act_subtitle.s1').show();
					}
				}

				if (stage >= 1 && stage <= num_sections) {
					var effect = '';
					if (flow == 'h') {
						effect = {
							marginLeft: variation + width_sections
						};
					} else {
						effect = {
							marginTop: variation + width_sections
						};
					}

					$(this).fadeOut(50,
						function() {
							if (!$(this).hasClass("last")) {
								buttons.last().fadeOut();
							} else {
								buttons.first().fadeOut();
							}
							sections.animate(effect, time_factor, function() {
								if (stage > 1) buttons.last().fadeIn();
								if (stage < num_sections) buttons.first().fadeIn();
								content.find(" .controls > span:nth-child(" + stage + ")").addClass("active");
							});
						});
				} else {
					if (stage > num_sections) {
						stage = num_sections
					}
					if (stage < 1) {
						stage = 1
					}
				}
			});

			content.find(".controls span").click(function() {
				var index = $(this).index();
				var margin = index * width_sections * -1;

				stage = index + 1;
				content.find(" .controls > span").removeClass("active");
				var effect = '';
				if (flow == 'h') {
					effect = {
						marginLeft: margin
					};
				} else {
					effect = {
						marginTop: margin
					};
				}
				buttons.fadeOut(50,
					function() {
								buttons.last().fadeOut();
								buttons.first().fadeOut();
						sections.animate(effect, time_factor, function() {
							if (stage > 1) buttons.last().fadeIn();
							if (stage < num_sections) buttons.first().fadeIn();
							content.find(" > .controls > span:nth-child(" + stage + ")").addClass("active");
						});
					});
			});

		}
	);
});