var initList= initList || [];
initList.push(function(){
	$('.stage2').hide();
	var questionItem = 1;
	var activeGroup = 0;
	$('.q_groups').hide();
	$('.group .btn-right').hide();
	var startButton = $('.startGame');
	var nextButton = $('.nextQuestion');
	var score = [0,0,0];

	//Sound
	var soundUrl = '../../common/sounds/clock-ticking.mp3'
		audio = new Audio(); 
		audio.src = soundUrl;
		audio.setAttribute("data-relativeSrc", soundUrl);
		audio.loop = true;
		audio.load();

	function next(){
		if(activeGroup == 3 && questionItem == 7){
			var group1 = score[0];
			var group2 = score[1];
			var group3 = score[2];
			var message = '';
			if(group1 == group2 && group2 == group3){
				message = 'Gran empate';
			}else if(group1 == group2 && group1 > group3){
				message = 'Grupo 1 y <br>Grupo 2';
			}else if(group1 == group3 && group1 > group2){
				message = 'Grupo 1 y <br>Grupo 3';
			}else if(group2 == group3 && group2 > group1){
				message = 'Grupo 2 y <br>Grupo 3';
			}else if(group1 > group3 && group1 > group2){
				message = 'Grupo 1';
			}else if(group2 > group3 && group2 > group1){
				message = 'Grupo 2';
			}else if(group3 > group1 && group3 > group2){
				message = 'Grupo 3';
			}
			$('.disable_layer').removeClass('group1').removeClass('group2').removeClass('group3');
			$('.item-winner').find('.winner_group').append(message);
			$('.btn-winner').click();
			sg.sound('claps');
			//SHOW WINNER
			return;
		}
		if(activeGroup==3){
			activeGroup = 1;
			questionItem++;
			$('.disable_layer').removeClass('group1').removeClass('group2').removeClass('group3');
			setTimeout(function(){ 
				// remove LAYER..
				$('.group .board_question').empty();
				$('.group .board_answer').empty();
				$('.group').removeClass('active');
				loadQuestion();
			},
			1000 
			//10000
			);
		}else{
			activeGroup++;
			loadQuestion();
		}
	}

	function loadQuestion(){
		var group = $('.group'+activeGroup);
		//LAYER...
		$('.disable_layer').removeClass('group1').removeClass('group2').removeClass('group3');
		$('.disable_layer').addClass('group'+activeGroup);
		group.addClass('active');
		var item = $('.q_groups.q_group'+activeGroup+' ul').children().eq(questionItem-1)
		var question = item.find('.question');
		var answer = item.find('.answer').hide();
		group.find('.board_question').empty().append(question);
		group.find('.board_answer').empty().append(answer);
		group.find('.btn-right').unbind('click').show().bind('click',clickRight);
		$('.container-chronometer').removeClass('group1').removeClass('group2').removeClass('group3');
		$('.container-chronometer').addClass('group'+activeGroup);
		sg.clock();
	}

	function clickRight(){
		sg.sound('success');
		$(this).hide();
		var group = $('.group'+activeGroup);
		group.find('.board_answer').find('.answer').fadeIn();
		group.find('.scoreboard').children().eq(questionItem-1).addClass('right');
		score[activeGroup-1]++;
		sg.stop();
		next();
	}

	startButton.click(function(){
		//Page changed
		$('.stage1').fadeOut(500,function(){
			$('.stage2').fadeIn(500);
		});
		//Start game
		next();
	});

	sg.showPoster = function(item) {

		layer.css({
			'position': 'absolute',
			'width': '1245px',
			'height': '665px',
			'top': '0px',
			'left': '0px'
		});
		$('classItem').addClass('down').before(layer);
	}

	require(['jquery.countdown'], function(jqCount) {
		sg.clock = function() {
			initTimer();
			audio.play();
			$('.container-chronometer').show();
		}

		sg.stop = function(){
			chronometer.countdown360().stop();
			$('.container-chronometer').hide();
			audio.pause();
		}

		function initTimer() {
			chronometer.countdown360().stop();
			chronometer.countdown360().start();
		}

		function activeItems() {
			$('.item').bind('click',style);
			$('.item').bind('click',sg.clock).css('cursor','pointer');
		}

		function style() {
			var $me = $(this);
			$me.hide();
			$me.next().show();
			$me.next().next().show();
		}

		sg.pause = function(btn){
			var action = $(btn).hasClass('play');
			if(action){
				chronometer.countdown360().pause();
				audio.pause();
			}else{
				chronometer.countdown360().resume();
				audio.play();
			}
		}

		var chronometer = $('<div>').attr('id', 'chronometer');
		$('.container-chronometer').append(chronometer);

		chronometer.countdown360({
				radius: 60,
				seconds: 10,
				strokeWidth : 12,
				fontColor: '#5e5e5e',
				strokeStyle: '#fb6d50',
				fillStyle: '#f2f2f2',
				autostart: false,
				onComplete: function() {
					sg.sound('error');
					var group = $('.group'+activeGroup);
					group.find('.btn-right').hide();
					group.find('.board_answer').find('.answer').fadeIn();
					group.find('.scoreboard').children().eq(questionItem-1).addClass('wrong');
					sg.stop();
					next();
				}
			});
	});
});