var initList = initList || [];
initList.push(function() {

    $('.options').find('.option').each(function(index, value) {
      var dropSelector= $(value).attr('data-sg-drop-selector');
      sg.setDraggable($(value), {
        revert: true,
        dropSelector:dropSelector,
        success: function() {
            
            var $this = $(this);
            var drop = $this.data("hit").eq(0);                    

            $this.attr( "data-sg-selected", ("#" + drop.attr("id")) );
            drop.attr("id", (drop.attr("id")+"_fill") );/*si cambio el id no aceptaría ninguno más*/
            $this.removeAttr("style");
            $this.addClass("drag-used");
            drop.append($this);

            var boton = $(".btnCheck");
            var attempts = parseInt(boton.attr("data-sg-count")) + 1;
            boton.attr("data-sg-count", attempts);
            if (attempts == 7) {
                boton.bind("click", revisar).addClass("ready btn-hover");
                boton.css('cursor','pointer');
            }
            sg.sound('success-low');
        },
        fail: function() {
        }
      });
    });

	function revisar(){
        var boton = $(".btnCheck");
        var num_corrects = 0;

        $('.drag-used').each(function() {
            $this = $(this);
            var correct = $this.attr("data-sg-correct");
            var selected = $this.attr("data-sg-selected");

            if(correct === selected){
                $this.addClass("correct").removeClass('btn-hover');
                num_corrects++;
            }else{
            	var elem_selected = $(selected+"_fill");
                var new_id = selected.replace('_fill','').replace('#','');
                elem_selected.attr("id",new_id);

                var id_drag = "#"+ $this.attr("id");
                $this.css("display", "none").remove();
                $(id_drag).css("visibility","visible");
            }
        });

        boton.attr("data-sg-count", num_corrects );
        if (num_corrects === 7)
        {
   			$("div[data-sg-id='btn-popup'][data-sg-key='1']").click();
   			boton.removeClass('ready').unbind("click", revisar);
            sg.sound('claps');
        }else{
            $("div[data-sg-id='btn-popup'][data-sg-key='2']").click();
          	boton.removeClass('ready').unbind("click", revisar);
        }
    }

    //Time line tab1
    var buttons1_tab1 = $(".buttons_tab1");
    var sections1_tab1 = $(".time_line_tab1");
    var stage1_tab1 = 1;
    var num_sections1_tab1 = 2;//sections.children().length;
    var width_sections1_tab1 = 1200;//1014;//parseInt (sections.children().css("width")) + parseInt(sections.children().css("marginRight") )  + parseInt(sections.children().css("marginLeft") );
    var time_factor1_tab1 = 1.5 * width_sections1_tab1;

    buttons1_tab1.click(function(){
            var variation;
            if ($(this).hasClass("tab1_prev")){
                variation = "+=";
                stage1_tab1--;
            }else{
                variation = "-=";
                stage1_tab1++;               
            }
            $(this).fadeOut(50,
                function(){ 
                    sections1_tab1.animate({
                        marginLeft: variation+width_sections1_tab1
                    }, time_factor1, function(){
                                if (stage1_tab1 == 1) buttons1_tab1.last().fadeIn();
                                if (stage1_tab1 == 2) buttons1_tab1.first().fadeIn();
                    });     
                }); 
     
      });

    //Time line tab2
    var buttons1 = $(".buttons");
    var sections1 = $(".time_line");
    var stage1 = 1;
    var num_sections1 = 7;//sections.children().length;
    var width_sections1 = 1200;//1014;//parseInt (sections.children().css("width")) + parseInt(sections.children().css("marginRight") )  + parseInt(sections.children().css("marginLeft") );
    var time_factor1 = 1.5 * width_sections1;

    buttons1.click(function(){
            var variation;
            if ($(this).hasClass("prev")){
                variation = "+=";
                stage1--;
            }else{
                variation = "-=";
                stage1++;               
            }
            if(stage1>=1 && stage1 <= num_sections1){
                $(this).fadeOut(50,
                    function(){ 
                        sections1.animate({
                            marginLeft: variation+width_sections1
                        }, time_factor1, function(){
                                    if (stage1 < num_sections1) buttons1.last().fadeIn();
                                    if (stage1 < num_sections1 && stage1 > 1) buttons1.first().fadeIn();
                        });     
                    }); 
            }
            else{
                if(stage1<1) stage1 = 1;
                if(stage1>num_sections1) stage1 = num_sections1;
            }       
      });
});