/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         for(var i=1; i<=12; i++){
         	sym.setVariable("left"+i, $("#Stage_Drag_"+i).css("left"));
         	sym.setVariable("top"+i, $("#Stage_Drag_"+i).css("top"));
         }
         
         //Centrar el cursor en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
          $(".postres").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage', 		
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,			
         			scroll:false,
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
             });
         
         
         
         
         	sym.$('#Stage_Drop_1').droppable({
         		drop: function( event, ui ){			
            	}
            });	
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         $("#Stage_resp_correcta").css("zIndex","1000");
         $("#Stage_resp_incorrecta").css("zIndex","1001");
         $("#Stage_help").css("zIndex","1002");
         
         	margenIzq = 5;
         	counter = 0;
         
             $("#Stage_Drop_1").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter++;   
         
                         if(counter < 13){                            
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv" + counter);
                         	$("#clonediv" + counter).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1
                         	var posIzqRecp1 = $("#Stage_Drop_1").css("left");
                         	var posTopRecp1 = $("#Stage_Drop_1").css("top");                
         
                         	$("#clonediv" + counter).addClass(itemDragged);                 	
         
                         	if(counter <= 3){                            
         	                	$("#clonediv" + counter).css({opacity:"1",top: "0px", left:  margenIzq});       
                         		margenIzq=margenIzq + 110;       
                         	}
                         	if(counter>3 && counter<=6){
         	                	if(counter == 4){
                         			margenIzq = 5;                			
                         			$("#clonediv" + counter).css({opacity:"1",top: "100px", left:  margenIzq+"px"});	
                         		}     
                         		else{           	
                         			margenIzq=margenIzq + 110;
                         			$("#clonediv" + counter).css({opacity:"1",top: "100px", left:  margenIzq});
                         		}
                         	}
                         	if(counter>6 && counter<=9){
         	                	if(counter == 7){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "200px", left:  margenIzq});	
                         		}  
                         		else{              	
                         			margenIzq=margenIzq + 110;
                         			$("#clonediv" + counter).css({opacity:"1",top: "200px", left:  margenIzq});
                         		}
                         	}       
                         	if(counter>9 && counter<=12){
         	                	if(counter == 10){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "300px", left:  margenIzq});	
                         		}  
                         		else{              	
                         			margenIzq=margenIzq + 110;
                         			$("#clonediv" + counter).css({opacity:"1",top: "300px", left:  margenIzq});
                         		}
                         	}                	
                         }
                     }
                 }
         
         
             });
         
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         var Total = 0;
         
         // Deshabilito todos los drag mientras se validan los datos en la actividad
         sym.$('[id^="Stage_Drag_"]').draggable({
         	disabled:true
         });
         
         //Muestra las leyendas
         if(counter==10){
         	sym.$("resp_correcta").show();
         	sym.$("Drop_1").css({background: fondook});
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	sym.$("Drop_1").css({background: fondobad});
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         $("[class*='dragged']").fadeOut("normal");
         
         setTimeout(borrarDragClone,100);
         
         function borrarDragClone(){
         $("[class*='dragged']").remove();
         margenIzq = 5;
         counter = 0;
         }
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         
         sym.$("Drop_1").css({background: fondook});
         
         var top=0;var left=5;
         
         for(var i=1;i<=10; i++)
         {
         	if(i<=3){
         		$("#Stage_Drag_"+i).css({top:top,left:left}).appendTo( "#Stage_Drop_1" );
         		left = left+110;
         	}
         	if(i>3 && i<=6){
         		if(i==4){
         			left=5;
         		}
         		$("#Stage_Drag_"+i).css({top:top+100,left:left}).appendTo( "#Stage_Drop_1" );
         		left = left+110;
         	}
         	if(i>6 && i<=9){
         		if(i==7){
         			left=5;
         		}
         		$("#Stage_Drag_"+i).css({top:top+200,left:left}).appendTo( "#Stage_Drop_1" );
         		left = left+110;
         	}
         	if(i>9 && i<=10){
         		if(i==10){
         			left=5;
         		}
         		$("#Stage_Drag_"+i).css({top:top+300,left:left}).appendTo( "#Stage_Drop_1" );
         		left = left+110;
         	}
         }
         
         function coordenadas (Drop, simbolo) {
         	varxdrop = sym.$(Drop).css("left");
         	varydrop = sym.$(Drop).css("top");
         	varxdropanch = sym.$(Drop).css("width");
         	varydropalto = sym.$(Drop).css("height");
         	varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
         	varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
         	varxdraganch = sym.$(simbolo).css("width");
         	varydragalto = sym.$(simbolo).css("height");
         	varxdragcentro = parseInt(varxdraganch)/2;
         	varydragcentro = parseInt(varydragalto)/2;
         	sym.$(simbolo).animate({top: varydropcentro-varydragcentro, left: varxdropcentro-varxdragcentro},150);
         };
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         
         $("[class*='dragged']").remove();
         margenIzq = 5;
         counter = 0;
         
         
         $("#Stage_Drop_1").children("div").appendTo("#Stage");
         
         for(var i=1; i<=16; i++){
         	var topDrag_ = sym.getVariable("top"+i);
         	var leftDrag_ = sym.getVariable("left"+i);
         	$("#Stage_Drag_"+i).css({top: topDrag_, left: leftDrag_});
         	$("#Stage_Drag_"+i).draggable ({
         		disabled: false
         	});
         }
         
         
         
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-1010687330");