/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         // Oculto imagenes del libro
         $('#Stage_L_1').hide();
         $('#Stage_L_2').hide();
         
         
         

      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         //Definición de variables
         
         // Comparar los datos digitados por el usuario con los calculados en la aplicación
         if(sym.$('#Campo1').val() == numAnterior && sym.$('#Campo2').val() == numSiguiente){
         	sym.$('resp_correcta').show();
         	sym.$('#Campo1').prop('disabled', true);
         	sym.$('#Campo2').prop('disabled', true);
         	sym.$("success")[0].play();
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         }
         else{
         	sym.$('resp_incorrecta').show();
         	
         	if(sym.$('#Campo1').val() != numAnterior){
         		$('#Stage_BgCampo1').css("background-color","#ff9393");
         	}
         	if(sym.$('#Campo2').val() != numSiguiente){
         		$('#Stage_BgCampo2').css("background-color","#ff9393");
         	}
         	sym.$('#Campo1').prop('disabled', true);
         	sym.$('#Campo2').prop('disabled', true);
         	sym.$("error")[0].play();
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$('#Campo1').val(numAnterior);
         sym.$('#Campo2').val(numSiguiente);
         
         sym.$("#Stage_BgCampo1").css("background-color","#fffdf0");
         sym.$("#Stage_BgCampo2").css("background-color","#fffdf0");
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$("#Stage_BgCampo1").css("background-color","#fffdf0");
         sym.$("#Stage_BgCampo2").css("background-color","#fffdf0");
         
         sym.$('#Campo1').prop('disabled', false);
         sym.$('#Campo2').prop('disabled', false);
         
         sym.$('#Campo1').val('');
         sym.$('#Campo2').val('');
         
         function mostrarNumero(){
         	// Returns a random integer between min (977) and max (988)
         	numAleatorio = Math.floor((Math.random() * (989-977)) + 977);
         	//console.log(numAleatorio);
         
         	if (numAleatorio%2 == 0){
         		//console.log("es par");
         		$('#Stage_L_2').show();
         		$('#Stage_L_1').hide();
         	}
         	else{
         		//console.log("es impar");
         		$('#Stage_L_1').show();
         		$('#Stage_L_2').hide();
         	}
         
         	$('#Stage_TxtNumAleatorio').html(numAleatorio);
         
         	numAnterior = numAleatorio - 1;
         	numSiguiente = numAleatorio + 1;
         	//console.log("Ant: "+numAnterior+" -- Sig: "+numSiguiente);
         }
         
         mostrarNumero();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_input").is(":visible")) {
         	sym.$("help_input").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_input").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
         
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         var campo1 = document.createElement("input");
         campo1.id="Campo1";
         campo1.setAttribute("class", "numero"); 
         campo1.style.width= "50px"; 
         //campo1.style.width= "50px";
         //campo1.style.fontStyle="italic";
         campo1.style.border= "0";
         //campo1.style.background= fondo;
         campo1.style.fontSize= "28px";
         campo1.style.textAlign="center";
         campo1.style.margin="18px 36px";
         campo1.style.backgroundColor="transparent";
         campo1.maxLength="3";
         
         var campo2 = document.createElement("input");
         campo2.id="Campo2";
         campo2.setAttribute("class", "numero"); 
         campo2.style.width= "50px"; 
         //campo2.style.width= "50px";
         //campo2.style.fontStyle="italic";
         campo2.style.border= "0";
         //campo2.style.background= fondo;
         campo2.style.fontSize= "28px";
         campo2.style.textAlign="center";
         campo2.style.margin="18px 36px";
         campo2.style.backgroundColor="transparent";
         campo2.maxLength="3";
         
         $('#Stage_BgCampo1').append(campo1);
         $('#Stage_BgCampo2').append(campo2);
         
         sym.$('.numero').numeric();
         //sym.$('#Stage_BgCampo2').numeric();
         
         function mostrarNumero(){
         	// Returns a random integer between min (977) and max (988)
         	numAleatorio = Math.floor((Math.random() * (989-977)) + 977);
         	//console.log(numAleatorio);
         
         	if (numAleatorio%2 == 0){
         		//console.log("es par");
         		$('#Stage_L_2').show();
         		$('#Stage_L_1').hide();
         	}
         	else{
         		//console.log("es impar");
         		$('#Stage_L_1').show();
         		$('#Stage_L_2').hide();
         	}
         
         	$('#Stage_TxtNumAleatorio').html(numAleatorio);
         
         	numAnterior = numAleatorio - 1;
         	numSiguiente = numAleatorio + 1;
         	//console.log("Ant: "+numAnterior+" -- Sig: "+numSiguiente);
         }
         
         mostrarNumero();
         
         sym.$('#Stage_BgCampo1').click( function(){
         	sym.$('#Campo1').focus();
         });
         
         sym.$('#Stage_BgCampo2').click( function(){
         	sym.$('#Campo2').focus();
         });
         
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
         

      

      

      

   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

  
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-5531445");