/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         //Variable para medir la cantidad de intentos posibles
                sym.setVariable("intentos", 0);
                sym.setVariable("totalintentos", 0);
                //Variables de colores
                sym.setVariable("fondo", "rgba(200,200,200,0.0)");
                sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
                sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
                sym.setVariable("fondook", "rgba(50,230,60,0.4)");
                sym.setVariable("fondoini", "rgba(244,244,244,1)");
                //Colocar la cantidad de puntos a obtener
                TotalDragElements = 20;
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         	//establecer el valor de un símbolo de variable
            /*
            sym.setVariable("Drag_"+i, sym.$("Drag_"+i)); 
            sym.setVariable("Drop_"+i, sym.$("Drop_"+i));      
            */
         }
         
         for(var i=1; i<=50; i++){
         	sym.setVariable("DragVar"+i, 0);
            sym.setVariable("DropVar"+i, 0); 
         }
         
          // Mostrar un elemento.    
          // Create the Draggable with the initial bounds
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
          sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	//grid: [ 1, 1 ],
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         sym.$('[id^="Stage_Drop_"]').droppable({
         	greedy: true, 
         	tolerance: "intersect",
         	drop: function(event, ui){
         	ui.draggable.css('-ms-touch-action', 'none' );
         	 // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
            ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
            ui.draggable.draggable( 'option', 'revert', false );
         }, 
         });
         
         
               sym.$("Drop_1").droppable({
                	  drop: function( event, ui ){ 
                			sym.setVariable("DropVar1", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_1") {
                				sym.setVariable("DragVar1", 1);
                				sym.setVariable("DropVar1", 1);
                			}
         
         /*
         					//si se quieren más opciones para este box se copian así
         
                			if (ui.draggable.attr('id')=="Stage_Drag_02") {
                				sym.setVariable("DragVar2", 1);
                				sym.setVariable("DropVar1", 1);
                			}
         
         */
                			///
                			coordenadas("Drop_1", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_2").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar2", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_2") {
                				sym.setVariable("DragVar2", 1);
                				sym.setVariable("DropVar2", 1);	
                			}
         
                			coordenadas("Drop_2", ui.draggable.attr('id').slice(6));	}
                });	
         
         
         
                sym.$("Drop_3").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar3", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_3") {
                				sym.setVariable("DragVar3", 1);
                				sym.setVariable("DropVar3", 1);
                			}
                			coordenadas("Drop_3", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_4").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar4", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_4") {
                				sym.setVariable("DragVar4", 1);
                				sym.setVariable("DropVar4", 1);
                			}
         
                			coordenadas("Drop_4", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_5").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar5", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_5") {
                				sym.setVariable("DragVar5", 1);
                				sym.setVariable("DropVar5", 1);
                			}
         
                			coordenadas("Drop_5", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_6").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar6", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_6") {
                				sym.setVariable("DragVar6", 1);
                				sym.setVariable("DropVar6", 1);
                			}
         
                			coordenadas("Drop_6", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_7").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar7", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_7") {
                				sym.setVariable("DragVar7", 1);
                				sym.setVariable("DropVar7", 1);
                			}
                			coordenadas("Drop_7", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_8").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar8", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_8") {
                				sym.setVariable("DragVar8", 1);
                				sym.setVariable("DropVar8", 1);
                			}
                			coordenadas("Drop_8", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_9").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar9", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_9") {
                				sym.setVariable("DragVar9", 1);
                				sym.setVariable("DropVar9", 1);
                			}
         
                			coordenadas("Drop_9", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_10").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar10", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_10") {
                				sym.setVariable("DragVar10", 1);
                				sym.setVariable("DropVar10", 1);
                			}
         
                			coordenadas("Drop_10", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_11").droppable({
                		drop: function( event, ui ){
                		sym.setVariable("DropVar11", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_11") {
                				sym.setVariable("DragVar11", 1);
                				sym.setVariable("DropVar11", 1);
                			}
         
                			coordenadas("Drop_11", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_12").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar12", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_12") {
                				sym.setVariable("DragVar12", 1);
                				sym.setVariable("DropVar12", 1);
                			}
                			coordenadas("Drop_12", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_13").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar13", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_13") {
                				sym.setVariable("DragVar13", 1);
                				sym.setVariable("DropVar13", 1);
                			}
                			coordenadas("Drop_13", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_14").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar14", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_14") {
                				sym.setVariable("DragVar14", 1);
                				sym.setVariable("DropVar14", 1);
                			}
         
                			coordenadas("Drop_14", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_15").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar15", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_15") {
                				sym.setVariable("DragVar15", 1);
                				sym.setVariable("DropVar15", 1);
                			}
         
                			coordenadas("Drop_15", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_16").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar16", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_16") {
                				sym.setVariable("DragVar16", 1);
                				sym.setVariable("DropVar16", 1);
                			}
         
                			coordenadas("Drop_16", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_17").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar17", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_17") {
                				sym.setVariable("DragVar17", 1);
                				sym.setVariable("DropVar17", 1);
                			}
                			coordenadas("Drop_17", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_18").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar18", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_18") {
                				sym.setVariable("DragVar18", 1);
                				sym.setVariable("DropVar18", 1);
                			}
                			coordenadas("Drop_18", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_19").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar19", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_19") {
                				sym.setVariable("DragVar19", 1);
                				sym.setVariable("DropVar19", 1);
                			}
         
                			coordenadas("Drop_19", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_20").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar20", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_20") {
                				sym.setVariable("DragVar20", 1);
                				sym.setVariable("DropVar20", 1);
                			}
         
                			coordenadas("Drop_20", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_21").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar21", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_21") {
                				sym.setVariable("DragVar21", 1);
                				sym.setVariable("DropVar21", 1);
                			}
         
                			coordenadas("Drop_21", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_22").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar22", 0);
         
                			if (ui.draggable.attr('id')=="Stage_Drag_22") {
                				sym.setVariable("DragVar22", 1);
                				sym.setVariable("DropVar22", 1);	
                			}
         
                			coordenadas("Drop_22", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_23").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar23", 0);
         
                			if (ui.draggable.attr('id')=="Stage_Drag_23") {
                				sym.setVariable("DragVar23", 1);
                				sym.setVariable("DropVar23", 1);
                			}
                			coordenadas("Drop_23", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_24").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar24", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_24") {
                				sym.setVariable("DragVar24", 1);
                				sym.setVariable("DropVar24", 1);
                			}
         
                			coordenadas("Drop_24", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_25").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar25", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_25") {
                				sym.setVariable("DragVar25", 1);
                				sym.setVariable("DropVar25", 1);
                			}
         
                			coordenadas("Drop_25", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_26").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar26", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_26") {
                				sym.setVariable("DragVar26", 1);
                				sym.setVariable("DropVar26", 1);
                			}
         
                			coordenadas("Drop_26", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_27").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar27", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_27") {
                				sym.setVariable("DragVar27", 1);
                				sym.setVariable("DropVar27", 1);
                			}
                			coordenadas("Drop_27", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_28").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar28", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_28") {
                				sym.setVariable("DragVar28", 1);
                				sym.setVariable("DropVar28", 1);
                			}
                			coordenadas("Drop_28", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_29").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar29", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_29") {
                				sym.setVariable("DragVar29", 1);
                				sym.setVariable("DropVar29", 1);
                			}
         
                			coordenadas("Drop_29", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_30").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar30", 0);
                			if (ui.draggable.attr('id')=="Stage_Drag_30") {
                				sym.setVariable("DragVar30", 1);
                				sym.setVariable("DropVar30", 1);
                			}
         
                			coordenadas("Drop_30", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_31").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar31", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_31") {
                			sym.setVariable("DragVar31", 1);
                			sym.setVariable("DropVar31", 1);
                		}
         
                		coordenadas("Drop_31", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_32").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar32", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_32") {
                			sym.setVariable("DragVar32", 1);
                			sym.setVariable("DropVar32", 1);
                		}
         
                		coordenadas("Drop_32", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_33").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar33", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_33") {
                			sym.setVariable("DragVar33", 1);
                			sym.setVariable("DropVar33", 1);
                		}
         
                		coordenadas("Drop_33", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_34").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar34", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_34") {
                			sym.setVariable("DragVar34", 1);
                			sym.setVariable("DropVar34", 1);
                		}
         
                		coordenadas("Drop_34", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_35").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar35", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_35") {
                			sym.setVariable("DragVar35", 1);
                			sym.setVariable("DropVar35", 1);
                		}
         
                		coordenadas("Drop_35", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_36").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar36", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_36") {
                			sym.setVariable("DragVar36", 1);
                			sym.setVariable("DropVar36", 1);
                		}
         
                		coordenadas("Drop_36", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_37").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar37", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_37") {
                			sym.setVariable("DragVar37", 1);
                			sym.setVariable("DropVar37", 1);
                		}
         
                		coordenadas("Drop_37", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_38").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar38", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_38") {
                			sym.setVariable("DragVar38", 1);
                			sym.setVariable("DropVar38", 1);
                		}
         
                		coordenadas("Drop_38", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_39").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar39", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_39") {
                			sym.setVariable("DragVar39", 1);
                			sym.setVariable("DropVar39", 1);
                		}
         
                		coordenadas("Drop_39", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_41").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar41", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_41") {
                			sym.setVariable("DragVar41", 1);
                			sym.setVariable("DropVar41", 1);
                		}
         
                		coordenadas("Drop_41", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_42").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar42", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_42") {
                			sym.setVariable("DragVar42", 1);
                			sym.setVariable("DropVar42", 1);
                		}
         
                		coordenadas("Drop_42", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_43").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar43", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_43") {
                			sym.setVariable("DragVar43", 1);
                			sym.setVariable("DropVar43", 1);
                		}
         
                		coordenadas("Drop_43", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_44").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar44", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_44") {
                			sym.setVariable("DragVar44", 1);
                			sym.setVariable("DropVar44", 1);
                		}
         
                		coordenadas("Drop_44", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_45").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar45", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_45") {
                			sym.setVariable("DragVar45", 1);
                			sym.setVariable("DropVar45", 1);
                		}
         
                		coordenadas("Drop_45", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_46").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar46", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_46") {
                			sym.setVariable("DragVar46", 1);
                			sym.setVariable("DropVar46", 1);
                		}
         
                		coordenadas("Drop_46", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_47").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar47", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_47") {
                			sym.setVariable("DragVar47", 1);
                			sym.setVariable("DropVar47", 1);
                		}
         
                		coordenadas("Drop_47", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_48").droppable({
                		drop: function( event, ui ){  
         
                		sym.setVariable("DropVar48", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_48") {
                			sym.setVariable("DragVar48", 1);
                			sym.setVariable("DropVar48", 1);
                		}
                		coordenadas("Drop_48", ui.draggable.attr('id').slice(6));	}
                });	
         
         
                sym.$("Drop_49").droppable({
                		drop: function( event, ui ){  
                		sym.setVariable("DropVar49", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_49") {
                			sym.setVariable("DragVar49", 1);
                			sym.setVariable("DropVar49", 1);
                		}
                		coordenadas("Drop_49", ui.draggable.attr('id').slice(6));	}
                });	
         
                sym.$("Drop_50").droppable({
                		drop: function( event, ui ){  
                		sym.setVariable("DropVar50", 0);
                		if (ui.draggable.attr('id')=="Stage_Drag_50") {
                			sym.setVariable("DragVar50", 1);
                			sym.setVariable("DropVar50", 1);
                		}
         
                			coordenadas("Drop_50", ui.draggable.attr('id').slice(6));	
                		}
                	});	
         
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'Bg'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getSymbol("volcano").play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 81750, function(sym, e) {
         sym.play(1501);

      });
      //Edge binding end

   })("Bg");
   //Edge symbol end:'Bg'

   //=========================================================
   
   //Edge symbol: 'volcano'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("volcano");
   //Edge symbol end:'volcano'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
            // enable button/link
         });
         
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion);
         // Definir un conmutador para reproducir o pausar una pista de audio 
         if (sym.getComposition().getStage().$(soundId)[0].paused) {
         //elimina el mute del audio
         	sym.getComposition().getStage().$(soundId)[0].muted = false;
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.getComposition().getStage().$(soundId)[0].volume=0.7;
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

   })("bt_audio");
   //Edge symbol end:'bt_audio'

})(jQuery, AdobeEdge, "EDGE-1010687330");