/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // insert code to be run when the symbol is created here
         sym.setVariable("campo", "input");
         //Variables de colores
         sym.setVariable("border", "1px double #cccccc");
         sym.setVariable("fondo", "rgba(220,220,220,0.50)");
         sym.setVariable("colorini", "#999999");
         sym.setVariable("colorok", "#666666");
         sym.setVariable("fondook", "#d3e3c3");
         sym.setVariable("colorbad", "#666666");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("fontsize", "50px");
         sym.setVariable("fontFamily", "Cabin");
         sym.setVariable("fontStyle", "bold");
         sym.setVariable("webkit-border-radius", "5px");
         sym.setVariable("moz-border-radius", "5px");
         sym.setVariable("border-radius", "5px");
         //Variable ancho todos los input
         var campo = sym.getVariable("campo");
         var largo = "70px";
         var border = sym.getVariable("border");
         var tamano = sym.getVariable("fontsize");
         var fondo = sym.getVariable("fondo");
         var webkitBorderRadius= sym.getVariable("webkit-border-radius");
         var mozBorderRadius= sym.getVariable("moz-border-radius");
         var borderRadius= sym.getVariable("border-radius");
         
         
         var CampoComienzo = document.createElement(campo);
         CampoComienzo.id="Comienzo";
         CampoComienzo.class="numero";
         CampoComienzo.style.width= largo; 
         //Elemento_01.style.width= "50px";
         //Elemento_01.style.fontStyle="italic";
         CampoComienzo.style.border= border;
         CampoComienzo.style.background= fondo;
         CampoComienzo.style.fontSize= tamano;
         CampoComienzo.style.textAlign="center";
         CampoComienzo.maxLength="2";
         CampoComienzo.style.webkitBorderRadius=webkitBorderRadius;
         CampoComienzo.style.mozBorderRadius=mozBorderRadius;
         CampoComienzo.style.borderRadius=borderRadius;
         
         
         
         var CampoCambio = document.createElement(campo);
         CampoCambio.id="Cambio";
         CampoCambio.class="numero";
         CampoCambio.style.width= largo; 
         //Elemento_01.style.width= "50px";
         //Elemento_01.style.fontStyle="italic";
         CampoCambio.style.border= border;
         CampoCambio.style.background= fondo;
         CampoCambio.style.fontSize= tamano;
         CampoCambio.style.textAlign="center";
         CampoCambio.maxLength="2";
         CampoCambio.style.webkitBorderRadius=webkitBorderRadius;
         CampoCambio.style.mozBorderRadius=mozBorderRadius;
         CampoCambio.style.borderRadius=borderRadius;
         
         var CampoFinal = document.createElement(campo);
         CampoFinal.id="Final";
         CampoFinal.class="numero";
         CampoFinal.style.width= largo; 
         //Elemento_01.style.width= "50px";
         //Elemento_01.style.fontStyle="italic";
         CampoFinal.style.border= border;
         CampoFinal.style.background= fondo;
         CampoFinal.style.fontSize= tamano;
         CampoFinal.style.textAlign="center";
         CampoFinal.maxLength="2";
         CampoFinal.style.webkitBorderRadius=webkitBorderRadius;
         CampoFinal.style.mozBorderRadius=mozBorderRadius;
         CampoFinal.style.borderRadius=borderRadius;
         
         sym.setVariable("ComienzoVar", 0);
         sym.$("Comienzo").append(CampoComienzo);
         
         sym.setVariable("CambioVar", 0);
         sym.$("Cambio").append(CampoCambio);
         
         sym.setVariable("FinalVar", 0);
         sym.$("Final").append(CampoFinal);
         

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         
         // insert code for mouse click here
         //console.log('click! '+numeroCambio);
         primerValor = sym.$('#Comienzo').val();
         segundoValor = sym.$('#Cambio').val();
         total = sym.$('#Final').val();
         //console.log('click! '+primerValor);
         
         if(numeroComienzo == primerValor && numeroCambio == segundoValor && resultado == total){
         	sym.$('resp_correcta').show();
         	sym.$('resp_incorrecta').hide();
         	sym.$("HideComienzo").hide();
         	sym.$("HideCambio").hide();
         	sym.$("HideFinal").hide();
         	sym.$('#Comienzo').prop('disabled', true);
         	sym.$('#Cambio').prop('disabled', true);
         	sym.$('#Final').prop('disabled', true);
         	//audio correcto
         	sym.$("success")[0].play();
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	setTimeout(function(){sym.$('resp_correcta').hide("normal");}, 2000);
         }
         else{
         	sym.$('resp_incorrecta').show();
         	sym.$('resp_correcta').hide();
         	//audio incorrecto
         	sym.$("error")[0].play();
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.$('#Comienzo').prop('disabled', true);
         	sym.$('#Cambio').prop('disabled', true);
         	sym.$('#Final').prop('disabled', true);
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         	
         	sym.$("HideComienzo").hide();
         	sym.$("HideCambio").hide();
         	sym.$("HideFinal").hide();
         	sym.$('#Comienzo').val(numeroComienzo);
         	sym.$('#Cambio').val(numeroCambio);
         	sym.$('#Final').val(resultado);
         	sym.$('#Comienzo').prop('disabled', true);
         	sym.$('#Cambio').prop('disabled', true);
         	sym.$('#Final').prop('disabled', true);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         
         sym.$("#Comienzo").val("");
         sym.$("#Cambio").val("");
         sym.$("#Final").val("");
         
         sym.$('#Comienzo').prop('disabled', false);
         sym.$('#Cambio').prop('disabled', false);
         sym.$('#Final').prop('disabled', false);
         
         
         function reiniciar() {
         sym.$("#Stage_ViewComienzo").empty();
         sym.$("#Stage_ViewCambio").empty();
         sym.$("#Stage_ViewFinal").empty();
         resultado=0,temp=0;
         resultado = Math.floor(Math.random() * (21 - 2)) + 2; 
         temp = resultado - 1;
         numeroComienzo = Math.floor((Math.random() * temp) + 1); 
         numeroCambio = resultado - numeroComienzo;
         
         
         // Ocultar recuadro aleatoriamente y asignar valores a los input
         recuadroVisible = Math.floor((Math.random() * 2) + 1);
         switch (recuadroVisible){
         	case  1 : sym.$("HideComienzo").show();
         				 sym.$("HideCambio").hide();
         				 sym.$("HideFinal").hide();				 
         				 sym.$('#Cambio').val(numeroCambio);
         				 sym.$('#Final').val(resultado);
         				 sym.$('#Cambio').prop('disabled', true);
         				 sym.$('#Final').prop('disabled', true);
         				 break;
         
         	case  2 : sym.$("HideCambio").show();
         				 sym.$("HideComienzo").hide();
         				 sym.$("HideFinal").hide();
         				 sym.$('#Comienzo').val(numeroComienzo);
         				 sym.$('#Final').val(resultado);
         				 sym.$('#Comienzo').prop('disabled', true);
         				 sym.$('#Final').prop('disabled', true);
         				 break;  
         
         	default : sym.$("HideFinal").show();
         				 sym.$("HideComienzo").hide();
         				 sym.$("HideCambio").hide();
         				 sym.$('#Comienzo').val(numeroComienzo);
         				 sym.$('#Cambio').val(numeroCambio);
         				 sym.$('#Comienzo').prop('disabled', true);
         				 sym.$('#Cambio').prop('disabled', true);
         }
         
         imagen = '';
         img = Math.floor((Math.random() * 2) + 1);
         if (img == 1) { imagen = 'golosina';} else {imagen = 'flor';}
         
         // Ejecución de la función para desplegar las imagenes en los recuadros
         desplegarRecuadros("ViewComienzo", numeroComienzo);
         desplegarRecuadros("ViewCambio", numeroCambio);
         desplegarRecuadros("ViewFinal", resultado);
         
         function desplegarRecuadros(vista,limite){
         
         	// Declarar variables de posición
         	pTop = 16;
         	pLeftStatic = [12,12,12,12];
         	gol = [];
         
         	// Agregar imagenes dinámicamente
         	for (i=0 ; i<limite; i++){		
         
         	gol2 = sym.createChildSymbol(imagen, vista); 
         	gol.push(gol2);	
         	}
         
         	for (h=0 ; h<limite; h++){		
         
         		if (h >4 && h<10){			
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[0], 
               	'top': pTop + 55           
         			});
         			pLeftStatic[0] += 40;
         		}		
         
         		else if (h >9 && h<15){
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[1], 
               	'top': pTop + 110           
         			});	
         			pLeftStatic[1] += 40;
         		}	
         		else if (h >14){
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[2], 
               	'top': pTop + 165           
         			});
         			pLeftStatic[2] += 40;
         		}	
         		else {
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[3], 
               	'top': pTop           
         			});
         			pLeftStatic[3] += 40;
         		}	
         	}
         }
         }
         
         reiniciar();

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         $("input").css({
         	"-webkit-user-select": "none",  /* Chrome all / Safari all */
            "-moz-user-select": "none",     /* Firefox all */
           	"-ms-user-select": "none",      /* IE 10+ */
           	/* No support for these yet, use at own risk */
           	"-o-user-select": "none",
           	"user-select": "none"
         });   
         
         sym.$('#Comienzo').numeric();
         sym.$('#Cambio').numeric();
         sym.$('#Final').numeric();
         
         resultado=0,temp=0;
         resultado = Math.floor(Math.random() * (21 - 2)) + 2; 
         temp = resultado - 1;
         numeroComienzo = Math.floor((Math.random() * temp) + 1); 
         numeroCambio = resultado - numeroComienzo;
         
         // Ocultar recuadro aleatoriamente y asignar valores a los input
         recuadroVisible = Math.floor((Math.random() * 2) + 1);
         switch (recuadroVisible){
         	case  1 : sym.$("HideComienzo").show();
         				 sym.$("HideCambio").hide();
         				 sym.$("HideFinal").hide();				 
         				 sym.$('#Cambio').val(numeroCambio);
         				 sym.$('#Final').val(resultado);
         				 sym.$('#Cambio').prop('disabled', true);
         				 sym.$('#Final').prop('disabled', true);
         				 break;
         
         	case  2 : sym.$("HideCambio").show();
         				 sym.$("HideComienzo").hide();
         				 sym.$("HideFinal").hide();
         				 sym.$('#Comienzo').val(numeroComienzo);
         				 sym.$('#Final').val(resultado);
         				 sym.$('#Comienzo').prop('disabled', true);
         				 sym.$('#Final').prop('disabled', true);
         				 break;  
         
         	default : sym.$("HideFinal").show();
         				 sym.$("HideComienzo").hide();
         				 sym.$("HideCambio").hide();
         				 sym.$('#Comienzo').val(numeroComienzo);
         				 sym.$('#Cambio').val(numeroCambio);
         				 sym.$('#Comienzo').prop('disabled', true);
         				 sym.$('#Cambio').prop('disabled', true);
         }
         
         imagen = '';
         img = Math.floor((Math.random() * 2) + 1);
         if (img == 1) { imagen = 'golosina';} else {imagen = 'flor';}
         
         // Ejecución de la función para desplegar las imagenes en los recuadros
         desplegarRecuadros("ViewComienzo", numeroComienzo);
         desplegarRecuadros("ViewCambio", numeroCambio);
         desplegarRecuadros("ViewFinal", resultado);
         
         function desplegarRecuadros(vista,limite){
         
         	// Declarar variables de posición
         	pTop = 16;
         	pLeftStatic = [12,12,12,12];
         	gol = [];
         
         	// Agregar imagenes dinámicamente
         	for (i=0 ; i<limite; i++){		
         
         	gol2 = sym.createChildSymbol(imagen, vista); 
         	gol.push(gol2);	
         	}
         
         	for (h=0 ; h<limite; h++){		
         
         		if (h >4 && h<10){			
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[0], 
               	'top': pTop + 55           
         			});
         			pLeftStatic[0] += 40;
         		}		
         
         		else if (h >9 && h<15){
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[1], 
               	'top': pTop + 110           
         			});	
         			pLeftStatic[1] += 40;
         		}	
         		else if (h >14){
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[2], 
               	'top': pTop + 165           
         			});
         			pLeftStatic[2] += 40;
         		}	
         		else {
         			gol[h].getSymbolElement().css({
               	'position': 'absolute',
               	'left': pLeftStatic[3], 
               	'top': pTop           
         			});
         			pLeftStatic[3] += 40;
         		}	
         	}
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_input").is(":visible")) {
         	sym.$("help_input").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_input").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'HideComienzo'
   (function(symbolName) {   
   
   })("HideComienzo");
   //Edge symbol end:'HideComienzo'

   //=========================================================
   
   //Edge symbol: 'HideCambio'
   (function(symbolName) {   
   
   })("HideCambio");
   //Edge symbol end:'HideCambio'

   //=========================================================
   
   //Edge symbol: 'HideFinal'
   (function(symbolName) {   
   
   })("HideFinal");
   //Edge symbol end:'HideFinal'

   //=========================================================
   
   //Edge symbol: 'golosina'
   (function(symbolName) {   
   
   })("golosina");
   //Edge symbol end:'golosina'

   //=========================================================
   
   //Edge symbol: 'flor'
   (function(symbolName) {   
   
   })("flor");
   //Edge symbol end:'flor'

})(jQuery, AdobeEdge, "EDGE-94063035");