/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         //tipo de actividad
         sym.setVariable("tipoactividad", "textarea");
         //Variables de colores
         //sym.setVariable("border", "2px double #cccccc");
         sym.setVariable("border", "none");
         sym.setVariable("fondo", "rgba(255,255,255,0.50)");
         sym.setVariable("colorini", "#666666");
         sym.setVariable("colorok", "#666666");
         sym.setVariable("fondook","rgba(255,255,255,0.80)");
         sym.setVariable("colorbad", "#ffffff");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("fontsize", "30px");
         sym.setVariable("fontFamily", "Cabin");
         sym.setVariable("fontStyle", "normal");
         sym.setVariable("textAlign", "left");
         sym.setVariable("fontweight", "bold");
         sym.setVariable("height", "auto");
         sym.setVariable("border-radius", "5px");

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // introducir aquí código que se debe ejecutar cuando la composición está totalmente cargada
         var border = sym.getVariable("border");
         var fontsize = sym.getVariable("fontsize");
         var fondo = sym.getVariable("fondo");
         var tipoactividad = sym.getVariable("tipoactividad");
         var fontFamily = sym.getVariable("fontFamily");
         var fontStyle= sym.getVariable("fontStyle");
         var fontweight = sym.getVariable("fontweight");
         var textAlign=  sym.getVariable("textAlign");
         var colorini= sym.getVariable("colorini");
         var borderRadius= sym.getVariable("border-radius");
         TotalTextArea = 3;
         
         for (i=1 ; i<= TotalTextArea; i++){
         sym.$("TextArea_"+i).css("background","rgba(255,255,255,0.50)");
         	var nombreElemento = 'Elemento_'+i;
         	nombreElemento = document.createElement(tipoactividad);
         	nombreElemento.id="TextArea_"+i;
         	var anchoTextArea = sym.$("TextArea_"+i).css("width");
         	var altoTextArea = sym.$("TextArea_"+i).css("height");
         	nombreElemento.style.width= anchoTextArea;	 
         	nombreElemento.style.height= altoTextArea;
         	nombreElemento.style.border= border;
         	nombreElemento.style.color= colorini;
         	nombreElemento.style.background= fondo;
         	nombreElemento.style.fontSize= fontsize;
         	nombreElemento.style.fontWeight= fontweight;
         	nombreElemento.style.textAlign= textAlign;
         	nombreElemento.style.webkitBorderRadius=borderRadius;
         	nombreElemento.style.mozBorderRadius=borderRadius;
         	nombreElemento.style.borderRadius=borderRadius;
         	sym.$("TextArea_"+i).append(nombreElemento);
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         
         	sym.getSymbol("bt_reiniciar").stop("normal");
         		sym.$("hotspot_reiniciar").show();
         
         
         for(i=0; i<=TotalTextArea; i++){
         	$("#TextArea_"+i).val("");
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_validar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
         });
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion); 
         
         $("audio").prop("muted", true);
         
         	if (sym.getComposition().getStage().$(soundId)[0].paused) {
         	//elimina el mute del audio
         	sym.getComposition().getStage().$(soundId)[0].muted = false;
         	sym.getComposition().getStage().$(soundId)[0].volume=0.7;
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

   })("bt_audio");
   //Edge symbol end:'bt_audio'

})(jQuery, AdobeEdge, "EDGE-1010687340");