/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         $("<link/>", {"rel": "stylesheet", "type": "text/css", "href": "css/fuentes.css" }).appendTo("head");
         
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         color = "rgb(255, 255, 255)";
         
         sym.$(".colorSelect").click(function(){
         	//idColorSelect = this.id;
         	sym.$(".colorSelect").css({"border-color":"rgba(241,241,241,1.00)",
         	"border-width":"4px"
         	});
         	$(this).css({"border-color":"red",
         	"border-width":"6px"
         	});
         	switch (this.id){		
         		case "Stage_color_1": color="rgb(254, 148, 152)";
         		break;
         		case "Stage_color_2": color="rgb(122, 221, 54)";
         		break;
         		case "Stage_color_3": color="rgb(0, 191, 255)";
         		break;
         		case "Stage_color_4": color="rgb(175, 119, 47)";
         		break;
         		case "Stage_color_5": color="rgb(255, 203, 18)";
         		break;
         		case "Stage_color_6": color="rgb(213, 84, 249)";
         		break;	
         		case "Stage_color_7": color="rgb(255, 255, 255)";
         		break;	
         	}
         });
         
         sym.$(".imagenes").css("cursor","pointer");
         sym.$(".colorSelect").css("cursor","pointer");
         
         sym.$(".imagenes").click(function(){
         	var bImg = this.id;
         	bImg = "Stage_b"+(bImg.substr(6));
         	$("#"+bImg).css("background-color",color);
         });
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         // introducir código aquí
         sym.play();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         // insert code for mouse click here
         var correctos = 0;
         var colorFlor = "";
         var colorCarro = "";
         var colorPelota = "";
         var colorOso = "";
         
         
         for(var i=1;i<=7;i++){
         	colorFlor = $("#Stage_bflor_"+i).css("background-color");	
         	colorCarro = $("#Stage_bcarro_"+i).css("background-color");	
         	colorPelota = $("#Stage_bpelota_"+i).css("background-color");	
         	colorOso = $("#Stage_boso_"+i).css("background-color");	
         
         	if (colorFlor == "rgb(254, 148, 152)" && colorFlor != undefined){
         		correctos++;
         	}
         	if (colorCarro != "rgb(122, 221, 54)" && colorCarro != undefined){
         		correctos++;
         	}
         	if (colorPelota != "rgb(0, 191, 255)" && colorPelota != undefined){
         		correctos++;
         	}
         	if (colorOso == "rgb(175, 119, 47)" && colorOso != undefined){
         		correctos++;
         	}
         }
         
         sym.$(".colorSelect").css("pointer-events","none");
         sym.$(".imagenes").css("pointer-events","none");
         
         if(correctos == 21){
         		//mensaje respuesta correcta
         		sym.$("resp_correcta").show();
         		//audio correcto
         		sym.$("success")[0].play();
         		//botones
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("down");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").hide();
         		sym.$("hotspot_reiniciar").show();
         	}	
         	else{
         		sym.$("resp_incorrecta").show();
         		//audio incorrecto
         		sym.$("error")[0].play();
         		//botones
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").show();
         		sym.$("hotspot_reiniciar").show();
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("normal");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         	}
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         
         sym.$(".flores").css("background-color","white");
         sym.$(".carros").css("background-color","white");
         sym.$(".pelotas").css("background-color","white");
         sym.$(".osos").css("background-color","white");
         
         sym.$(".colorSelect").css("pointer-events","auto");
         
         sym.$(".imagenes").css("pointer-events","auto");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$(".colorSelect").css("pointer-events","none");
         
         sym.$(".imagenes").css("pointer-events","none");
         
         sym.$(".flores").css("background-color","rgb(254, 148, 152)");
         sym.$(".carros").css("background-color","rgb(255, 203, 18)");
         sym.$(".pelotas").css("background-color","rgb(122, 221, 54)");
         sym.$(".osos").css("background-color","rgb(175, 119, 47)");
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-94063035");