/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the symbol is created here
         //$("<link/>", {"rel": "stylesheet", "type": "text/css", "href": "css/fuentes.css" }).appendTo("head");
         
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         color = "rgb(255, 255, 255)";
         
         sym.$(".colorSelect").click(function(){
         	//idColorSelect = this.id;
         	sym.$(".colorSelect").css({"border-color":"rgba(241,241,241,1.00)",
         	"border-width":"4px"
         	});
         	$(this).css({"border-color":"red",
         	"border-width":"6px"
         	});
         	switch (this.id){		
         		case "Stage_color_1": color="rgb(255, 255, 255)";
         		break;
         		case "Stage_color_2": color="rgb(62,116,255)";
         		break;
         		case "Stage_color_3": color="rgb(189,22,255)";
         		break;		
         	}
         });
         
         sym.$(".imagenes").css("cursor","pointer");
         sym.$(".colorSelect").css("cursor","pointer");
         
         sym.$(".imagenes").click(function(){
         	var bImg = this.id;
         	//console.log(bImg);
         	bImg = "Stage_b"+(bImg.substr(6));
         	$("#"+bImg).css("background-color",color);
         });
         
         //Ocultar la ayuda cuando se hace click sobre ella
         sym.$("help_colorear").click(function(){
         	sym.$("help_colorear").fadeOut();
         });
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         // insert code for mouse click here
         var correctos = 0;
         var colorCarro1 = "";
         var colorCarro2 = "";
         var colorTambor1 = "";
         var colorTambor2 = "";
         
         
         	colorCarro1 = $("#Stage_bcarro_1").css("background-color");	
         	colorCarro2 = $("#Stage_bcarro_2").css("background-color");	
         	colorTambor1 = $("#Stage_btambor_1").css("background-color");
         	colorTambor2 = $("#Stage_btambor_2").css("background-color");	
         
         	if (colorCarro1 == "rgb(62, 116, 255)"){
         		correctos++;
         	}
         	if (colorCarro2 == "rgb(62, 116, 255)"){
         		correctos++;
         	}
         	if (colorTambor1 == "rgb(189, 22, 255)"){
         		correctos++;
         	}
         	if (colorTambor2 == "rgb(189, 22, 255)"){
         		correctos++;
         	}
         
         sym.$(".colorSelect").css("pointer-events","none");
         sym.$(".imagenes").css("pointer-events","none");
         
         sym.$(".posiciones").show();
         
         if(correctos == 4){
         		//mensaje respuesta correcta
         		sym.$("resp_correcta").show();
         		setTimeout("$('#Stage_resp_correcta').fadeOut();",3000);
         		//audio correcto
         		sym.$("success")[0].play();
         		//botones
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("down");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").hide();
         		sym.$("hotspot_reiniciar").show();		
         	}	
         	else{	
         		sym.$("resp_incorrecta").show();
         		//setTimeout("$('#Stage_resp_incorrecta').fadeOut();",3000);
         		//audio incorrecto
         		sym.$("error")[0].play();
         		//botones
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").show();
         		sym.$("hotspot_reiniciar").show();
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("normal");
         		sym.getSymbol("bt_reiniciar").stop("normal");		
         	}
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$(".colorSelect").css("pointer-events","none");
         
         sym.$(".imagenes").css("pointer-events","none");
         
         $("#Stage_bcarro_1").css("background-color","rgb(62, 116, 255)");	
         $("#Stage_bcarro_2").css("background-color","rgb(62, 116, 255)");	
         $("#Stage_btambor_1").css("background-color","rgb(189, 22, 255)");	
         $("#Stage_btambor_2").css("background-color","rgb(189, 22, 255)");	
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         
         sym.$(".objetos1").css("background-color","white");
         
         sym.$(".colorSelect").css("pointer-events","auto");
         
         sym.$(".imagenes").css("pointer-events","auto");
         
         sym.$(".posiciones").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
   //Edge symbol: 'bt_back'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

   })("bt_back");
   //Edge symbol end:'bt_back'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'Der1'
   (function(symbolName) {   
   
   })("Der1");
   //Edge symbol end:'Der1'

   //=========================================================
   
   //Edge symbol: 'Izq1'
   (function(symbolName) {   
   
   })("Izq1");
   //Edge symbol end:'Izq1'

   //=========================================================

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
         });
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion); 
         
         $("audio").prop("muted", true);
         
         	if (sym.getComposition().getStage().$(soundId)[0].paused) {
         	//elimina el mute del audio
         	sym.getComposition().getStage().$(soundId)[0].muted = false;
         	sym.getComposition().getStage().$(soundId)[0].volume=0.7;
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

   })("bt_audio");
   //Edge symbol end:'bt_audio'

})(jQuery, AdobeEdge, "EDGE-5531445");