/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         opacidadImg = '';
         var bPal = '';
         
         sym.$(".paleta").click(function(){
         	var bPal = this.id;
         	bPal = bPal.substr(6);
         	//console.log(bPal);
         	//bImg = "Stage_b"+(bImg.substr(6));
         	if(bPal == 'pincel'){
         		opacidadImg = 0;
         		$("#Stage_"+bPal).css({
         	  		"border-width": "3px",   
           			"border-color": "red",  
           			"border-style": "solid" 
         		});
         		$("#Stage_eraser").css({
         	  		"border-width": "0px",   
           			"border-color": "orange",   
           			"border-style": "solid" 
         		});
         	}
         	if(bPal == 'eraser'){
         		opacidadImg = 1;
         		$("#Stage_"+bPal).css({
         	  		"border-width": "3px",  
           			"border-color": "red",   
           			"border-style": "solid" 
         		});
         		$("#Stage_pincel").css({
         	  		"border-width": "0px",  
           			"border-color": "orange",   
           			"border-style": "solid"
         		});
         	}	
         });
         
         
         sym.$(".imagenes").click(function(){
         	var bImg = this.id;	
         	//bImg = "Stage_b"+(bImg.substr(6));
         	$("#"+bImg).css("opacity",opacidadImg);
         });
         
         //Ocultar la ayuda cuando se hace click sobre ella
         sym.$("help_colorear").click(function(){
         	sym.$("help_colorear").fadeOut();
         	sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         	sym.$("resp_correcta").hide();
         	sym.$("resp_incorrecta").hide();
         
         
         sym.$(".imagenes").css("pointer-events","auto");
         sym.$(".paleta").css("pointer-events","auto");
         
         sym.$(".posiciones").hide();
         
         $(".imagenes").css("opacity",1);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$(".paleta").css("pointer-events","none");
         sym.$(".imagenes").css("pointer-events","none");
         
         $("#Stage_paisaje_1").css("opacity",0);
         $("#Stage_paisaje_2").css("opacity",1);
         
         sym.$(".posiciones").show();
         
         
         
         
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         
         var bgPaisaje1 = $("#Stage_paisaje_1").css("opacity");
         var bgPaisaje2 = $("#Stage_paisaje_2").css("opacity");
         
         sym.$(".paleta").css("pointer-events","none");
         sym.$(".imagenes").css("pointer-events","none");
         
         sym.$(".posiciones").show();
         
         if(bgPaisaje1 == 0 && bgPaisaje2 == 1){
         		//mensaje respuesta correcta
         		sym.$("resp_correcta").show();
         		setTimeout("$('#Stage_resp_correcta').fadeOut();",3000);
         		//audio correcto
         		sym.$("success")[0].play();
         		//botones
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("down");
         		sym.getSymbol("bt_reiniciar").stop("normal");
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").hide();
         		sym.$("hotspot_reiniciar").show();		
         	}	
         	else{	
         		sym.$("resp_incorrecta").show();
         		//setTimeout("$('#Stage_resp_incorrecta').fadeOut();",3000);
         		//audio incorrecto
         		sym.$("error")[0].play();
         		//botones
         		sym.$("hotspot_validar").hide();
         		sym.$("hotspot_solucion").show();
         		sym.$("hotspot_reiniciar").show();
         		sym.getSymbol("bt_validar").stop("down");
         		sym.getSymbol("bt_solucion").stop("normal");
         		sym.getSymbol("bt_reiniciar").stop("normal");		
         	}
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
   //Edge symbol: 'bt_back'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

   })("bt_back");
   //Edge symbol end:'bt_back'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'Der1'
   (function(symbolName) {   
   
   })("Der1");
   //Edge symbol end:'Der1'

   //=========================================================
   
   //Edge symbol: 'Izq1'
   (function(symbolName) {   
   
   })("Izq1");
   //Edge symbol end:'Izq1'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-5531445");