/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
             sym.$('.center-wrapper').css("overflow","hidden");
             //tipo de actividad
             sym.setVariable("tipoactividad", "input");
             //Variables de colores
             sym.setVariable("border", "0px double #cccccc");
             sym.setVariable("fondo", "rgba(255,255,255,0.00)");
             sym.setVariable("colorini", "#1a1a1a");
             sym.setVariable("colorok", "#666666");
             sym.setVariable("fondook","rgba(100,220,120,0.00)");
             sym.setVariable("colorbad", "#ffffff");
             sym.setVariable("fondobad", "#f3716c");
             sym.setVariable("fontsize", "26px");
             sym.setVariable("fontFamily", "Cabin");
             sym.setVariable("fontStyle", "normal");
             sym.setVariable("fontweight", "bold");
             sym.setVariable("height", "auto");
             sym.setVariable("border-radius", "5px");
             
             
             sym.$("selectedPartTxt1").html("Departamento");
             sym.$("selectedPartTxt2").html("Departamento");
             sym.$("selectedPartTxt3").html("Departamento");
             sym.$("selectedPartTxt4").html("Departamento");
             
             yepnope({
             complete: function() {
             //cambiar el nombre por el del SVG
             EC.SVG.accessSVG(sym.$("imagen")).done(
             function(svgDocument){
             // add event listener
             svgDocument.addEventListener("select", function(event) {
             // Remember selected part
             sym.setVariable("selectedPart", event.target);
             // show the id of the selected part in the textfield
             var departamentoT = event.target.id;
             console.log(departamentoT);
             departamento = departamentoT.replace(/_/g," ");
             sym.$("selectedPartTxt1").html( departamento );
             sym.$("selectedPartTxt2").html( departamento );
             sym.$("selectedPartTxt3").html( departamento );
             sym.$("selectedPartTxt4").html( departamento );
             
             });
             });
             }
             });
             sym.setVariable("changeColor", function(color) {});

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //Llammar variables creation Complete
         var tipoactividad = sym.getVariable("tipoactividad");
         var color = sym.getVariable("colorini");
         var border = sym.getVariable("border");
         var tamano = sym.getVariable("fontsize");
         var fontweight = sym.getVariable("fontweight");
         var fondo = sym.getVariable("fondo");
         var borderRadius= sym.getVariable("border-radius");
         
         TotalInput = 4;
         // Agregar los input dinámicamente
         for (i=1 ; i<= TotalInput; i++){
         sym.$("Input_"+i).css("background","rgba(255,255,255,0.50)");
         	var nombreElemento = 'Elemento_'+i;
         	nombreElemento = document.createElement(tipoactividad);
         	nombreElemento.id="seleccion_"+i;
         	var anchoInput = sym.$("Input_"+i).css("width");
         	var altoInput = sym.$("Input_"+i).css("height");
         	nombreElemento.style.width= anchoInput;	 
         	nombreElemento.style.height= altoInput;
         	nombreElemento.style.border= border;
         	nombreElemento.style.color= color;
         	nombreElemento.style.background= fondo;
         	nombreElemento.style.fontSize= tamano;
         	nombreElemento.style.fontWeight= fontweight;
         	nombreElemento.style.textAlign="left";
         	nombreElemento.style.webkitBorderRadius=borderRadius;
         	nombreElemento.style.mozBorderRadius=borderRadius;
         	nombreElemento.style.borderRadius=borderRadius;
         	sym.$("Input_"+i).append(nombreElemento);
         }
         $("input").focus(function() {
            $(this).val('');
         });
         
         sym.getSymbol("bt_info").stop("down");
         //sym.getComposition().getStage().$("ventanas_dialogo").show();
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_input").is(":visible")) {
         	sym.$("help_input").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_input").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Stage}", "touchstart", function(sym, e) {
         defaultPrevented();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_help_input}", "click", function(sym, e) {
         sym.$("help_input").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ventanas_dialogo}", "click", function(sym, e) {
         sym.$("ventanas_dialogo").hide();
         sym.getSymbol("bt_info").stop(0);
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         sym.$("selectedPartTxt1").html("Departamento");
         sym.$("selectedPartTxt2").html("Departamento");
         sym.$("selectedPartTxt3").html("Departamento");
         sym.$("selectedPartTxt4").html("Departamento");
         
         $("input").val("");
         
         sym.$("help_input").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         
         sym.$("ventanas_dialogo").hide();
         sym.getSymbol("bt_info").stop(0);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'bt_validar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar_1");
   //Edge symbol end:'bt_validar_1'

   //=========================================================
   
   //Edge symbol: 'bt_solucion_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion_1");
   //Edge symbol end:'bt_solucion_1'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar_1");
   //Edge symbol end:'bt_reiniciar_1'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda_1");
   //Edge symbol end:'bt_ayuda_1'

   //=========================================================
   
   //Edge symbol: 'bt_info'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hot_spot_1}", "click", function(sym, e) {
         sym.stop("down");
         // Mostrar un elemento 
         sym.getComposition().getStage().$("ventanas_dialogo").show();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hot_spot_2}", "click", function(sym, e) {
         sym.stop("up");
         sym.getComposition().getStage().$("ventanas_dialogo").hide();

      });
      //Edge binding end

   })("bt_info");
   //Edge symbol end:'bt_info'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar_2");
   //Edge symbol end:'bt_reiniciar_2'

})(jQuery, AdobeEdge, "EDGE-94063035");