/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
             yepnope({
             complete: function() {
             //cambiar el nombre por el del SVG
             EC.SVG.accessSVG(sym.$("imagen")).done(
             function(svgDocument){
             // add event listener
             svgDocument.addEventListener("select", function(event) {
             // Remember selected part
             sym.setVariable("selectedPart", event.target);
             // show the id of the selected part in the textfield
             sym.$("selectedPartTxt").html( event.target.id );
             });
             });
             }
             });
             sym.setVariable("changeColor", function(color) {});

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         $("<link/>", {"rel": "stylesheet", "type": "text/css", "href": "css/fuentes.css" }).appendTo("head");
         
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         sym.$("hotspot_ayuda").show();
         
         //sym.$(".letras").css("text-shadow","2px 0 0 #fff, -2px 0 0 #fff, 0 2px 0 #fff, 0 -2px 0 #fff, 1px 1px #fff, -1px -1px 0 #fff, 1px -1px 0 #fff, -1px 1px 0 #fff");
         
         var colorLetra="white";
         
         sym.$(".colorSelect").click(function(){
         	//idColorSelect = this.id;
         	switch (this.id){
         		case "Stage_color_1": colorLetra="#FF1D25";
         		break;
         		case "Stage_color_2": colorLetra="#7AC943";
         		break;
         		case "Stage_color_3": colorLetra="#FFE900";
         		break;
         		case "Stage_color_4": colorLetra="#662D91";
         		break;
         		case "Stage_color_5": colorLetra="#00BFEF";
         		break;
         		case "Stage_color_6": colorLetra="#FFFFFF";
         		break;	
         		//default:colorLetra="#FFFFFF";;	
         	}
         	//colorLetra="red";
         });
         
         sym.$(".letras").click(function(){
         	$(this).css("background-color",colorLetra);
         });
         
         

      });
      //Edge binding end

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_color_6}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_color_5}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));
         sym.$("color_5").css("border-color","rgba(6,140,210,1.00)");
         sym.$("color_2").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_3").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_1").css("border-color","rgba(241,241,241,1.00)");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_color_4}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_color_3}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));
         sym.$("color_3").css("border-color","rgba(6,140,210,1.00)");
         sym.$("color_2").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_1").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_5").css("border-color","rgba(241,241,241,1.00)");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_color_2}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));
         sym.$("color_2").css("border-color","rgba(6,140,210,1.00)");
         sym.$("color_1").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_3").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_5").css("border-color","rgba(241,241,241,1.00)");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_color_1}", "click", function(sym, e) {
         var selectedPart = sym.getVariable("selectedPart");
         $(selectedPart).css("fill", $(e.currentTarget).css("background-color"));
         sym.$("color_1").css("border-color","rgba(6,140,210,1.00)");
         sym.$("color_2").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_3").css("border-color","rgba(241,241,241,1.00)");
         sym.$("color_5").css("border-color","rgba(241,241,241,1.00)");

      });
      //Edge binding end

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         // introducir código aquí
         sym.play();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         sym.$(".letras").css("background-color","white");
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'bt_validar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar_1");
   //Edge symbol end:'bt_validar_1'

   //=========================================================
   
   //Edge symbol: 'bt_solucion_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion_1");
   //Edge symbol end:'bt_solucion_1'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar_1");
   //Edge symbol end:'bt_reiniciar_1'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda_1");
   //Edge symbol end:'bt_ayuda_1'

})(jQuery, AdobeEdge, "EDGE-94063035");