/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         TotalDragElements = 28;
         
         sym.$('.center-wrapper').css("overflow","hidden");
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 	
         			//sym.setVariable("DropVar"+DropId, verificarRespuestas("RespDrop"+DropId,ui.draggable.attr('id')));
               	coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));	
            	}
            });	
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
             };

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         
         sym.$('[id^="Stage_Drag_"]').draggable({
         	      //helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage',        
         			//opacity: 0.5,
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,
         			cursor:"move",
         			//snap:true,
         			//snapMode: "both",
         			//snapTolerance:20,
         			scroll:false,		
         			revert: "invalid",
         			revertDuration: 500,				
         			/*			
         			helper: function() {			
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             });        
             return helper;
         
           	}*/
         
         });
         
         // Se establece el atributo vacio para todos los elementos droppables
         sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
         
         		 $(".ui-droppable").on( "drop", function( event, ui ) {
         		 	// Verifico el estado del drop (ocupado o vacio)
         					var estadoDrop = $(this).attr("dragelement");
         
         					// 
         					if(estadoDrop != "vacio"){										
         						var numDrag = estadoDrop.slice(11);	
         						var posLeftDrag = sym.getVariable("left"+numDrag);
         						var posTopDrag = sym.getVariable("top"+numDrag);
         						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					} else{
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					}
         
         		 } );
         
         		 $(".ui-droppable").droppable({	
         				out: function( event, ui ){ 
         					var estadoDrop = $(this).attr("dragelement");
         					var idDraggable = ui.draggable.attr('id');
         					if(estadoDrop == idDraggable ){	
         						$(this).attr("dragelement","vacio");					
         					}
         					else{						
         					}
         				}
         		 });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         });
         
         sym.$("#Stage_Drag_1").draggable({	   
           	start: function( event, ui ) {
           		$("#Stage_Drag_2").show(); 
           		$(".drop_triangulos").show(); 		
           		$(".cuadrados").css("pointer-events","none");
           		$(".barras").css("pointer-events","none");
           		$(".rectangulos").css("pointer-events","none");  
           	}
         });
         
         
         sym.$("#Stage_Drag_16").draggable({	   
           	start: function( event, ui ) {  		
           		$(".drop_cuadrados").show(); 
           		$(".triangulos").css("pointer-events","none");
           		$(".barras").css("pointer-events","none");
           		$(".rectangulos").css("pointer-events","none");  		
           	}
         });
         
         sym.$("#Stage_Drag_24").draggable({	   
           	start: function( event, ui ) {  	
           		$(".drop_barras").show(); 	
           		$(".triangulos").css("pointer-events","none");
           		$(".cuadrados").css("pointer-events","none");
           		$(".rectangulos").css("pointer-events","none");  		
           	}
         });
         
         sym.$("#Stage_Drag_28").draggable({	   
           	start: function( event, ui ) {
           		$(".drop_rectangulos").show(); 	  		
           		$(".triangulos").css("pointer-events","none");
           		$(".barras").css("pointer-events","none");
           		$(".cuadrados").css("pointer-events","none");  		
           	}
         });
         
         sym.$("#Stage_Drag_2").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_3").show();
           	}
         });
         
         sym.$("#Stage_Drag_3").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_4").show();
           	}
         });
         
         sym.$("#Stage_Drag_4").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_5").show();
           	}
         });
         
         sym.$("#Stage_Drag_5").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_6").show();
           	}
         });
         
         sym.$("#Stage_Drag_6").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_7").show();
           	}
         });
         
         sym.$("#Stage_Drag_7").draggable({	 
           	stop: function( event, ui ) {
           		$("#Stage_Drag_8").show();
           	}
         });
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         for(var i=1; i<=TotalDragElements; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         	sym.$("Drag_"+i).draggable ({
         		disabled: false
         	});
         	//sym.$("Drop_"+i).css({color: colorini ,background: fondoini});
         	sym.setVariable("DropVar"+i, 0);
         }
         
         $("#Stage_Drag_2").hide();
         $("#Stage_Drag_3").hide();
         $("#Stage_Drag_4").hide();
         $("#Stage_Drag_5").hide();
         $("#Stage_Drag_6").hide();
         $("#Stage_Drag_7").hide();
         $("#Stage_Drag_8").hide();
         
         $('[id^="Stage_Drag_"]').css("pointer-events","auto");
         
         $('[id^="Stage_Drop_"]').hide();

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-5531445");