/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         for(var i=10; i<=30; i++){
         	sym.setVariable("left"+i, $("#Stage_drag_"+i).css("left"));
         	sym.setVariable("top"+i, $("#Stage_drag_"+i).css("top"));
         }
         
         	sym.$("#Stage_Producto").droppable({
         		accept: ".productos",
               	drop: function( event, ui ){ 
                		coordenadas("#Stage_Producto", ui.draggable.attr('id').slice(6));	
         			}
            });	
         
         
         		 function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         $("body").css("user-select","none");
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
             //Make element draggable
             	$(".dinero").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage',        
         			//opacity: 0.5,
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,
         			//snap:true,
         			//snapMode: "both",
         			//snapTolerance:20,
         			scroll:false,
         			//helper: "clone",
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
             });
         
             $(".productos").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage',        
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,			
         			scroll:false,
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
         
             });
         
             sym.$('#Stage_Producto').attr("dragelement","vacio");
         
         		 $(".ui-droppable").on( "drop", function( event, ui ) {
         		 	// Verifico el estado del drop (ocupado o vacio)
         					var estadoDrop = $(this).attr("dragelement");
         					$("#Stage_hotspot_reiniciar").trigger("click");
         
         					if(estadoDrop != "vacio"){															
         						var numDrag = estadoDrop.slice(11);	
         						var posLeftDrag = sym.getVariable("left"+numDrag);
         						var posTopDrag = sym.getVariable("top"+numDrag);						
         						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					} else{
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					}
         
         		 } );
         
         		 $(".ui-droppable").droppable({	
         				out: function( event, ui ){ 
         					var estadoDrop = $(this).attr("dragelement");
         					var idDraggable = ui.draggable.attr('id');
         					if(estadoDrop == idDraggable ){	
         						$(this).attr("dragelement","vacio");					
         					}
         					else{						
         					}
         				}
         		 });
         
         	margenIzq = 5;
         	counter = 0;
         
             $("#Stage_Recipiente1").droppable({
             	accept: ".dinero",
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/drag_[0-9]/) != -1) {
                         counter++;   
         
                         if(counter < 10){                            
                         	//$("#Stage_Recipiente1").removeClass("ui-droppable");
         
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv" + counter);
                         	$("#clonediv" + counter).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1
                         	var posIzqRecp1 = $("#Stage_Recipiente1").css("left");
                         	var posTopRecp1 = $("#Stage_Recipiente1").css("top");                
                         	//console.log(itemDragged);
                         	$("#clonediv" + counter).addClass(itemDragged);                 	
         
                         	if(counter <= 3){                            
         	                	$("#clonediv" + counter).css({opacity:"1",top: "0px", left:  margenIzq});       
                         		margenIzq=margenIzq + 130;       
                         	}
                         	if(counter>3 && counter<=6){
         	                	if(counter == 4){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "86px", left:  5});	
                         		} 
                         		else{               	
                         			margenIzq=margenIzq + 130;
                         			$("#clonediv" + counter).css({opacity:"1",top: "86px", left:  margenIzq});
                         		}
                         	}
                         	if(counter>6&& counter<=15){
         	                	if(counter == 7){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "172px", left:  margenIzq});	
                         		} 
                         		else{               	
                         			margenIzq=margenIzq + 130;
                         			$("#clonediv" + counter).css({opacity:"1",top: "172px", left:  margenIzq});
                         		}
                         	}
                         	//margenIzq=margenIzq + 40;
                         }
                     }
                 }
             });
         
             margenIzq2 = 90;
         	 counter2 = 0;
         
             $("#Stage_Recipiente2").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/drag[0-9]/) != -1) {
                         counter2++;   
         
                         if(counter2 < 16){                            
                         	//$("#Stage_Recipiente1").removeClass("ui-droppable");
         
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv2" + counter2);
                         	$("#clonediv2" + counter2).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/drag([0-9])/)
                         	itemDragged = "dragged2" + RegExp.$1
                         	var posIzqRecp2 = $("#Stage_Recipiente2").css("left");
                         	var posTopRecp2 = $("#Stage_Recipiente2").css("top");                
                         	//console.log(itemDragged);
                         	$("#clonediv2" + counter2).addClass(itemDragged);                 	
         
                         	if(counter2 <= 5){                            
         	                	$("#clonediv2" + counter2).css({opacity:"0.8",top: "220px", left:  margenIzq2});       
                         		margenIzq2=margenIzq2 + 40;       
                         	}
                         	if(counter2>5 && counter2<=11){
         	                	if(counter2 == 6){
                         			margenIzq2 = 30;
                         			$("#clonediv2" + counter2).css({opacity:"0.8",top: "182px", left:  margenIzq2});	
                         		}                	
                         		margenIzq2=margenIzq2 + 40;
                         		$("#clonediv2" + counter2).css({opacity:"0.8",top: "182px", left:  margenIzq2});
                         	}
                         	if(counter2>11&& counter2<=15){
         	                	if(counter2 == 12){
                         			margenIzq2 = 50;
                         			$("#clonediv2" + counter2).css({opacity:"0.8",top: "144px", left:  margenIzq2});	
                         		}                	
                         		margenIzq2=margenIzq2 + 40;
                         		$("#clonediv2" + counter2).css({opacity:"0.8",top: "144px", left:  margenIzq2});
                         	}
                         	//margenIzq=margenIzq + 40;
                         }
                     }
                 }
         
         
             });
         
         
         /*
         // let the gallery items be draggable
         $(".spheres").draggable({
         cancel: "a.ui-icon", // clicking an icon won't initiate dragging
         revert: "invalid", // when not dropped, the item will revert back to its initial position
         //containment: "document",
         helper: "clone",
         cursor: "move",
         
         appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,	
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revertDuration: 500,
         
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            },
         
            stop: function(event, ui) {
                 //$(ui.helper).clone(true).removeClass('spheres').addClass('spheres').appendTo('body');
                 //$(ui.helper).clone(true).removeClass('ui-draggable ui-draggable-dragging').addClass('sphere-clone').appendTo('#Stage');
                 $(ui.helper).clone(true).addClass('sphere-clone').appendTo('#Stage');
                 //$(this).draggable('option','revert','invalid');
            }
         });
         */
         
         function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
         };
         

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         // insert code for mouse click here
         $("[class*='dragged']").fadeOut();
         
         setTimeout(borrarDragClone,400);
         
         function borrarDragClone(){
         $("[class*='dragged']").remove();
         margenIzq = 90;
         counter = 0;
         
         margenIzq = 5;
         counter = 0;
         }
         
         for(var i=1; i<=26; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	$("#Stage_drag_"+i).css({top: topDrag, left: leftDrag});
         	$("#Stage_drag_"+i).draggable ({
         		disabled: false
         	});	
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
   //Edge symbol: 'bt_back'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

   })("bt_back");
   //Edge symbol end:'bt_back'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

})(jQuery, AdobeEdge, "EDGE-5531445");