/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         for(var i=10; i<=30; i++){
         	sym.setVariable("left"+i, $("#Stage_drag_"+i).css("left"));
         	sym.setVariable("top"+i, $("#Stage_drag_"+i).css("top"));
         }
         
         	sym.$("#Stage_Producto").droppable({
         		accept: ".productos",
               	drop: function( event, ui ){ 
                		coordenadas("#Stage_Producto", ui.draggable.attr('id').slice(6));	
         			}
            });	
         
         
         		 function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         $("body").css("user-select","none");
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
             //Make element draggable
             	$(".dinero").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage',        
         			//opacity: 0.5,
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,
         			//snap:true,
         			//snapMode: "both",
         			//snapTolerance:20,
         			scroll:false,
         			//helper: "clone",
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
             });
         
             $(".productos").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage',        
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,			
         			scroll:false,
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
         
             });
         
             sym.$('#Stage_Producto').attr("dragelement","vacio");
         
         		 $(".ui-droppable").on( "drop", function( event, ui ) {
         		 	// Verifico el estado del drop (ocupado o vacio)
         					var estadoDrop = $(this).attr("dragelement");
         					$("#Stage_hotspot_reiniciar").trigger("click");
         
         					if(estadoDrop != "vacio"){															
         						var numDrag = estadoDrop.slice(11);	
         						var posLeftDrag = sym.getVariable("left"+numDrag);
         						var posTopDrag = sym.getVariable("top"+numDrag);						
         						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					} else{
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					}
         
         		 } );
         
         		 $(".ui-droppable").droppable({	
         				out: function( event, ui ){ 
         					var estadoDrop = $(this).attr("dragelement");
         					var idDraggable = ui.draggable.attr('id');
         					if(estadoDrop == idDraggable ){	
         						$(this).attr("dragelement","vacio");					
         					}
         					else{						
         					}
         				}
         		 });
         
         	margenIzq = 5;
         	counter = 0;
         
             $("#Stage_Recipiente1").droppable({
             	accept: ".dinero",
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter++;   
         
                         if(counter < 34){                            
                         	//$("#Stage_Recipiente1").removeClass("ui-droppable");
         
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv" + counter);
                         	$("#clonediv" + counter).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1
                         	var posIzqRecp1 = $("#Stage_Recipiente1").css("left");
                         	var posTopRecp1 = $("#Stage_Recipiente1").css("top");                
                         	//console.log(itemDragged);
                         	$("#clonediv" + counter).addClass(itemDragged);                 	
         
                         	if(counter <= 11){                            
         	                	$("#clonediv" + counter).css({opacity:"1",top: "0px", left:  margenIzq});       
                         		margenIzq=margenIzq + 100;       
                         	}
                         	if(counter>11 && counter<=22){
         	                	if(counter == 12){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "120px", left:  5});	
                         		} 
                         		else{               	
                         			margenIzq=margenIzq + 100;
                         			$("#clonediv" + counter).css({opacity:"1",top: "120px", left:  margenIzq});
                         		}
                         	}
                         	if(counter>22&& counter<=34){
         	                	if(counter == 23){
                         			margenIzq = 5;
                         			$("#clonediv" + counter).css({opacity:"1",top: "240px", left:  margenIzq});	
                         		} 
                         		else{               	
                         			margenIzq=margenIzq + 100;
                         			$("#clonediv" + counter).css({opacity:"1",top: "240px", left:  margenIzq});
                         		}
                         	}
                         	//margenIzq=margenIzq + 40;
                         }
                     }
                 }
             });
         
             margenIzq2 = 90;
         	 counter2 = 0;
         
         function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
         };
         

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         // insert code for mouse click here
         $("[class*='dragged']").fadeOut();
         
         setTimeout(borrarDragClone,400);
         
         function borrarDragClone(){
         $("[class*='dragged']").remove();
         margenIzq = 90;
         counter = 0;
         
         margenIzq = 5;
         counter = 0;
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'bt_next'
   (function(symbolName) {   
   
      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
      });
      //Edge binding end

      

   })("bt_next");
   //Edge symbol end:'bt_next'

   //=========================================================
   
   //Edge symbol: 'bt_back'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         

      });
      //Edge binding end

      

      

      

      

      

      

   })("bt_back");
   //Edge symbol end:'bt_back'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

})(jQuery, AdobeEdge, "EDGE-5531445");