/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         sym.$('.center-wrapper').css("overflow","hidden");
         sym.setVariable("Elementos", 1);
         //Variables de colores
         sym.setVariable("border", "2px solid #f4f4f4");
         sym.setVariable("fondo", "rgba(220,220,220,0.10)");
         sym.setVariable("colorini", "#666666");
         sym.setVariable("colorok", "#666666");
         sym.setVariable("fondook", "#d3e3c3");
         sym.setVariable("colorbad", "#666666");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("tipoactividad", "TextArea")
         sym.setVariable("fontsize", "21px");
         sym.setVariable("fontFamily", "Cabin");
         sym.setVariable("fontStyle", "bold");
         sym.setVariable("webkit-border-radius", "10px");
         sym.setVariable("moz-border-radius", "10px");
         sym.setVariable("border-radius", "10px");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         TotalDragElements = 16;
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         for(var i=1; i<=50; i++){
            sym.setVariable("DropVar"+i, 0); 
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Variable ancho todos los input
         
         var border = sym.getVariable("border");
         var tamano = sym.getVariable("fontsize");
         var fondo = sym.getVariable("fondo");
         var tipoactividad = sym.getVariable("tipoactividad");
         var fontFamily = sym.getVariable("fontFamily");
         var fontStyle= sym.getVariable("fontStyle");
         var colorini= sym.getVariable("colorini");
         var webkitBorderRadius= sym.getVariable("webkit-border-radius");
         var mozBorderRadius= sym.getVariable("moz-border-radius");
         var borderRadius= sym.getVariable("border-radius");
         
         
         var Elemento_01=document.createElement("TextArea");
         Elemento_01.id="seleccion_01";
         Elemento_01.style.width= "168px";
         Elemento_01.style.height= "95px"; 
         Elemento_01.style.border= border;
         Elemento_01.style.background= fondo;
         Elemento_01.style.fontSize= tamano;
         Elemento_01.style.textAlign="left";
         Elemento_01.style.padding="15px";
         Elemento_01.style.fontFamily=fontFamily;
         Elemento_01.style.fontStyle=fontStyle;
         Elemento_01.style.color=colorini;
         Elemento_01.style.resize="none";
         // deshabilitar selección del texto
         /*
         sym.$("Texto").css('disabled',true);
         sym.$("Texto").css('cursor', 'default');
         sym.$("Texto").css('-webkit-user-select', ' none');
         sym.$("Texto").css('-webkit-touch-callout', ' none');
         sym.$("Texto").css('-khtml-user-select', ' none');
         sym.$("Texto").css('-moz-user-select', ' none');
         sym.$("Texto").css('-ms-user-select', ' none');
         sym.$("Texto").css('-o-user-select', ' none');
         */
         $("#Stage_TextArea").append(Elemento_01);
         
         sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         	margenIzq2 = 20;
         	 counter2 = 0;
         
             $("#Stage_Drop").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter2++;   
         
                         if(counter2 < 7){                            
                         	//$("#Stage_Recipiente1").removeClass("ui-droppable");
         
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv2" + counter2);
                         	$("#clonediv2" + counter2).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged2" + RegExp.$1                	               
                         	//console.log(itemDragged);
                         	$("#clonediv2" + counter2).addClass(itemDragged);                 	
         
         
         	                	$("#clonediv2" + counter2).css({opacity:"0.8",top: "5px", left:  margenIzq2});       
         	              		margenIzq2=margenIzq2+200;
         
                         }
                     }
                 }
         
         
             });

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         // insert code for mouse click here
         $("[class*='dragged']").fadeOut();
         
         setTimeout(borrarDragClone,200);
         
         function borrarDragClone(){
         $("[class*='dragged']").remove();
         margenIzq = 30;
         counter = 0;
         
         margenIzq2 = 65;
         counter2 = 0;
         }
         
         $("#seleccion_01").val("");
         
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'slide_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //CAMBIAR ESTA OPCIÓN A PLAY SI SE DESEA INICIAR LA ANIMACIÓN O SI ES IMAGEN FIJA PONERLA EN STOP 
         sym.stop();

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("slide_1");
   //Edge symbol end:'slide_1'

   //=========================================================
   
   //Edge symbol: 'Hot_Spot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("Hot_Spot");
   //Edge symbol end:'Hot_Spot'

   //=========================================================
   
   //Edge symbol: 'bg_defecto_simbolo'
   (function(symbolName) {   
   
   })("bg_defecto_simbolo");
   //Edge symbol end:'bg_defecto_simbolo'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

})(jQuery, AdobeEdge, "EDGE-5531445");