/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         (function($) {
            var $fortune = function(args) {
         
             if (args === undefined) {
               throw(new Error("You must define the options.prices"));
             }
         
             var options = $.extend({}, {
               prices: args,
               duration: 1000,
               separation: 2,
               min_spins: 10,
               max_spins: 15,
               onSpinBounce: function() {}
             }, args);
         
             var fortune = this;
             var prices_amount = Array.isArray(options.prices)?options.prices.length:options.prices;
             var prices_delta = 360 / prices_amount;
             var is_spinning = false;
         
             fortune.spin = function(price) {
               price = typeof price === "number"?price:Math.floor(Math.random() * prices_amount);
               var deferred = $.Deferred();
               var position = Math.floor(prices_delta * (price - 1/2) + randomBetween(options.separation, prices_delta - options.separation));
               var spins = randomBetween(options.min_spins, options.max_spins);
               var final_position = 360 * spins + position;
               var prev_position = 0;
               var is_bouncing = false;
         
               is_spinning = true;
         
               fortune
               .css({
                 "transform": "rotate(" + final_position + "deg)",
                 "-webkit-transform": "rotate(" + final_position + "deg)",
                 "transition": "transform " + options.duration + "ms cubic-bezier(.17,.67,.12,.99)",
                 "-webkit-transition": "-webkit-transform " + options.duration + "ms cubic-bezier(.17,.67,.12,.99)"
               })
               .siblings('.spin').removeClass('bounce');
         
               var bounceSpin = function() {
                 var curPosition = Math.floor(getRotationDegrees(fortune)),
                 mod = Math.floor((curPosition + prices_delta*0.5) % prices_delta),
                 diff_position,
                 position_threshold = prices_delta/5,
                 distance_threshold = prices_delta/10;
         
                 prev_position = Math.floor(curPosition < prev_position ? prev_position - 360 : prev_position);
                 diff_position = curPosition - prev_position;
         
                 if ((mod < position_threshold && diff_position < distance_threshold) ||
                     (mod < position_threshold*3 && diff_position >= distance_threshold)) {
                   if (!is_bouncing) {
                     fortune.siblings('.spin').addClass('bounce');
                     options.onSpinBounce(fortune.siblings('.spin'));
                     is_bouncing = true;
                   }
                 } else {
                   fortune.siblings('.spin').removeClass('bounce');
                   is_bouncing = false;
                 }
         
                 if (is_spinning) {
                   prev_position = curPosition;
                   requestAnimationFrame(bounceSpin);
                 }
               };
         
               //var animSpin = requestAnimationFrame(bounceSpin);
         
               setTimeout(function() {
                 fortune
                 .css({
                   "transform": "rotate(" + position + "deg)",
                   "-webkit-transform": "rotate(" + position + "deg)",
                   "transition": "",
                   "-webkit-transition": ""
                 })
                 .siblings('.spin').removeClass('bounce');
         
                 //cancelAnimationFrame(animSpin);
                 deferred.resolve(Array.isArray(options.prices)?options.prices[price]:price);
                 is_spinning = false;
               }, options.duration);
         
               return deferred.promise();
             };
         
             var getRotationDegrees = function(obj) {
               var angle = 0,
               matrix = obj.css("-webkit-transform") ||
                 obj.css("-moz-transform")    ||
                 obj.css("-ms-transform")     ||
                 obj.css("-o-transform")      ||
                 obj.css("transform");
               if (matrix !== 'none') {
                 var values = matrix.split('(')[1].split(')')[0].split(','),
                 a = values[0],
                 b = values[1],
                 radians = Math.atan2(b, a);
         
                 if ( radians < 0 ) {
                   radians += (2 * Math.PI);
                 }
         
                 angle = Math.round( radians * (180/Math.PI));
               }
         
               return angle;
             };
         
             var randomBetween = function(min, max) {
               return Math.floor(Math.random() * (max - min + 1)) + min;
             };
         
             return fortune;
           };
         
           $.extend($.fn, {
             fortune: $fortune
           });
         }) (jQuery);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         // Change the text in an element
         sym.$("Color").html("");
         
         var options = {
           prices: [
             {
               name: 'Rojo'
             },
             {
               name: 'Anaranjado'
             },
             {
               name: 'Azul'
             },
             {
               name: 'Verde'
             },
             {
               name: 'Fucsia'
             },
             {
               name: 'Amarillo'
             }
           ],
           duration: 3000
         };
         
         var $r = $('.roulette').fortune(options);
         
         
         var clickHandler = function() {
           $('.spinner').off('click');
           $('.girar').hide();
           //var price = Math.floor((Math.random() * 8));
           $r.spin().done(function(price) {
               //$('.price ').text('Color: ' + price.name);
               $('.spinner').on('click', clickHandler);
               $('.girar').show();
             });
         };
         
         $('.spinner').on('click', clickHandler);
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'flecha_bt'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("flecha_bt");
   //Edge symbol end:'flecha_bt'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
            // enable button/link
         });
         
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion);
         // Definir un conmutador para reproducir o pausar una pista de audio 
         if (sym.getComposition().getStage().$(soundId)[0].paused) {
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.getComposition().getStage().$(soundId)[0].volume=0.7;
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

   })("bt_audio");
   //Edge symbol end:'bt_audio'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'escena'
   (function(symbolName) {   
   
   })("escena");
   //Edge symbol end:'escena'

   //=========================================================
   
   //Edge symbol: 'ruleta'
   (function(symbolName) {   
   
   })("ruleta");
   //Edge symbol end:'ruleta'

})(jQuery, AdobeEdge, "EDGE-94063035");