/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(218,57,57,0.71)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
          transformarTexto = true; // Cambiar a false, si la actividad es de lenguaje o requiere validación exacta de las palabras   
         		  eliminarEspacios = false; // Cambiar a true, si la actividad es de matemáticas o requiere omitir los espacios en blanco de la validación
         		  //Total de inputs       
                 TotalInput = 50;
                 //Para filtrar se pueden usar las siguientes variables:
                 /* 
         		'int'= [0-9] //números enteros 
         		'num' =[0-9.]  //números y punto
         		'alphanum' =[a-z0-9_] 
         		'alpha'=[a-zA-z_ ]//caracteres mayúscula, minúscula y espacio
         		'alphalower'=[a-z_ ]  //caracteres en minúsculas y números
         		'alphaupper'=[A-Z_ ]  //caracteres en mayúscula y números
         		'alphanumupper'=[a-zA-Z0-9_]  //caracteres en minúsculas, mayúsculas y números
         		'alphanumspacelower'= [a-z0-9_ ]  //caracteres en minúsculas, números y espacio
         		'alphanumspace'= [a-z0-9_ ] //caracteres en minúsculas, espacio y números
         		'alphanumspacelower' =[a-z0-9_ ]		
         		'all'=[a-zA-Z0-9_°!"#$%&/()=?¡¨*;:_-.,}{´+¿`^[]{}@ ] //POR DEFECTO ESTÁN HABILITADOS TODOS LOS CARACTERES 
         		*/
         
                 filtrar='all';
                 sym.setVariable("border", "2px double #cccccc");			
         			sym.setVariable("colorini", "#666666");
         			sym.setVariable("colorok", "#666666");	
         			sym.setVariable("fontsize", "38px");
         			sym.setVariable("fontFamily", "Cabin");
         			sym.setVariable("fontStyle", "normal");
         			sym.setVariable("fontweight", "bold");
         			sym.setVariable("height", "auto");
         			sym.setVariable("border-radius", "5px");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 4;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 1;
         
         // Determino las respuestas correctas para cada drop en la actividad
         var dontTouch = 0;
         var Rd1 = new Array(dontTouch); 
         sym.setVariable("RespDrop1", Rd1);
         var Rd2 = new Array(dontTouch); 
         sym.setVariable("RespDrop2", Rd2);
         var Rd3 = new Array(dontTouch); 
         sym.setVariable("RespDrop3", Rd3);
         var Rd4 = new Array(dontTouch); 
         sym.setVariable("RespDrop4", Rd4);
         var Rd5 = new Array(dontTouch); 
         sym.setVariable("RespDrop5", Rd5);
         var Rd6 = new Array(dontTouch); 
         sym.setVariable("RespDrop6", Rd6);
         var Rd7 = new Array(dontTouch); 
         sym.setVariable("RespDrop7", Rd7);
         var Rd8 = new Array(dontTouch); 
         sym.setVariable("RespDrop8", Rd8);
         var Rd9 = new Array(dontTouch); 
         sym.setVariable("RespDrop9", Rd9);
         var Rd10 = new Array(dontTouch); 
         sym.setVariable("RespDrop10", Rd10);
         
         
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         for(var i=1; i<=50; i++){
            sym.setVariable("DropVar"+i, 0); 
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
          sym.$('[id^="Stage_Drag_"]').draggable({
         
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         
         
         
         
         
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         
         	function crearInput(){
         		var tipoactividad = "input";
         		var color = sym.getVariable("colorini");
         		var colorok = sym.getVariable("colorok");
         		var colorbad = sym.getVariable("colorbad");
         		var border = sym.getVariable("border");
         		var tamano = sym.getVariable("fontsize");
         		var fontweight = sym.getVariable("fontweight");
         		var fondo = sym.getVariable("fondo");
         		var borderRadius= sym.getVariable("border-radius");
         		var fondook = sym.getVariable("fondook");
         		var fondobad = sym.getVariable("fondobad");
         
         		var nombreElemento = 'Elemento_1';
            	nombreElemento = document.createElement(tipoactividad);
            	nombreElemento.id="seleccion_1";
         	   var anchoInput = sym.$("Input_1").css("width");
            	var altoInput = sym.$("Input_1").css("height");
            	nombreElemento.style.width= anchoInput;	 
            	nombreElemento.style.height= altoInput;
            	nombreElemento.style.fontWeight= "bold";
            	nombreElemento.style.border=  "2px double #cccccc";
            	nombreElemento.style.color= "#666666";
            	nombreElemento.style.background= "rgba(255,255,255,0.50)";
            	nombreElemento.style.fontSize= tamano;;
            	nombreElemento.style.fontFamily= "Cabin";
            	nombreElemento.style.textAlign="center";
            	nombreElemento.style.webkitBorderRadius="5px";
            	nombreElemento.style.mozBorderRadius="5px";
            	nombreElemento.style.borderRadius="5px";
            	sym.$("Input_1").append(nombreElemento);
         
            	$('input').filter_input({					
         		regex:'[0-9]', 
         		events:'keypress paste'});
         	}
         
         	// Funcion para verificar las respuestas de cada drop
         function verificarRespuestas(RespuestaDrop,idActiveDrag){
         	var respDrop=0;
         
         	var idResp = idActiveDrag.slice(11);	
         	var vectorResp = sym.getVariable(RespuestaDrop);	
         	var respTemp = vectorResp.indexOf(parseInt(idResp));
         	if(respTemp != -1){
         		respDrop = 1;
         	}
         	else{
         		respDrop = 0;		
         	}	
         	return respDrop;	
         }
         
         cantidadFiguras = 0;
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 	
         			sym.setVariable("DropVar"+DropId, verificarRespuestas("RespDrop"+DropId,ui.draggable.attr('id')));
               	coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));
               	var DragIdtemp=ui.draggable.attr('id');
               	sym.$("Input_1").empty();
               	crearInput();
         			if(DragIdtemp=="Stage_Drag_1"){
         				sym.$('[id^="Stage_pop"]').hide();
         				sym.$('[id^="Stage_figura"]').hide();
         				sym.$("pop_1").show();
         				sym.$("figura1").show();
         				cantidadFiguras = 6;
         			}else if(DragIdtemp=="Stage_Drag_2"){
         				sym.$('[id^="Stage_pop"]').hide();
         				sym.$('[id^="Stage_figura"]').hide();
         				sym.$("pop_2").show();
         				sym.$("figura2").show();
         				cantidadFiguras = 48;
         			}else if(DragIdtemp=="Stage_Drag_3"){
         				sym.$('[id^="Stage_pop"]').hide();
         				sym.$('[id^="Stage_figura"]').hide();
         				sym.$("pop_3").show();
         				sym.$("figura3").show();
         				cantidadFiguras = 12;
         			}else if(DragIdtemp=="Stage_Drag_4"){
         				sym.$('[id^="Stage_pop"]').hide();
         				sym.$('[id^="Stage_figura"]').hide();
         				sym.$("pop_4").show();
         				sym.$("figura4").show();
         				cantidadFiguras = 24;
         			}
            	}
            });	
         
         //	Copiar la siguiente función para las correcciones del material anterior
         //	Esta función permite que los elementos no se solapen
         
         // Se establece el atributo vacio para todos los elementos droppables
         sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
         
         		 $(".ui-droppable").on( "drop", function( event, ui ) {
         		 	// Verifico el estado del drop (ocupado o vacio)
         					var estadoDrop = $(this).attr("dragelement");
         
         					// 
         					if(estadoDrop != "vacio"){										
         						var numDrag = estadoDrop.slice(11);	
         						var posLeftDrag = sym.getVariable("left"+numDrag);
         						var posTopDrag = sym.getVariable("top"+numDrag);
         						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					} else{
         						var idDraggable = ui.draggable.attr('id');
         						$(this).attr("dragelement",idDraggable);
         					}
         
         		 } );
         
         		 $(".ui-droppable").droppable({	
         				out: function( event, ui ){ 
         					var estadoDrop = $(this).attr("dragelement");
         					var idDraggable = ui.draggable.attr('id');
         					if(estadoDrop == idDraggable ){	
         						$(this).attr("dragelement","vacio");					
         					}
         					else{						
         					}
         				}
         		 });
         
         
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
             };
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         var Total = 0;
         
         var estadoDrop = $("#Stage_Drop_1").attr("dragelement").slice(11);
         var valorInput = $("#seleccion_1").val();
         
         $("#seleccion_1").css("pointer-events","none");
         
         
         if(estadoDrop == 1 && valorInput==6){
         	Total = 1;
         }
         if(estadoDrop == 2 && valorInput==48){
         	Total = 1;
         }
         if(estadoDrop == 3 && valorInput==12){
         	Total = 1;
         }
         if(estadoDrop == 4 && valorInput==24){
         	Total = 1;
         }
         
         /*
         for(var k=1;k<=TotalDropElements;k++){
         	var DropVar = sym.getVariable("DropVar"+k);
         	Total = Total + DropVar;
         	if(DropVar==1){
         		sym.$("Drop_"+k).css({background: fondook})
         	}
         	else{
         		sym.$("Drop_"+k).css({background: fondobad});
         	}
         }
         */
         
         
         // Deshabilito todos los drag mientras se validan los datos en la actividad
         sym.$('[id^="Stage_Drag_"]').draggable({
         	disabled:true
         });
         
         //Muestra las leyendas
         if(Total==TotalDropElements){
         	sym.$("resp_correcta").show();
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	$("#seleccion_1").css("background-color",fondook);
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	$("#seleccion_1").css("background-color",colorbad);
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         sym.$('[id^="Stage_pop"]').hide();
         sym.$('[id^="Stage_figura"]').hide();
         sym.$("Input_1").empty();
         crearInput();
         $("#seleccion_1").css("pointer-events","none");
         $("#seleccion_1").val("6");
         sym.$("pop_1").show();
         sym.$("figura1").show();
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         
         var leftDrag = [];
         var topDrag = [];
         
         for (var h=1; h<=TotalDragElements; h++){
         	leftDrag[h] = sym.getVariable("left"+h);
         	topDrag[h] = sym.getVariable("top"+h);
         }
         
         var devueltos= TotalDropElements+1;
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.$("Drag_"+i).animate({top: topDrag[i], left: leftDrag[i]},50);
         }
         
         for(var i=1; i<=TotalDropElements; i++){
         	var vectorResp = sym.getVariable("RespDrop"+i);
         	var firstResp = vectorResp[0];
         	sym.$("Drag_"+firstResp).css({top: topDrag[i], left: leftDrag[i]});
         	coordenadas("Drop_"+i, "Drag_"+firstResp);
         	sym.$("Drop_"+i).css({background: fondook});
         }
         
         
         function coordenadas (Drop, simbolo) {
         	varxdrop = sym.$(Drop).css("left");
         	varydrop = sym.$(Drop).css("top");
         	varxdropanch = sym.$(Drop).css("width");
         	varydropalto = sym.$(Drop).css("height");
         	varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
         	varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
         	varxdraganch = sym.$(simbolo).css("width");
         	varydragalto = sym.$(simbolo).css("height");
         	varxdragcentro = parseInt(varxdraganch)/2;
         	varydragcentro = parseInt(varydragalto)/2;
         	sym.$(simbolo).animate({top: varydropcentro-varydragcentro, left: varxdropcentro-varxdragcentro},150);
         };
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$('[id^="Stage_pop"]').hide();
         sym.$('[id^="Stage_figura"]').hide();
         sym.$("Input_1").empty();
         //crearInput();
         
         sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(var i=1; i<=TotalDragElements; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         	sym.$("Drag_"+i).draggable ({
         		disabled: false
         	});
         	//sym.$("Drop_"+i).css({color: colorini ,background: fondoini});
         	sym.setVariable("DropVar"+i, 0);
         }
         
         sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-1010687330");