/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 8;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 3;
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
         sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         
         
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			if(contadorCubos <= 20){
         		 			contadorCubos++;
         					$("#Stage_Cubo_"+contadorCubos).show();
         					$("#Stage_cantidadCubos").html(contadorCubos);
         					if(contadorCubos==20){
         						sym.$('[id^="Stage_Drag_"]').css("pointer-events","none");
         					}
         			}	
            	}
            });
         
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         contadorCubos = 0;
         
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         var Total = 0;
         
         sym.$('[id^="Stage_Drag_"]').css("pointer-events","none");
         // Deshabilito todos los drag mientras se validan los datos en la actividad
         sym.$('[id^="Stage_Drag_"]').draggable({
         	disabled:true
         });
         
         //Muestra las leyendas
         if(contadorCubos==20){
         	sym.$("resp_correcta").show();
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	//sym.$("Drop_1").css({background: fondook})
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	//sym.$("Drop_1").css({background: fondobad})
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$('[id^="Stage_Drag_"]').css("pointer-events","none");
         $(".cubos").fadeIn("fast");
         $("#Stage_cantidadCubos").html("20");
         
         
         
         function coordenadas (Drop, simbolo) {
         	varxdrop = sym.$(Drop).css("left");
         	varydrop = sym.$(Drop).css("top");
         	varxdropanch = sym.$(Drop).css("width");
         	varydropalto = sym.$(Drop).css("height");
         	varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
         	varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
         	varxdraganch = sym.$(simbolo).css("width");
         	varydragalto = sym.$(simbolo).css("height");
         	varxdragcentro = parseInt(varxdraganch)/2;
         	varydragcentro = parseInt(varydragalto)/2;
         	sym.$(simbolo).animate({top: varydropcentro-varydragcentro, left: varxdropcentro-varxdragcentro},150);
         };
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         sym.$('[id^="Stage_Drag_"]').css("pointer-events","auto");
         contadorCubos = 0;
         $("#Stage_cantidadCubos").html(contadorCubos);
         $(".cubos").fadeOut("fast");
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(var i=1; i<=TotalDragElements; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         	sym.$("Drag_"+i).draggable ({
         		disabled: false
         	});
         	//sym.$("Drop_"+i).css({color: colorini ,background: fondoini});
         	sym.setVariable("DropVar"+i, 0);
         }
         
         //sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-1010687330");