/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         colorPaint = "rgba(255,217,0,0)";
         
         $(".elementos").click(function(){
         	var idElemento = $(this).attr("id").slice(6);
         	$("#Stage_fondo_"+idElemento).css("background-color",colorPaint);
         });
         
         $(".colores").click(function(){
         	var colorSeleccionado = $(this).attr("id").slice(12);
         	$("[id^=Stage_color_]").css("border","none");
         	$("[id^=Stage_color_]").css("box-shadow","none");
         	$("#Stage_color_"+colorSeleccionado).css("border","2px dotted gray");
         	$("#Stage_color_"+colorSeleccionado).css("box-shadow","1px 3px 5px #000000");
         	switch(colorSeleccionado){
         		case "amarillo":
         			colorPaint = "rgba(255,217,0,1.00)";
         			break;
         		case "rojo":
         			colorPaint = "rgba(232,46,38,1.00)";
         			break;
         		case "azul":
         			colorPaint = "rgba(0,126,201,1.00)";
         			break;
         		case "verde":
         			colorPaint = "rgba(108,192,20,1.00)";
         			break;
         		case "morado":
         			colorPaint = "rgba(140,82,201,1.00)";
         			break;
         		case "cafe":
         			colorPaint = "rgba(183,116,68,1.00)";
         			break;	
         		default:
         			colorPaint = "rgba(255,217,0,0)";
         	}
         });
         
         //ocultar ayuda
         	sym.$('[id^="Stage_help"]').click(function(){
              	$(this).hide();
              	sym.getSymbol("bt_ayuda").stop("normal");
            });
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         colorPaint = "rgba(255,217,0,0)";
         $(".fondo").css("background-color",colorPaint);
         $("[id^=Stage_color_]").css("border","none");
         $("[id^=Stage_color_]").css("box-shadow","none");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_colorear").is(":visible")) {
         	sym.$("help_colorear").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_colorear").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'flecha_bt'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("flecha_bt");
   //Edge symbol end:'flecha_bt'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
            // enable button/link
         });
         
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion);
         // Definir un conmutador para reproducir o pausar una pista de audio 
         if (sym.getComposition().getStage().$(soundId)[0].paused) {
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.getComposition().getStage().$(soundId)[0].volume=0.7;
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

   })("bt_audio");
   //Edge symbol end:'bt_audio'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-94063035");