/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         for(var i=1; i<=12; i++){
         	sym.setVariable("left"+i, $("#Stage_Drag_"+i).css("left"));
         	sym.setVariable("top"+i, $("#Stage_Drag_"+i).css("top"));
         }
         
         //Centrar el cursor en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
          $(".imagenes").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage', 		
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,			
         			scroll:false,
         			revertDuration: 500,
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
             });
         
         
         
         
         	sym.$('#Stage_Drop_1').droppable({
         		drop: function( event, ui ){			
            	}
            });	
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.getSymbol("bt_ayuda").stop("normal");
         
         sym.$("hotspot_reiniciar").show();
         sym.$("hotspot_ayuda").show();
         
         $("#Stage_resp_correcta").css("zIndex","1000");
         $("#Stage_resp_incorrecta").css("zIndex","1001");
         $("#Stage_help").css("zIndex","1002");
         
         	margenIzq = 5;
         	counter = 0;
         
             $("#Stage_Drop_1").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter++;   
         
                         if(counter < 8){                            
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv" + counter);
                         	$("#clonediv" + counter).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1
                         	var posIzqRecp1 = $("#Stage_Drop_1").css("left");
                         	var posTopRecp1 = $("#Stage_Drop_1").css("top");                
         
                         	$("#clonediv" + counter).addClass(itemDragged);                 	
         
                         	if(counter <= 7){                            
         	                	$("#clonediv" + counter).css({opacity:"1",top: "0px", left:  margenIzq});       
                         		margenIzq=margenIzq + 105;       
                         	}                	     	
                         }
                     }
                 }
         
         
             });
         
            margenIzq2 = 5;
         	counter2 = 0;
         
             $("#Stage_Drop_2").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter2++;   
         
                         if(counter2 < 8){                            
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv2" + counter2);
                         	$("#clonediv2" + counter2).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1
                         	var posIzqRecp1 = $("#Stage_Drop_2").css("left");
                         	var posTopRecp1 = $("#Stage_Drop_2").css("top");                
         
                         	$("#clonediv2" + counter2).addClass(itemDragged);                 	
         
                         	if(counter2 <= 7){                            
         	                	$("#clonediv2" + counter2).css({opacity:"1",top: "0px", left:  margenIzq2});       
                         		margenIzq2=margenIzq2 + 105;       
                         	}                	     	
                         }
                     }
                 }
         
         
             });
         
         
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         
         	sym.getSymbol("bt_reiniciar").stop("normal");	
         	sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         
         $("[class*='dragged']").remove();
         margenIzq = 5;
         counter = 0;
         margenIzq2 = 5;
         counter2 = 0;
         
         
         $("#Stage_Drop_1").children("div").appendTo("#Stage");
         $("#Stage_Drop_2").children("div").appendTo("#Stage");
         
         for(var i=1; i<=12; i++){
         	var topDrag_ = sym.getVariable("top"+i);
         	var leftDrag_ = sym.getVariable("left"+i);
         	$("#Stage_Drag_"+i).css({top: topDrag_, left: leftDrag_});
         	$("#Stage_Drag_"+i).draggable ({
         		disabled: false
         	});
         }
         
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-1010687330");