/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 1;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 3;
         
         
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
          $(".argollas").draggable({
         	      helper: 'clone',
               	appendTo: "body",
               	containment: '#Stage', 		
         			iframeFix: true,
         			zIndex: 100,	
         			refreshPositions: true,			
         			scroll:false,
         			revertDuration: 500,
         			stop: function() {
         				$("#Stage_Numero").show();
         				$("#Stage_TextArea_1").show();
         			},
         			helper: function() {
         			var escalaTemp = $('#Stage').css('transform');
         			var escala = matrixToArray(escalaTemp);
               	var helper = $(this).clone(); 
               	helper.css({
             			"transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-ms-transform":"scale("+escala+")",
             			"-webkit-transform":"scale("+escala+")",
             			"-moz-transform":"scale("+escala+")",
             			"-o-transform":"scale("+escala+")",
             			"-moz-transform-origin":"left top",
         				"-webkit-transform-origin":"left top",
         				"-o-transform-origin":"left top",
         				"-ms-transform-origin":"left top",
             		});        
               	return helper;
           		}
             });
         
         /*
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 	
         			sym.setVariable("DropVar"+DropId, verificarRespuestas("RespDrop"+DropId,ui.draggable.attr('id')));
               	coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));	
            	}
            });	
            */
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         sym.$("hotspot_ayuda").show();
         
         //	Copiar la siguiente función para las correcciones del material anterior
         //	Esta función permite que los elementos no se solapen
         
         // Se establece el atributo vacio para todos los elementos droppables
         	counter = 0;
         	posicionDrag=0;
         	numeroAbaco=0;
         
             $("#Stage_Drop_1").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter++;   					 
                         if(counter < 10){                            
                         numeroAbaco=numeroAbaco+100000;
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv" + counter);
                         	$("#clonediv" + counter).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1          
         
                         	$("#clonediv" + counter).addClass(itemDragged);                 	
         						switch(counter){
                					case 1:	posicionDrag=315; 
                					break;
         							case 2:	posicionDrag=277;
                					break;
                					case 3:	posicionDrag=239;
                					break;
         							case 4:	posicionDrag=201;
                					break;
                					case 5:	posicionDrag=163;
                					break;
         							case 6:	posicionDrag=125;
                					break;
                					case 7:	posicionDrag=87;
                					break;
         							case 8:	posicionDrag=49;
                					break;
                					case 9:	posicionDrag=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv" + counter).css({top: 0, left: 0});
                				$("#clonediv" + counter).animate({top: posicionDrag, left: 0},500);       							             	  	
                         }
                     }
                     $("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
            counter2 = 0;
         	posicionDrag2=0;
         
         	$("#Stage_Drop_2").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter2++;   
         
                         if(counter2 < 10){                            
                         numeroAbaco=numeroAbaco+10000;
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv2" + counter2);
                         	$("#clonediv2" + counter2).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1            
         
                         	$("#clonediv2" + counter2).addClass(itemDragged);                 	
         						switch(counter2){
                					case 1:	posicionDrag2=315;
                					break;
         							case 2:	posicionDrag2=277;
                					break;
                					case 3:	posicionDrag2=239;
                					break;
         							case 4:	posicionDrag2=201;
                					break;
                					case 5:	posicionDrag2=163;
                					break;
         							case 6:	posicionDrag2=125;
                					break;
                					case 7:	posicionDrag2=87;
                					break;
         							case 8:	posicionDrag2=49;
                					break;
                					case 9:	posicionDrag2=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag2, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv2" + counter2).css({top: 0, left: 0});
                				$("#clonediv2" + counter2).animate({top: posicionDrag2, left: 0},500);       							             	  	
                         }
                     }
                     $("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
            counter3 = 0;
         	posicionDrag3=0;
         
             $("#Stage_Drop_3").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter3++;   
         
                         if(counter3 < 10){                            
                         numeroAbaco=numeroAbaco+1000;
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv3" + counter3);
                         	$("#clonediv3" + counter3).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1             
         
                         	$("#clonediv3" + counter3).addClass(itemDragged);                 	
         						switch(counter3){
                					case 1:	posicionDrag3=315;
                					break;
         							case 2:	posicionDrag3=277;
                					break;
                					case 3:	posicionDrag3=239;
                					break;
         							case 4:	posicionDrag3=201;
                					break;
                					case 5:	posicionDrag3=163;
                					break;
         							case 6:	posicionDrag3=125;
                					break;
                					case 7:	posicionDrag3=87;
                					break;
         							case 8:	posicionDrag3=49;
                					break;
                					case 9:	posicionDrag3=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag3, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv3" + counter3).css({top: 0, left: 0});
                				$("#clonediv3" + counter3).animate({top: posicionDrag3, left: 0},500);       							             	  	
                         }
                     }
                     $("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
         	counter4 = 0;
         	posicionDrag4=0;
         
             $("#Stage_Drop_4").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter4++;   
         
                         if(counter4 < 10){     
                         numeroAbaco=numeroAbaco+100;                       
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv4" + counter4);
                         	$("#clonediv4" + counter4).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1                	              
         
                         	$("#clonediv4" + counter4).addClass(itemDragged);                 	
         						switch(counter4){
                					case 1:	posicionDrag4=315;
                					break;
         							case 2:	posicionDrag4=277;
                					break;
                					case 3:	posicionDrag4=239;
                					break;
         							case 4:	posicionDrag4=201;
                					break;
                					case 5:	posicionDrag4=163;
                					break;
         							case 6:	posicionDrag4=125;
                					break;
                					case 7:	posicionDrag4=87;
                					break;
         							case 8:	posicionDrag4=49;
                					break;
                					case 9:	posicionDrag4=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag4, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv4" + counter4).css({top: 0, left: 0});
                				$("#clonediv4" + counter4).animate({top: posicionDrag4, left: 0},500);       							             	  	
                         }
                     }
                     $("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
             counter5 = 0;
         	posicionDrag5=0;
         
             $("#Stage_Drop_5").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter5++;                   
         
                         if(counter5 < 10){                            
                         numeroAbaco=numeroAbaco+10;
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv5" + counter5);
                         	$("#clonediv5" + counter5).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1                	              
         
                         	$("#clonediv5" + counter5).addClass(itemDragged);                 	
         						switch(counter5){
                					case 1:	posicionDrag5=315;
                					break;
         							case 2:	posicionDrag5=277;
                					break;
                					case 3:	posicionDrag5=239;
                					break;
         							case 4:	posicionDrag5=201;
                					break;
                					case 5:	posicionDrag5=163;
                					break;
         							case 6:	posicionDrag5=125;
                					break;
                					case 7:	posicionDrag5=87;
                					break;
         							case 8:	posicionDrag5=49;
                					break;
                					case 9:	posicionDrag5=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag5, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv5" + counter5).css({top: 0, left: 0});
                				$("#clonediv5" + counter5).animate({top: posicionDrag5, left: 0},500);       							             	  	
                         }
                     }
                     $("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
             counter6 = 0;
         	posicionDrag6=0;
         
             $("#Stage_Drop_6").droppable({
                 drop: function (ev, ui) {
                     if ($(ui.helper).attr('id').search(/Drag_[0-9]/) != -1) {
                         counter6++;                 
         
                         if(counter6 < 10){                            
                         numeroAbaco++; 
                         	var element = $(ui.draggable).clone();
                         	element.addClass("tempclass");
                         	$(this).append(element);
                         	$(".tempclass").attr("id", "clonediv6" + counter6);
                         	$("#clonediv6" + counter6).removeClass("tempclass");
                         	//Get the dynamically item id
                         	draggedNumber = $(ui.helper).attr('id').search(/Drag_([0-9])/)
                         	itemDragged = "dragged" + RegExp.$1                	              
         
                         	$("#clonediv6" + counter6).addClass(itemDragged);                 	
         						switch(counter6){
                					case 1:	posicionDrag6=315;
                					break;
         							case 2:	posicionDrag6=277;
                					break;
                					case 3:	posicionDrag6=239;
                					break;
         							case 4:	posicionDrag6=201;
                					break;
                					case 5:	posicionDrag6=163;
                					break;
         							case 6:	posicionDrag6=125;
                					break;
                					case 7:	posicionDrag6=87;
                					break;
         							case 8:	posicionDrag6=49;
                					break;
                					case 9:	posicionDrag6=11;
                					break;							
                				}			        				
                				//sym.$(simbolo).animate({top: posicionDrag6, left: varxdropcentro-varxdragcentro},400);
                				$("#clonediv6" + counter6).css({top: 0, left: 0});
                				$("#clonediv6" + counter6).animate({top: posicionDrag6, left: 0},500);       							             	  	
                         }
                     }
         				$("#Stage_Numero").html(numeroAbaco);
                 }
             });
         
         	 sym.setVariable("border", "2px double #cccccc");		// Modifica el borde del input
         			sym.setVariable("fondo", "rgba(255,255,255,0.5)");	// Modifica el color de fondo del input
         			sym.setVariable("colorini", "#666666");					// Editar el color de la letra 
         			sym.setVariable("colorok", "#666666");
         			sym.setVariable("fondook","rgba(169,194,88,0.80)");
         			sym.setVariable("colorbad", "#ffffff");
         			sym.setVariable("fondobad", "#f3716c");
         			sym.setVariable("fontsize", "26px");						// Editar el tamaño de fuente
         			sym.setVariable("fontFamily", "Cabin");					//	Editar el tipo de fuente
         			sym.setVariable("fontStyle", "normal");				
         			sym.setVariable("fontweight", "bold");
         			sym.setVariable("height", "auto");
         			sym.setVariable("border-radius", "5px");
         			sym.setVariable("alineacionTexto", "center");		
         
             // Creación de las áreas de texto en la actividad
         			TotalTextArea = 1;			// Numero de áreas de texto
                  var color = sym.getVariable("colorini");
                  var border = sym.getVariable("border");
                  var tamano = sym.getVariable("fontsize");
                  var fontweight = sym.getVariable("fontweight");
                  var fondo = sym.getVariable("fondo");
                  var borderRadius= sym.getVariable("border-radius");
                  var textAlign= sym.getVariable("textAlign");         
         
                  // Agregar las áreas de texto dinámicamente
                  for (i=1 ; i<= TotalTextArea; i++){
                  sym.$("TextArea_"+i).css("background","rgba(255,255,255,0.0)");
                  	var nombreElemento = 'Elemento_'+i;
                  	nombreElemento = document.createElement("textarea");
                  	nombreElemento.id="textarea_"+i;
                  	var anchoTextArea = sym.$("TextArea_"+i).css("width");
                  	var altoTextArea = sym.$("TextArea_"+i).css("height");
                  	/*
                  	nombreElemento.style.width= anchoTextArea;	 
                  	nombreElemento.style.height= altoTextArea;
                  	*/
                  	nombreElemento.rows = "4";
                  	nombreElemento.cols = "22";
                  	nombreElemento.style.border= border;
                  	nombreElemento.style.color= color;
                  	nombreElemento.style.background= fondo;
                  	nombreElemento.style.fontSize= tamano;
                  	nombreElemento.style.fontWeight= fontweight;
                  	nombreElemento.style.textAlign= textAlign;
                  	nombreElemento.style.webkitBorderRadius=borderRadius;
                  	nombreElemento.style.mozBorderRadius=borderRadius;
                  	nombreElemento.style.borderRadius=borderRadius;
                  	nombreElemento.style.padding= "10px";
         				nombreElemento.style.resize= "none";
                  	sym.$("TextArea_"+i).append(nombreElemento);
                  }
         
         
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         $("[class*='dragged']").remove();
         
         counter = 0;
         counter2 = 0;
         counter3 = 0;
         counter4 = 0;
         counter5 = 0;
         counter6 = 0;
         posicionDrag = 0;
         posicionDrag2 = 0;
         posicionDrag3 = 0;
         posicionDrag4 = 0;
         posicionDrag5 = 0;
         posicionDrag6 = 0;
         numeroAbaco = 0;
         $("#Stage_Numero").hide();
         $("#Stage_TextArea_1").hide();
         $("#Stage_Numero").html(numeroAbaco);
         $("#textarea_1").val("");
         
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondoini");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(var i=1; i<=TotalDragElements; i++){
         	var topDrag = sym.getVariable("top"+i);
         	var leftDrag = sym.getVariable("left"+i);
         	sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         	sym.$("Drag_"+i).draggable ({
         		disabled: false
         	});
         	//sym.$("Drop_"+i).css({color: colorini ,background: fondoini});
         	sym.setVariable("DropVar"+i, 0);
         }
         
         sym.$('[id^="Stage_Drop_"]').css({background: fondoini});
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'abaco1'
   (function(symbolName) {   
   
   })("abaco1");
   //Edge symbol end:'abaco1'

})(jQuery, AdobeEdge, "EDGE-1010687330");