/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         /*
         			RESPUESTA
         			Determino las casillas que van coloreadas con el valor 1 
         			y con valor en 0 cuando la casilla no esta marcada en la gráfica			
         		*/
         		aResp = [1,0,0,0,0,0,0,0,0,0,0,0];		// Respuesta Columna a
         		bResp = [1,1,0,0,0,0,0,0,0,0,0,0];		// Respuesta Columna b
         		cResp = [1,1,1,0,0,0,0,0,0,0,0,0];		// Respuesta Columna c
         		dResp = [1,1,1,1,0,0,0,0,0,0,0,0];		// Respuesta Columna d	
         
         		/*
         			Inicializo los valores de cada columna en la gráfica
         			para comparar los valores al momento de validar
         		*/
         		aResp2 = [0,0,0,0,0,0,0,0,0,0,0,0,0];
         		bResp2 = [0,0,0,0,0,0,0,0,0,0,0,0,0];
         		cResp2 = [0,0,0,0,0,0,0,0,0,0,0,0,0];
         		dResp2 = [0,0,0,0,0,0,0,0,0,0,0,0,0];		
         
         		// Asignar los colores a cada columna	
         		var colorColumnaA = "#e01714";	//rojo
         		var colorColumnaB = "#527EFF";	//azul
         		var colorColumnaC = "#56C830";	//verde
         		var colorColumnaD = "#FFA237";	//naranja
         		var colorColumnaE = "#FFD640";	//amarillo
         
         
         $(".cuadros").click(function(){
         		idBox = $(this).attr("id").slice(6);		
         			Bx = idBox.split("-");			
         			if(Bx[0]=='A'){
         				var acolor=$("#Stage_"+idBox).css("background-color");				
         				if(acolor == "rgba(255, 255, 255, 0)"){					
         					$("#Stage_"+idBox).css("background-color",colorColumnaA);	
         					aResp2[Bx[1]-1] = 1;				
         				}else{
         					$("#Stage_"+idBox).css("background-color","rgba(255, 255, 255, 0)");						
         					aResp2[Bx[1]-1] = 0;				
         				}
         			}
         			if(Bx[0]=='B'){
         				var bcolor=$("#Stage_"+idBox).css("background-color");
         				if(bcolor == "rgba(255, 255, 255, 0)"){
         					$("#Stage_"+idBox).css("background-color",colorColumnaA);
         					bResp2[Bx[1]-1] = 1;	
         				}else{
         					$("#Stage_"+idBox).css("background-color","rgba(255, 255, 255, 0)");	
         					bResp2[Bx[1]-1] = 0;	
         				}
         			}
         			if(Bx[0]=='C'){
         				var ccolor=$("#Stage_"+idBox).css("background-color");
         				if(ccolor == "rgba(255, 255, 255, 0)"){
         					$("#Stage_"+idBox).css("background-color",colorColumnaA);
         					cResp2[Bx[1]-1] = 1;	
         				}else{
         					$("#Stage_"+idBox).css("background-color","rgba(255, 255, 255, 0)");	
         					cResp2[Bx[1]-1] = 0;	
         				}
         			}
         			if(Bx[0]=='D'){
         				var dcolor=$("#Stage_"+idBox).css("background-color");
         				if(dcolor == "rgba(255, 255, 255, 0)"){
         					$("#Stage_"+idBox).css("background-color",colorColumnaA);
         					dResp2[Bx[1]-1] = 1;	
         				}else{
         					$("#Stage_"+idBox).css("background-color","rgba(255, 255, 255, 0)");	
         					dResp2[Bx[1]-1] = 0;	
         				}
         			}			
         });
         
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         $(".cuadros").css("pointer-events","none");
         
         var totalBox = 4;
         
         	for (var i=0;i<totalBox; i++){
         		if(aResp[i]!=aResp2[i]){
         			var error = 1;
         		}
         		if(bResp[i]!=bResp2[i]){
         			var error = 1;
         		}
         		if(cResp[i]!=cResp2[i]){
         			var error = 1;
         		}
         		if(dResp[i]!=dResp2[i]){
         			var error = 1;
         		}
         	}
         
         //Muestra las leyendas
         if (error != 1){
         	sym.$("resp_correcta").show();
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         $(".cuadros").css("pointer-events","none");
         $(".cuadros").css("background-color","rgba(255, 255, 255, 0)");	
         
         			for (var i=0;i<4; i++){
         				var j=i+1;
         				if(aResp[i]==1){
         					$("#Stage_A-"+j).css("background-color",colorColumnaA);		
         				}
         				if(bResp[i]==1){
         					$("#Stage_B-"+j).css("background-color",colorColumnaA);		
         				}
         				if(cResp[i]==1){
         					$("#Stage_C-"+j).css("background-color",colorColumnaA);		
         				}
         				if(dResp[i]==1){
         					$("#Stage_D-"+j).css("background-color",colorColumnaA);		
         				}				
         			}
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         $(".cuadros").css("pointer-events","auto");
         
         	aResp2 = [0,0,0,0,0,0,0,0,0,0,0,0];
         	bResp2 = [0,0,0,0,0,0,0,0,0,0,0,0];
         	cResp2 = [0,0,0,0,0,0,0,0,0,0,0,0];
         	dResp2 = [0,0,0,0,0,0,0,0,0,0,0,0];
         
         
         $(".cuadros").css("background-color","rgba(255, 255, 255, 0)");	
         
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-1010687330");