/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 8;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 3;
         
         // Determino las respuestas correctas para cada drop en la actividad
         var dontTouch = 0;
         var Rd1 = new Array(1,dontTouch); 
         sym.setVariable("RespDrop1", Rd1);
         var Rd2 = new Array(2,3,dontTouch); 
         sym.setVariable("RespDrop2", Rd2);
         var Rd3 = new Array(3,dontTouch); 
         sym.setVariable("RespDrop3", Rd3);
         var Rd4 = new Array(4,dontTouch); 
         sym.setVariable("RespDrop4", Rd4);
         var Rd5 = new Array(5,dontTouch); 
         sym.setVariable("RespDrop5", Rd5);
         var Rd6 = new Array(6,dontTouch); 
         sym.setVariable("RespDrop6", Rd6);
         var Rd7 = new Array(7,dontTouch); 
         sym.setVariable("RespDrop7", Rd7);
         var Rd8 = new Array(8,dontTouch); 
         sym.setVariable("RespDrop8", Rd8);
         var Rd9 = new Array(9,dontTouch); 
         sym.setVariable("RespDrop9", Rd9);
         var Rd10 = new Array(10,dontTouch); 
         sym.setVariable("RespDrop10", Rd10);
         
         // Funcion para verificar las respuestas de cada drop
         function verificarRespuestas(RespuestaDrop,idActiveDrag){
         	var respDrop=0;
         
         	var idResp = idActiveDrag.slice(11);	
         	var vectorResp = sym.getVariable(RespuestaDrop);	
         	var respTemp = vectorResp.indexOf(parseInt(idResp));
         	if(respTemp != -1){
         		respDrop = 1;
         	}
         	else{
         		respDrop = 0;		
         	}	
         	return respDrop;	
         }
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         for(var i=1; i<=50; i++){
            sym.setVariable("DropVar"+i, 0); 
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
          sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         
         
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 	
         			sym.setVariable("DropVar"+DropId, verificarRespuestas("RespDrop"+DropId,ui.draggable.attr('id')));
               	coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));	
            	}
            });	
         
             function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");
                varxdropcentro = parseInt(varxdrop) + parseInt(varxdropanch)/2;
                varydropcentro = parseInt(varydrop) + parseInt(varydropalto)/2;
                varxdraganch = sym.$(simbolo).css("width");
                varydragalto = sym.$(simbolo).css("height");
                varxdragcentro = parseInt(varxdraganch)/2;
                varydragcentro = parseInt(varydragalto)/2;
                sym.$(simbolo).css({top: varydropcentro-varydragcentro});
                sym.$(simbolo).css({left: varxdropcentro-varxdragcentro});
                };
         
         
         
         

      });
      //Edge binding end

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         colorPincel="white";
         
         $(".colores").css("cursor","pointer");
         
         $(".colores").click(function(){
         	$(".colores").css({"border":"none","background-color":"rgba(255,255,255,0)"});
         	$(this).css({"border":"2px dashed red","background-color":"rgba(255,255,255,0.46)"});
         	idColor = $(this).prop("id").slice(12);
         	switch(idColor){
         		case "1":
         			colorPincel = "rgba(110,194,14,1.00)";
         			break;
         		case "2":
         			colorPincel = "rgba(145,74,187,1.00)";
         			break;
         		case "3":
         			colorPincel = "rgba(255,209,0,1.00)";
         			break;
         		case "4":
         			colorPincel = "rgba(0,164,255,1.00)";
         			break;
         	}	
         });
         
         $(".globos").click(function(){
         	var idGlobo = $(this).prop("id");		
         	$("#"+idGlobo).css("background-color",colorPincel);
         	switch(idColor){
         		case "1":			
         			$("#"+idGlobo).attr("color","verde");
         			break;
         		case "2":			
         			$("#"+idGlobo).attr("color","morado");
         			break;
         		case "3":			
         			$("#"+idGlobo).attr("color","amarillo");
         			break;
         		case "4":			
         			$("#"+idGlobo).attr("color","azul");
         			break;
         	}	
         });
         
         
         //BOTÓN VALIDAR
         sym.$('hotspot_validar').click(function(){
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         
         $(".globos").css("pointer-events","none");
         $(".colores").css("pointer-events","none");
         
         var totalVerdes = $("div[color='verde']").length;
         var totalMorados = $("div[color='morado']").length;
         var totalAmarillos = $("div[color='amarillo']").length;
         var totalAzules = $("div[color='azul']").length;
         
         //Muestra las leyendas
         if(totalVerdes==3 && totalMorados==1 && totalAmarillos==4 && totalAzules==2){
         	sym.$("resp_correcta").show();
         	setTimeout('$("#Stage_resp_correcta").fadeOut("slow");', 2500);
         	//audio correcto
         	sym.$("success")[0].play();
         	sym.$("success")[0].muted = false;
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();	
         }
         else{
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	setTimeout('$("#Stage_resp_incorrecta").fadeOut("slow");', 2500);
         	//audio incorrecto
         	sym.$("error")[0].play();
         	sym.$("error")[0].muted = false;
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         
         
         });
         //BOTÓN SOLUCIÓN
         sym.$('hotspot_solucion').click(function(){
         
         //botones
         sym.getSymbol("bt_validar").stop("down");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("normal");
         sym.$("hotspot_validar").hide();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").show();
         
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         $(".globos").css("pointer-events","none");
         $(".colores").css("pointer-events","none");
         colorPincel="white";
         $(".colores").css({"border":"none","background-color":"rgba(255,255,255,0)"});
         $(".globos").css({"background-color":"rgba(255,255,255,1)"});
         $(".globos").removeAttr("color");
         
         var colorPincel1 = "rgba(110,194,14,1.00)";
         var colorPincel2 = "rgba(145,74,187,1.00)";
         var colorPincel3 = "rgba(255,209,0,1.00)";		
         var colorPincel4 = "rgba(0,164,255,1.00)";
         
         $("#Stage_globo1").css("background-color",colorPincel1);
         $("#Stage_globo2").css("background-color",colorPincel1);
         $("#Stage_globo3").css("background-color",colorPincel1);
         $("#Stage_globo4").css("background-color",colorPincel2);
         $("#Stage_globo5").css("background-color",colorPincel3);
         $("#Stage_globo6").css("background-color",colorPincel3);
         $("#Stage_globo7").css("background-color",colorPincel3);
         $("#Stage_globo8").css("background-color",colorPincel3);
         $("#Stage_globo9").css("background-color",colorPincel4);
         $("#Stage_globo10").css("background-color",colorPincel4);
         
         });
         //BOTÓN REINICIAR
         sym.$('hotspot_reiniciar').click(function(){
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         $(".globos").css("pointer-events","auto");
         $(".colores").css("pointer-events","auto");
         colorPincel="white";
         $(".colores").css({"border":"none","background-color":"rgba(255,255,255,0)"});
         $(".globos").css({"background-color":"rgba(255,255,255,1)"});
         $(".globos").removeAttr("color");
         
         });
         
         //BOTÓN AYUDA
         sym.$('hotspot_ayuda').click(function(){
         // Definir un conmutador para ocultar o mostrar un elemento 
         if (sym.$("help").is(":visible")) {
         	sym.$("help").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         
         
         });
         // AYUDA
         sym.$('help').click(function(){
         sym.$("help").hide();
         sym.getSymbol("bt_ayuda").stop("normal");
         });
         
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================
   
   //Edge symbol: 'nino'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         // introducir código aquí
         sym.play("INI");

      });
      //Edge binding end

   })("nino");
   //Edge symbol end:'nino'

   //=========================================================
   
   //Edge symbol: 'CABEZA'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         // introducir código aquí
         sym.play("INI");

      });
      //Edge binding end

   })("CABEZA");
   //Edge symbol end:'CABEZA'

})(jQuery, AdobeEdge, "EDGE-1010687330");