
function init(){
    $('.fraction').each(function(key, value) {
        $this = $(this)
        var split = $this.html().split("/")
        if( split.length == 2 ){
            $this.html('<span class="top">'+split[0]+'</span><span class="bottom">'+split[1]+'</span>')
        }    
    });
    divImgPopUp();
}


// Validation of input groups
// initValidarSelects(1, results=["1","casa"]);
function validarEjercicio(groupKey, rs){

    var errorInForm = 0;

    // Grupo de validacion
    groupKey  = (typeof groupKey === "undefined") ? 1 : groupKey;
    inputs = $('input[type="text"][groupKey="'+ groupKey +'"]');

    inputs.each(function(){
        var  key =  $(this).attr('keyValue'); // key to answer
        var  val =  $(this).val(); // key to answer
        val=val.toLowerCase().replace(/ /g,'');;
        var divResultado = $('div.resultado[keyValue="'+key+'"][groupKey='+groupKey+']');

        //Decimal symbol unification
        val=val.replace(/./g,',');
        rs[key]=rs[key].replace(/./g,',');

        if ( val === rs[key] ){ //  No error
            if(divResultado.length){ // Div for feedback
                divResultado.removeClass('bgError');
                divResultado.addClass('bgAcierto');
            }
            else{ // There's no div so color the input
                $(this).css({ 'background-color': 'rgb(191, 227, 197);','color' : '#8E8E8E' });
            }
        }
        else{
            if(divResultado.length){ // Div with feedback 
                divResultado.addClass('bgError');
                divResultado.removeClass('bgAcierto');
            }
            else{ // There's no div so color the input
                $(this).css({ 'background-color': 'rgb(255, 208, 208);','color' : '#8E8E8E' });
            }

            $(this).val('');
            errorInForm ++;
        }

    });

    if(errorInForm == 0){
        var popOk  = $('#btPopOk');
        if( popOk.length >0 ){
            popOk.trigger('click');
        }
        else{ // Pop up error
            sg.sound('success-low');
        }
    }
    else{
        var popNotOk  = $('#btPopNotOk');
        if( popNotOk.length >0 ){
            popNotOk.trigger('click');
        }
        else{ // Pop up error
            sg.sound('error');
        }
    }
}


//  Suffix _big for the popup img  and   PopUp and Button PopUp  with id = 100
//  <div data-img-zoom  data-src="img/image.png"> <div class="stack"> Apa </div> </div>
//  class="no-style" for no decoration  and  for no pop-up use attribute:  data-no-zoom
//  data-title="Title of popup img"
//  data-no-lock   (no lock images useful on drag exercises)
function divImgPopUp(){
    var divImages = $('div[data-img-zoom]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;

     divImages.each(function(index){

         var divApa = $(this).find('div.stack');
         var imgSrc = $(this).attr("data-src");
         var attrZoom = $(this).attr("data-no-zoom");
         var attrLock = $(this).attr("data-no-lock");
         var attrTitle = $(this).attr("data-title");

         // Create an image in the container 

         var myImg = $("<img src='" + imgSrc + "' />").appendTo($(this));

         // Lock images 

         if( typeof divApa  !== typeof undefined && divApa !== false) {
             var heightStack = divApa.outerHeight();
             divApa.css({'position': 'absolute', 'height': heightStack,  'bottom': -heightStack })
         }

         if( typeof attrLock  == typeof undefined ) { // Lock images for default
             $(myImg).on('mousedown', function(){return false;});
         }


         //End Create Img

         if( typeof attrZoom  === typeof undefined ){ 
             // POP UP 
             var myZoom = $("<div class='zoomImg'></div>").appendTo($(this));

             myZoom.on('click', function(){
                 var content=popUp.find('#imgContainer');
                 content.html(''); //Clear any prev content
                 var baseName =  imgSrc.substr(0, imgSrc.lastIndexOf('.')) || input;
                 var fileExt = imgSrc.split('.').pop();
                 var big = baseName+"_big."+fileExt;
                 var popUpImgContainer = $('<img id="imgContainer">'); 
                 var heightApa = 0;


                 var title=popUp.find('h1');
                 if( typeof attrTitle  != typeof undefined ) { //  Set Img popup Title
                     title.text(attrTitle);
                 }
                 else{
                     title.html('&nbsp;'); //Empty by default 
                 }



                 popUpImgContainer.attr("src",big).load(function(){

                     var width = this.width; 
                     var height = this.height;


                     // Lock Img big 
                     $(this).on('mousedown', function(){return false});

                     if(width > MAX_WIDTH_IMG){
                         ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                         $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                         $(this).css("height", height * ratio);   // Scale height based on ratio
                         height = height * ratio;                 // Reset height to match scaled image
                         width = width * ratio;                   // Reset width to match scaled image
                     }

                     // Check if current height is larger than max
                     if(height > MAX_HEIGHT_IMG){
                         ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                         $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                         $(this).css("width", width * ratio);    // Scale width based on ratio
                         width = width * ratio;    // Reset width to match scaled image
                     }

                     $(this).css({'display': 'block' , 'margin': 'auto'});

                     popUpImgContainer.appendTo(content);  // ADDS the magic!! 

                     btPopUp.trigger('click'); // Activate pop up 

                 }); // End Load
             });
         }
     });
} // Fin Img Pop Up 
