( function( sg ) {
	sg.addCustomTag({
		//custom tag name
		name: "sg-btn-test",
		//origin tag name (swap tag)
		originTag: "span",
		//indentifier
		id: "data-sg-id='btn-test'",
		//use attribute list
		attr: [ "sg-onImg", "sg-swapImg", "sg-sound" ],
		init: null,
		//each init
		tagInit: function( element ){
			var $me = $( element );
			var $child = $( '<span></span>' );
			$me
				.css( "display", "inline-block" )
				.contents().each(function( i, e ){
					$child.append( this );
				});
			$child.css( "visibility", "hidden" ).appendTo( $me );
			$me.data( "$child", $child );
		},
		event: "click",
		eventHandle: function( element, event ){
			var $me = $( element );
			var options = $me.data( "options" );
			
			var $child = $me.data( "$child" );
			$child.css( "visibility", options.visible ? "hidden" : "visible" );
			options.visible = !options.visible;
		}
	});
})( sg )