function validate(evt) {
  var theEvent = evt || window.event;
  var key = theEvent.keyCode || theEvent.which || theEvent.charCode;
  var keyPlain = key;
  key = String.fromCharCode( key );
  var regex = /[0-9]|\,/;
  if( !regex.test(key) && (keyPlain != 8 && keyPlain != 46 && keyPlain != 63272)) {
    theEvent.returnValue = false;
    if(theEvent.preventDefault) theEvent.preventDefault();
  }
  var input=$(theEvent.target);
  var value= input.val();  
}
var initList = initList || [];
initList.push(function() {
  var initialDeg = [0,0,0,0,0,0,0,0];
    $('.ins_btn').click();
     $('.board').find('.protractor').each(function(index, value) {
      sg.setDraggable($(value), {
        success: function() {
          $(value).parent().addClass('hide');
        },
        fail: function() {
            $(value).parent().addClass('hide');
            var left= parseInt($(value).css('left').replace(/px/g,'')); 
            var top = parseInt($(value).css('top').replace(/px/g,''));
            if( left>646 || left<-294){
              $(value).animate({left:'107px',top:'-32px'},500);
            }
            if(top>341 || top<-360){
              $(value).animate({top:'-32px',left:'107px'},500);
            }
            if($(value).hasClass('one')){
              $(value).parent().parent().find('.against').find('img').removeClass('disable').addClass('btn-hover').click(
                function(){
                  var $this = $(this);
                  sg.move(-5,$this);
                });
              $(value).parent().parent().find('.for').find('img').removeClass('disable').addClass('btn-hover').click(
                function(){
                  var $this = $(this);
                  sg.move(5,$this);
                });
            }
            $(value).removeClass('one');
        }
      });
    });

  sg.move = function(angle, button){ 
    var context = button.parent().parent();
    var exercise = context.find('.board').attr('class').replace(/board/g,'').replace(/hide/g,'').replace(/ /g,'').replace(/e/g,'');
    exercise = parseInt(exercise) - 1;
    var $protractor = context.find('.board').find('.protractor');
    initialDeg[exercise] +=angle;
    angle = initialDeg[exercise] + angle;
    $protractor.animate({deg: angle}, {
        duration: 500,
        step: function(now) {
            // in the step-callback (that is fired each step of the animation),
            // you can use the `now` paramter which contains the current
            // animation-position (`0` up to `angle`)
            $protractor.css({
                '-webkit-transform': 'rotate(' + angle + 'deg)',  //Safari 3.1+, Chrome  
                '-moz-transform': 'rotate(' + angle + 'deg)',     //Firefox 3.5-15  
                '-ms-transform': 'rotate(' + angle + 'deg)',      //IE9+  
                '-o-transform': 'rotate(' + angle + 'deg)',       //Opera 10.5-12.00  
                'transform': 'rotate(' + angle + 'deg)',         //Firefox 16+, Opera 12.50+ 
                'transform-origin': '50% 50%'
            });
        }
    });
  }
  sg.check_answer = function(exercise){
    var context = $('.exercise'+exercise);
    var angle = context.find('.angle_ans').val();
    var radT = context.find('.radT_ans').val();
    var radB = context.find('.radB_ans').val();
    var angle_correct = context.find('.angle_ans').attr('data-sg-correct');
    var radT_correct = context.find('.radT_ans').attr('data-sg-correct');
    var radB_correct = context.find('.radB_ans').attr('data-sg-correct');

    console.log(angle+'--'+angle_correct);
    console.log(radT+'--'+radT_correct);
    console.log(radB+'--'+radB_correct);

    var right=true;
    if(angle != angle_correct){
      right= false;
    }
    if (radT != radT_correct){
      right = false;
    }
    if(radB != radB_correct){
      right = false;
    }

    if(!right){
      context.addClass('wrong').removeClass('right');
      sg.sound('error');
    }else{
      context.addClass('right').removeClass('wrong');    
      sg.sound('success');
    }
  }
  sg.restart = function(exercise){
    var $board = $('.board'+exercise);
    var $context = $board.parent();
    var $menu = $context.find('.menu');
    var $exercise = $context.find('.exercise');
    var $forBtn = $context.find('.for').find('img');
    var $againstBtn = $context.find('.against').find('img');

    //Restart board
    $board.removeClass('hide');
    $board.find('.angle').show();
    $board.find('.context').hide();
    $board.find('.protractor').css({
      '-webkit-transform': 'rotate(0deg)',  //Safari 3.1+, Chrome  
      '-moz-transform': 'rotate(0deg)',     //Firefox 3.5-15  
      '-ms-transform': 'rotate(0deg)',      //IE9+  
      '-o-transform': 'rotate(0deg)',       //Opera 10.5-12.00  
      'transform': 'rotate(0deg)',         //Firefox 16+, Opera 12.50+ 
      'transform-origin': '50% 50%',
      'left':'739px',
      'top': '81px'
    }).addClass('one').show();

    //Restart exercise
    $exercise.find('.angle_ans').val('');
    $exercise.find('.radT_ans').val('');
    $exercise.find('.radB_ans').val('');
    $exercise.removeClass('wrong right');
    
    //Restart menu
    $menu.find('.active-btn').removeClass('active-btn');
    $menu.find('.exercise_btn').addClass('active-btn');

    //Restart buttons
    $forBtn.addClass('disable').unbind('click');
    $againstBtn.addClass('disable').unbind('click');

    //Restart values
    var exercise_Int = parseInt(exercise.replace(/.e/g,'')) - 1;
    initialDeg[exercise_Int]=0;
  }
});