var initList = initList || [];
initList.push(function() {
	var soundUrl = '../../common/sounds/clock-ticking.mp3';
	var audio = new Audio(); 
	audio.src = soundUrl;
	audio.setAttribute("data-relativeSrc", soundUrl);
	audio.loop = true;
	audio.load();
	var soundUrl2 = '../../common/sounds/claps.mp3';
	var audio2 = new Audio();
	audio2.src = soundUrl2;
	audio2.setAttribute("data-relativeSrc", soundUrl2);
	audio2.load();

	$('.instructions').click();
	$('block').unbind('click').unbind('mouseleave');


	require(['jquery.countdown'], function(jqCount) {
		

		sg.clock = function() {
			initTimer();
			audio.play();
			$('.item').unbind('click').css('cursor','default');
			$('.container-chronometer').show();
			$('.block').remove();
			$('.start').unbind('click');
			$('.start').removeClass('btn-hover').addClass('disable').css('cursor','default');
			$('.restart').removeClass('disable').addClass('btn-hover').click(sg.restart);
		}

		function initTimer() {
			chronometer.countdown360().stop();
			chronometer.countdown360().start();
		}

		sg.stop = function(){
			chronometer.countdown360().pause();
			audio.pause();
		}


		sg.restart = function(btn){
			audio2.pause();
			audio.play();
			initTimer();
			sg.restartPuzzle();
			$('ul.words').find('span').removeClass('guessed');
		}

		var chronometer = $('<div>').attr('id', 'chronometer');
		$('.container-chronometer').append(chronometer);

		chronometer.countdown360({
				radius: 60,
				seconds: 300,
				fontSize: 40,
				fontColor: '#000000',
				strokeStyle: '#00bdd6',
				fillStyle: '#f2f2f2',
				autostart: false,
				onComplete: function() {
					sg.sound('error');
					sg.restart();
				}
			});
	});    
	require(["./js/sopa_puzzle_v1.0.js"], function(puzzle){		
		puzzle.init({
			level: 3,
			size: 17,
			words: [
				"teodolito",
				"angulos",
				"Aristarco",
				"Luna",
				"Sol",
				"observacion",
				"eclipse",
				"trigonometria",
				"distancias"
			],
			width: 472,
			height: 472,
			success: function(word){
				sg.sound('success');
				var classWord='span.';
				switch(word){
					case 'ANGULOS':
						classWord+='angulos';
						break;
					case 'TEODOLITO':
						classWord+='teodolito';
						break;
					case 'ARISTARCO':
						classWord+='aristarco';
						break;
					case 'SOL':
						classWord+='sol';
						break;
					case 'LUNA':
						classWord+='luna';
						break;
					case 'OBSERVACION':
						classWord+='observacion';
						break;
					case 'ECLIPSE':
						classWord+='eclipse';
						break;
					case 'TRIGONOMETRIA':
						classWord+='trigonometria';
						break;
					case 'DISTANCIAS':
						classWord+='distancias';
						break;
				}
				$('ul.words').find(classWord).addClass('guessed');
				//console.log(word);
			},
			fail: function(){
				sg.sound('error');
			},
			complete: function(){
				audio2.play();
				sg.stop();
			},
			isTest: false
		});	

		sg.restartPuzzle = function(){
			puzzle.restart({
			level: 3,
			size: 17,
			words: [
				"teodolito",
				"angulos",
				"Aristarco",
				"Luna",
				"Sol",
				"observacion",
				"eclipse",
				"trigonometria",
				"distancias"
			],
			width: 472,
			height: 472,
			success: function(word){
				sg.sound('success');
				var classWord='span.';
				switch(word){
					case 'ANGULOS':
						classWord+='angulos';
						break;
					case 'TEODOLITO':
						classWord+='teodolito';
						break;
					case 'ARISTARCO':
						classWord+='aristarco';
						break;
					case 'SOL':
						classWord+='sol';
						break;
					case 'LUNA':
						classWord+='luna';
						break;
					case 'OBSERVACION':
						classWord+='observacion';
						break;
					case 'ECLIPSE':
						classWord+='eclipse';
						break;
					case 'TRIGONOMETRIA':
						classWord+='trigonometria';
						break;
					case 'DISTANCIAS':
						classWord+='distancias';
						break;
				}
				$('ul.words').find(classWord).addClass('guessed');
				//console.log(word);
			},
			fail: function(){
				sg.sound('error');
			},
			complete: function(){
				audio2.play();
				sg.stop();
			},
			isTest: false
		});
		}
	});            
});