// A javascript-enhanced crossword puzzle [c] Jesse Weisbeck, MIT/GPL 


var initList = initList || []; 

initList.push(function(){
(function($) {
	$(function() {
		// provide crossword entries in an array of objects like the following example
		// Position refers to the numerical order of an entry. Each position can have 
		// two entries: an across entry and a down entry
		var puzzleData = [
				// HORIZONTALES
			 	{
					clue: "Teorema visto en clase <em>____</em>",
					answer: "SENO",
					position: 0,
					paintPos:1,
					orientation: "across",
					startx: 5,
					starty: 2
				},
			 	{
					clue: "El lado <em>___________</em> es contrario a la hipotenusa",
					answer: "OPUESTO",
					position: 1,
					paintPos:2,
					orientation: "across",
					startx: 5,
					starty: 4
				},
				{
					clue: "Teorema visto en clase <em>___________</em>",
					answer: "COSENO",
					position: 2,
					paintPos:3,
					orientation: "across",
					startx: 9,
					starty: 6
				},
				{
					clue: "Los teoremas vistos en clase sirven para solucionar actividades relacionadas con triangulos <em>________</em>",
					answer: "OBLICUANGULOS",
					position: 3,
					paintPos:4,
					orientation: "across",
					startx: 4,
					starty: 10
				},
				{
					clue: "El seno se puede aplicar en situaciones donde conocemos <em>________</em> lados del triangulo.",
					answer: "DOS",
					position: 4,
					paintPos:5,
					orientation: "across",
					startx: 14,
					starty: 5
				},

				// DOWN -------------------

				{
					clue: "El teorema del SENO se puede aplicar en situaciones donde conocemos dos lados y el <em>___________</em> comprendido entre ellos",
					answer: "ANGULO",
					position:5 ,
					paintPos:1,
					orientation: "down",
					startx: 7,
					starty: 1
				},
				{
					clue: "El teorema del COSENO se puede aplicar en situaciones donde conocemos dos <em>___________</em> del triangulo",
					answer: "LADOS",
					position: 6,
					paintPos:2,
					orientation: "down",
					startx: 14,
					starty: 3
				},
				{
					clue: "El <em>_________</em> del seno tiene 2 requisitos",
					answer: "TEOREMA",
					position: 7,
					paintPos:3,
					orientation: "down",
					startx: 11,
					starty: 4
				},
				{
					clue: "Los triángulos oblicuángulos se caracterizan por no tener ángulos<em>________</em>",
					answer: "RECTOS",
					position: 8,
					paintPos:4,
					orientation: "down",
					startx: 4,
					starty: 6
				},
			] 
	
		$('#puzzle-wrapper').crossword(puzzleData);		
	})
	
})(jQuery)
});
