// A javascript-enhanced crossword puzzle [c] Jesse Weisbeck, MIT/GPL 


var initList = initList || []; 

initList.push(function(){
(function($) {
	$(function() {
		// provide crossword entries in an array of objects like the following example
		// Position refers to the numerical order of an entry. Each position can have 
		// two entries: an across entry and a down entry
		var puzzleData = [
				// HORIZONTALES
			 	{
					clue: "Las razones <em>___________</em> son seno, coseno, tangente cosecante, secante y cotangente.",
					answer: "TRIGONOMETRICAS",
					position: 0,
					paintPos:1,
					orientation: "across",
					startx: 2,
					starty: 11
				},
			 	{
					clue: "El <em>___________</em> rectángulo en la circunferencia unitaria es usado para identificar las razones trigonométricas",
					answer: "TRIANGULO",
					position: 1,
					paintPos:2,
					orientation: "across",
					startx: 9,
					starty: 2
				},
				{
					clue: "El <em>__________</em> de una circunferencia está dado por el segmento que une dos puntos de la circunferencia y paso por su centro.",
					answer: "DIAMETRO",
					position: 2,
					paintPos:3,
					orientation: "across",
					startx: 2,
					starty: 13
				},

				// DOWN -------------------
				{
					clue: "La circunferencia <em>________</em> es la circunferencia que pasa por todos los vértices de una figura plana y contiene completamente a dicha figura en su interior.",
					answer: "CIRCUNSCRITA",
					position: 3,
					paintPos:1,
					orientation: "down",
					startx: 11,
					starty: 1
				},
				{
					clue: "El triángulo rectángulo en la circunferencia unitaria es usado para identificar las <em>___________</em> trigonométricas",
					answer: "RAZONES",
					position:4 ,
					paintPos:2,
					orientation: "down",
					startx: 15,
					starty: 10
				},
				{
					clue: "El <em>___________</em> es exactamente la mitad del diámetro.",
					answer: "RADIO",
					position: 5,
					paintPos:3,
					orientation: "down",
					startx: 8,
					starty: 7
				},
				{
					clue: "La <em>_________</em> o perímetro de una circunferencia se halla con la fórmula <span class='fontin'>L=πr.</span>",
					answer: "LONGITUD",
					position: 6,
					paintPos:4,
					orientation: "down",
					startx: 2,
					starty: 6
				},
				{
					clue: "El <em>________</em> de un circulo se halla con la fórmula <span class='fontin'>A=πr<sup2</sup>.</span>",
					answer: "AREA",
					position: 7,
					paintPos:5,
					orientation: "down",
					startx: 4,
					starty: 13
				},
				{
					clue: "Una circunferencia <em>________</em> en un polígono regular es aquella que, siendo interior, es tangente a todos sus lados.",
					answer: "INSCRITA",
					position: 8,
					paintPos:6,
					orientation: "down",
					startx: 13,
					starty: 6
				}
			] 
	
		$('#puzzle-wrapper').crossword(puzzleData);		
	})
	
})(jQuery)
});
