// A javascript-enhanced crossword puzzle [c] Jesse Weisbeck, MIT/GPL 


var initList = initList || []; 

initList.push(function(){
(function($) {
	$(function() {
		// provide crossword entries in an array of objects like the following example
		// Position refers to the numerical order of an entry. Each position can have 
		// two entries: an across entry and a down entry
		var puzzleData = [
			 	{
					clue: "Conjunto de valores donde se mueve la función.",
					answer: "RANGO",
					position: 0,
					paintPos:1,
					orientation: "across",
					startx: 8,
					starty: 2
				},
			 	{
					clue: "Tipo de función en la cual si a < b entonces f(a) = f(b) para todo a,b ∈ R",
					answer: "CONSTANTE",
					position: 1,
					paintPos:2,
					orientation: "across",
					startx: 6,
					starty: 5
				},
				{
					clue: "Correspondencia entre dos conjuntos donde a cada elemento del primer conjunto le corresponde un único elemento del segundo conjunto.",
					answer: "FUNCION",
					position: 2,
					paintPos:3,
					orientation: "across",
					startx: 3,
					starty: 8
				},
				{
					clue: "Tipo de función en la cual si a < b entonces f(a) < f(b) para todo a,b ∈ R",
					answer: "CRECIENTE",
					position: 3,
					paintPos:4,
					orientation: "across",
					startx: 4,
					starty: 10
				},
				{
					clue: "Función cuyo domino es finito.",
					answer: "FINITA",
					position: 4,
					paintPos:5,
					orientation: "across",	
					startx: 2,
					starty: 12
				},

				// DOWN -------------------
				{
					clue: "Conjunto de valores donde está definida la función.",
					answer: "DOMINIO",
					position: 5,
					paintPos:1,
					orientation: "down",
					startx: 12,
					starty: 1
				},
				{
					clue: "Tipo de función en la cual si a < b entonces f(a) > f(b) para todo a,b ∈ R",
					answer: "DECRECIENTE",
					position: 6,
					paintPos:2,
					orientation: "down",
					startx: 6,
					starty: 3
				},
				{
					clue: "Función cuyo domino es infinito.",
					answer: "INFINITA",
					position: 7,
					paintPos:3,
					orientation: "down",
					startx: 3,
					starty: 12
				}
			] 
	
		$('#puzzle-wrapper').crossword(puzzleData);		
	})
	
})(jQuery)
});
