var initList = initList || [];
initList.push(function() {

    var claps = new Audio();
    var soundUrl = "../../common/sounds/claps.mp3";
    claps.src = soundUrl;
    claps.setAttribute("data-relativeSrc", soundUrl);
    claps.load();
    claps.loop = true;
    claps.volume = 1;
    sg.audio = function() {
        claps.play();
    }
    sg.audioStop = function() {
        claps.pause();
    }

    //limit of drags series
    var limits = {'tab1':8, 'tab4':5};
    $('.drags').find('.drag').each(function(index, value) {
        var dropSelector = $(value).attr('data-sg-drop-selector');
        var parent = $(dropSelector).parent().parent().attr('class').replace(/content/g, '').replace(/ /g, '');
        
        sg.setDraggable($(value), {
            revert: true,
            dropSelector: dropSelector,
            success: function() {

                var $this = $(this);
                var drop = $this.data("hit").eq(0);

                $this.attr("data-sg-selected", ("#" + drop.attr("id")));
                $this.addClass('clones');
                drop.attr("id", (drop.attr("id") + "_fill"));

                var boton = $("."+parent+" .btnCheck");
                var attempts = parseInt(boton.attr("data-sg-count")) + 1;
                boton.attr("data-sg-count", attempts);
                if (attempts == limits[parent]) {
                    boton.bind("click", function(){
                        revisar(parent);
                    });
                    boton.addClass("ready shake");
                    boton.css('cursor', 'pointer');
                }
                sg.sound('success');
            }
        });
    });

    function revisar(parent) {
        var boton = $("."+parent+" .btnCheck");
        var num_corrects = 0;

        $('.clones').each(function() {
            $this = $(this);
            var correct = $this.attr("data-sg-correct").split(',');
            var selected = $this.attr("data-sg-selected");

            if (correct.indexOf(selected) != -1) {
                $this.addClass("correct");
                num_corrects++;
            } else {
                var elem_selected = $(selected + "_fill");
                var new_id = selected.replace(/_fill/g, '').replace(/#/g, '');
                elem_selected.text("").attr("id", new_id);

                var id_drag = "#" + $this.attr("id");
                $(id_drag).css("visibility", "visible");
                $this.css("display", "none").remove();
                var attempts = parseInt(boton.attr("data-sg-count")) - 1;
                boton.attr("data-sg-count", attempts).removeClass("ready").removeClass("shake").unbind("click", revisar);
                boton.css('cursor', 'default');
            }
        });

        if (num_corrects == limits[parent]) {
            boton.unbind("click", revisar);
            boton.css('cursor', 'default');
            boton.addClass('completed');
            sg.audio();
        } else {           
            sg.sound('error');
        }

    }

    sg.restart = function() {
        sg.resetDraggable($('.content').find("[data-sg-draggable]"));
        sg.audioStop();

        $(".clones").remove();
        $("div[id$='_fill']").each(function(index, value) {
            var $this = $(this);
            var attrId = $this.attr('id').replace(/_fill/g, '').replace(/#/g, '');
            $this.attr("id", attrId);
        });
        $('.btnCheck').attr('data-sg-count', 0).removeClass('completed').removeClass('ready shake');
    }

    $('[data-sg-id=elem-tab]').bind("easytabs:before", function(){
        sg.restart();
    }).easytabs();

});
