function validate(evt) {
  var theEvent = evt || window.event;
  var key = theEvent.keyCode || theEvent.which || theEvent.charCode;
  var keyPlain = key;
  key = String.fromCharCode(key);
  var regex = /[0-9]|\,/;
  if (!regex.test(key) && (keyPlain != 8 && keyPlain != 46 && keyPlain != 63272)) {
    theEvent.returnValue = false;
    if (theEvent.preventDefault) theEvent.preventDefault();
  }
  var input = $(theEvent.target);
  var value = input.val();
}

var initList = initList || [];
initList.push(function() {
  var totalInputs = {'1':1,'2':4};
  
  $( "input[type='text']" ).change(function() {
    $(this).addClass('complete');
    var exe = $(this).parent().parent().attr('data-sg-key');
    var total = $(this).parent().find('.complete').length;
    if(total == totalInputs[exe]){
      var page = $(this).parent().parent();
      page.find('.btn-check').unbind('click');
      page.find('.btn-check').addClass('btn-hover shake').click(function(){
        sg.check(exe,$(this));
      });
    }
  });

  sg.check = function(exe, btn){
    var inputs_search = '.content .page'+exe+' .inputs_box input';
    var inputs = $(inputs_search);
    var right = true;
    inputs.each(function(index, value){
      var $this = $(this);
      var value = $this.val();
      //Acute case (Only one)
      if(value.toUpperCase()=='SI'){
        value = 'Sí';
      }
      var correct = $this.attr('data-sg-correct');
      if(value.toUpperCase() != correct.toUpperCase()){
        $(this).addClass('wrong');
        right = false;
      }else{
        $(this).val(correct);
        $this.removeClass('wrong');
        $(this)[0].readOnly = true;
      }
    });

    if(right){
      sg.sound('success');
      $(btn).removeClass('btn-hover shake').addClass('complete').unbind('click');
      $(btn).parent().find('.btn-answer').removeClass('btn-hover').unbind('click');
      return;
    }else{
      sg.sound('error');
    }
    $(btn).parent().find('.btn-answer').unbind('click');
    $(btn).parent().find('.btn-answer').click(function(){
      sg.answer(exe, $(this));
    }).addClass('btn-hover');
  }

  sg.answer = function(exe, btn){
    sg.sound('success');
    var inputs_search = '.content .page'+exe+' .inputs_box input';
    var inputs = $(inputs_search);
    inputs.each(function(index, value){
      var $this = $(this);
      $(this).removeClass('wrong');
      $this.val($this.attr('data-sg-correct'));
      $(this)[0].readOnly = true;
    });
    $(btn).removeClass('btn-hover');
    $(btn).unbind('click');
    $(btn).parent().find('.btn-check').removeClass('btn-hover shake').addClass('complete').unbind('click');
  }
});