/*!
 * crossWord, v1.0, MIT License
 * https://github.com/Zx12/crossWord
 * bryzgalovd@gmail.com
 */
(function($){
	function createTable(options){
		// определение размера таблицы
		var col = 0;var row = 0;
		for(var index in options.data){
			var item = options.data[index];
			if(item.direct=='ver'){
				var xx = item.x;var yy = item.y + (item.text.length - 1);
				if(xx > col){ col = xx; }
				if(yy > row){ row = yy; }
			}else{
				var xx = item.x + (item.text.length - 1);var yy = item.y;
				if(xx > col){ col = xx; }
				if(yy > row){ row = yy; }
			}
		}
		// создание таблицы
		var table = $('<table class="table"></table>');
		if(options.debug){
			table.addClass('__debug');
		}
		for(ii=1;ii<=row;ii++){
			var tr = $('<tr></tr>');
			for(jj=1;jj<=col;jj++){
				var item = $('<td><div class="item"></div></td>');
				tr.append(item);					
				if(options.debug && jj==1){
					$('.item', item).append('<div class="item_y">'+ii+'</div>');
				}
				if(options.debug && ii==1){
					$('.item', item).append('<div class="item_x">'+jj+'</div>');
				}
			};
			table.append(tr);
		};
		// добавление слов
		for(var word_index in options.data){
			var item = options.data[word_index];
			if(item.direct=='hor'){
				var tr = $('tr', table).eq(item.y-1);
				var td = $('td', tr).slice(item.x-1, item.x-1+item.text.length);
			}
			if(item.direct=='ver'){
				var tr = $('tr', table);
				var td = $('td:nth-child('+item.x+')', tr);
				var td = td.slice(item.y-1, item.y-1+item.text.length);
			}
			td.addClass('__letter');
			var word = $('.item', td);
			word.each(function(letter_index){	
				word_item = $(this).addClass('__letter');
				var text = $('.text', word_item);
				if(text.size()==0){
					var text = $('<div class="text"></div>');
					word_item.append(text);
				}
				var letter = $('<div class="letter"></div>');
				letter.data('word_index', word_index).addClass('word'+word_index);
				letter.data('letter_index', letter_index).addClass('letter'+letter_index);
				
				word_item.append(letter);
				
				if(letter_index==0){
					word_item.append('<div class="word_num __'+item.direct+'">'+(+word_index+1)+'</div>');
				}
				if(options.debug){
					word_item.append('<div class="item_debug">'+item.text.charAt(letter_index)+'</div>').addClass('__debug');
				}
			});
		}
		return table;
	}
	
	function createQuestions(options){
		// создание списка вопросов
		var questions_list = $('<ol class="ol"></ul>');
		for(var word_index in options.data){
			var question = options.data[word_index].question;
			questions_list.append('<li>'+question+'</li>');
		}
		return questions_list;
	}

	$.fn.crossWord = function(options){
		var options = $.extend({data:[],debug:1}, options);
		var wrap = this.empty();
		var input = $('<input class="input" type="text" value="">').appendTo(wrap);
		var questions = $(options.questions).empty();
		var table_words = createTable(options).appendTo(wrap);
		var questions_list = createQuestions(options).appendTo(questions);
		var questions_listitem = $('li', questions_list);
		
		var items = $('.item', table_words);
		var letters = $('.letter', table_words);
		// выбор слова по клику на букву
		(function(){
			items.each(function(){
				var word = 0;
				var item = $(this);
				var letter = $('.letter', item);
				var letter_size = letter.size();
				item.on({
					'click':function(ev){
						if(letter_size==2){
							word = (word==0) ? 1 : 0;
							var let = letter.eq(word);
						}else{
							var let = letter;
						}
						var word_index = let.data('word_index');
						var letter_index = let.data('letter_index');	
						wordSelect(word_index, letter_index);
					}
				});
			});
		})();
		// список вопросов
		questions_listitem.each(function(word_index){
			var listitem = $(this);
			listitem.on({
				'click':function(ev){
					wordSelect(word_index, 0);
				}
			});
		});
		// выбор слова
		function wordSelect(word_index, letter_index){
			var word = letters.filter('.word'+word_index);
			var word_item = word.parent();
			items.removeClass('__word_select');
			word_item.addClass('__word_select');
			
			var word_letter = word.filter('.letter'+letter_index);
			if(word_letter.size() > 0){
				letters.removeClass('__letter_select');
				word_letter.addClass('__letter_select');
				var word_letter_item = word_letter.parent();
				items.removeClass('__letter_select');
				word_letter_item.addClass('__letter_select');
				input.offset(word_letter_item.offset()).focus();
			}
			questions_listitem.removeClass('__select').eq(word_index).addClass('__select');
		}
		// установка значения
		function setValue(val){
			var item = items.filter('.__letter_select');
			$('.text', item).html(val);
			var letter = $('.letter', item);
			testWords();
		}
		// собирает слово из букв
		function collectWord(word_index){
			var word_letter = letters.filter('.word'+word_index);
			var word = '';
			word_letter.each(function(){
				var item = $(this).parent();
				var text = $('.text', item).text();
				if(text.length > 0){
					word = word + text;
				}
			});
			return word;
		}
		// функуция раскраски слова
		function colorizeWord(word_index_array, color){
			for(var index in word_index_array){
				var word_index = word_index_array[index];
				var word_item = letters.filter('.word'+word_index).parent();
				var questions = questions_listitem.eq(word_index);
				word_item.removeClass('__error __success');
				questions.removeClass('__success');
				switch(color){
					case 'error':
						word_item.addClass('__error');
					break;
					case 'success':
						word_item.addClass('__success');
						questions.addClass('__success');
					break;
					case 'notfull':
						word_item.removeClass('__error __success');
					break;
					default:;
				}
			}
		}
		// функуция проверки слова
		function testWords(){
			var notfull = [];
			var success = [];
			var error = [];
			for(var word_index in options.data){
				var origin_text = options.data[word_index].text;
				var word_test = collectWord(word_index);
				origin_text = origin_text.toUpperCase();
				word_test = word_test.toUpperCase();
				if(word_test.length != origin_text.length){
					// если разная длинна слов
					notfull.push(word_index);
				}else if(word_test == origin_text){
					// если всё сходится
					success.push(word_index);
				}else{
					// если не сходится
					error.push(word_index);
				}
			}
			colorizeWord(notfull, 'notfull');
			colorizeWord(error, 'error');
			colorizeWord(success, 'success');
			if( (success.length == options.data.length) && (typeof(options.success) == 'function') ){
				// кросворд разгадан
				options.success();
			}
		}
		// события клавиатуры
		input.on({
			'keydown':function(ev){
				this.value = '';
			},
			'keyup':function(ev){
				var code = (ev.keyCode) ? ev.keyCode : ev.charCode;
				if(code==13){
					return false;
				};
				if(code==8){
					setValue('');
					letterNav(-1);
					setValue('');
					return false;
				};
				if(code==37 || code==38){
					letterNav(-1);
					return false;
				}
				if(code==39 || code==40){
					letterNav(+1);
					return false;
				}
				var val = this.value.toUpperCase();
				setValue(val);
				letterNav(+1);
			}
		});
		// навигация по слову
		function letterNav(direct){
			var item = items.filter('.__letter_select');
			var letter = $('.__letter_select', item);
			var letter_index = letter.data('letter_index');
			var word_index = letter.data('word_index');
			wordSelect(word_index, letter_index+direct);
		}
		
		$('.input').keyup(function() {
            if (this.value.match(/[^a-zA-Z]/g)) {
                this.value = this.value.replace(/[^a-zA-Z]/g, '');
            }
        });
	// енд
	}
})(jQuery);


