/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // creation complete
         sym.$('.center-wrapper').css("overflow","hidden");
         /**
          * Añadir los nombres de los labels
          * Eliminar comentarios de las pestañas que se requieran
          */
         objetivos = "Escribe aquí tus objetivos.";
         TotalTabs = 2;    // Modificar el valor si se requieren mas de 2 pestañas, máximo 3
         
         if(TotalTabs == 2){
         	sym.setVariable("labels", {
         	content1: "Propón tus Objetivos",   
         	content2: "Objetivos Propuestos"
         	});
         }
         if(TotalTabs == 3){
         	sym.setVariable("labels", {
         		content1: "Propón tus Objetivos",   
         		content2: "Objetivos Propuestos",
         		content3: "Objetivos Propuestos"   
         	});
         }
         
         /**
          * Don't modify the code below.
         
         */
         // Mostrar un elemento 
         // Clear initial state
         sym.getSymbol("tab").deleteSymbol();
         // Find all large symbols in the library
         var prefix = "content"; // content1, content2 ... content99
         var allTabs = [];
         
         var j=4;
         var symbolDefns = sym.getComposition().sym;
         
         for (var i=1; i<= TotalTabs; i++) { 
             var tab = sym.createChildSymbol( "tab", "navigation" );
             var idTab = "content"+i;
             //cambiar el margen según  
             tab.setVariable("contentId", idTab); 
             //tab.prop("id","tab_"+i);
             //sym.getVariable("firstTab") ? null : sym.setVariable("firstTab", tab);
             sym.setVariable("firstTab", tab);    
             allTabs.push(tab);
             tab.$("btnLabel").html( sym.getVariable("labels")[idTab] || "undefined" );
             $tabEl = tab.getSymbolElement();
             $tabEl.data("sym", tab);
             //$tabEl.css({float: "left", margin: "0 auto auto 0"});
             $tabEl.attr("id","Stage_"+j);
             j++;
             $tabEl.click(function(evt){
         	//poner texto según el momento de la actividad
         	//$(sym.lookupSelector("momento")).html(sym.getVariable("labels")[key] || "undefined" ); 
             	var tabSym = $(evt.currentTarget).data("sym");
             		$.each(allTabs, function(index,item) {
         	    		if (item != tabSym) { 
         	    			item.stop("normal"); item.setVariable("active", false); 
             			}
             		});
         
         			var $content = sym.$("content").empty();
             		sym.createChildSymbol(tabSym.getVariable("contentId"), "content");
             });
           //} 
         }
         

      });
      //Edge binding end

 

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         // Initially activate first Tab
         var firstTab = sym.getVariable("firstTab");
         //firstTab.stop("active");
         $("#Stage_4").trigger("click");
         firstTab.setVariable("active", true);
         
         /*
         	Para ingresar 3 o más pestañas agregar comentario en el posicionamiento de 2 pestañas 
         	tal como lo indican los posicionamientos siguientes, y eliminar el comentario del
         	posicionamiento que se necesite
         */
         
         
         //  Posicionamiento para 2 pestañas
         if(TotalTabs == 2){
         	sym.$("navigation").css({position:"relative",width:"auto", margin: "0 auto auto 1080px"});
         	sym.$("#Stage_4").css("margin","0 auto auto -250px");
         }
         
         //  Posicionamiento para 3 pestañas
         if(TotalTabs == 3){
         	sym.$("navigation").css({position:"relative",width:"auto", margin: "0 auto auto 850px"});
         	sym.$("#Stage_4").css("margin","0 auto auto -250px");
         	sym.$("#Stage_6").css("margin","0 auto auto 250px");
         }
         
         //  Posicionamiento para 4 pestañas
         /*
         sym.$("navigation").css({position:"relative",width:"auto", margin: "0 auto auto 750px"});
         sym.$("#Stage_4").css("margin","0 auto auto -190px");
         sym.$("#Stage_7").css("margin","0 auto auto 190px");
         sym.$("#Stage_5").css("margin","0 auto auto 380px");
         */
         
         $(".Stage_4_btnLabel_id").css("cursor","pointer");
         $(".Stage_5_btnLabel_id").css("cursor","pointer");
         $(".Stage_6_btnLabel_id").css("cursor","pointer");
         $(".Stage_7_btnLabel_id").css("cursor","pointer");
         
         objetivos = "Escribe aquí tus objetivos.";
         

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'content1'
   (function(symbolName) {   
   
   })("content2");
   //Edge symbol end:'content2'

   //=========================================================
   
   //Edge symbol: 'tab'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Register handler for mouse events to switch between states
         var el = sym.getSymbolElement();
         el.mouseenter(function(evt){ if (!sym.getVariable("active")) sym.stop("over");});
         el.mouseleave(function(evt){ if (!sym.getVariable("active")) sym.stop("normal");});
         el.mousedown(function(evt){ if (!sym.getVariable("active")) sym.stop("down");});
         el.click(function(evt){ sym.stop("active"); sym.setVariable("active", true); });

      });
      //Edge binding end

   })("tab");
   //Edge symbol end:'tab'

   //=========================================================
   
   //Edge symbol: 'content1_1'
   (function(symbolName) {   
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Mostrar un elemento 
         var textArea=document.createElement("TextArea");
         textArea.id="textArea";
         textArea.value= objetivos;
         textArea.style.width= "1140px";
         textArea.style.height= "400px"; 
         textArea.style.border= "none";
         textArea.style.background= "#FFFFFF";
         textArea.style.fontSize= "42px";
         textArea.style.lineHeight= "40px";
         textArea.style.textAlign="left";
         textArea.style.margin="10px";
         textArea.style.fontFamily="Cabin";
         textArea.style.fontStyle="normal";
         textArea.style.color="#666666";
         // Mostrar un elemento 
         sym.$("objetivos_2").append(textArea);
         $("#textArea").keyup(function(){
         myValue = $('#textArea').val();
         objetivos= myValue;
         //console.log(myValue);
         });
         
         $("#textArea").focus(function() {
            $(this).val('');
         });
         
         

      });
      //Edge binding end

      })("content1");
   //Edge symbol end:'content1'

   //=========================================================
   
   //Edge symbol: 'content2_1'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Mostrar un elemento 
         var textArea=document.createElement("TextArea");
         textArea.id="textArea";
         textArea.value= objetivos;
         textArea.style.width= "1140px";
         textArea.style.height= "400px"; 
         textArea.style.border= "none";
         textArea.style.background= "#FFFFFF";
         textArea.style.fontSize= "42px";
         textArea.style.lineHeight= "40px";
         textArea.style.textAlign="left";
         textArea.style.margin="10px";
         textArea.style.fontFamily="Cabin";
         textArea.style.fontStyle="normal";
         textArea.style.color="#666666";
         // Mostrar un elemento 
         sym.$("objetivos_2").append(textArea);
         $("#textArea").keyup(function(){
         myValue = $('#textArea').val();
         objetivos= myValue;
         //console.log(myValue);
         });
         
         $("#textArea").focus(function() {
            $(this).val('');
         });
         
         

      });
         //Edge binding end

         })("content3");
   //Edge symbol end:'content3'

   //=========================================================
   
   //Edge symbol: 'content3_1'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Mostrar un elemento 
         var textArea=document.createElement("TextArea");
         textArea.id="textArea";
         textArea.value= objetivos;
         textArea.style.width= "1140px";
         textArea.style.height= "400px"; 
         textArea.style.border= "none";
         textArea.style.background= "#FFFFFF";
         textArea.style.fontSize= "42px";
         textArea.style.lineHeight= "40px";
         textArea.style.textAlign="left";
         textArea.style.margin="10px";
         textArea.style.fontFamily="Cabin";
         textArea.style.fontStyle="normal";
         textArea.style.color="#666666";
         // Mostrar un elemento 
         sym.$("objetivos_2").append(textArea);
         $("#textArea").keyup(function(){
         myValue = $('#textArea').val();
         objetivos= myValue;
         //console.log(myValue);
         });
         
         $("#textArea").focus(function() {
            $(this).val('');
         });
         
         

      });
         //Edge binding end

         })("content3_1");
   //Edge symbol end:'content3_1'

})(jQuery, AdobeEdge, "EDGE-7842103");